/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ModuleServiceRepository {
    private ModuleModel moduleModel;
    private ConcurrentMap<String, List<ServiceDescriptor>> services = new ConcurrentHashMap<String, List<ServiceDescriptor>>();
    private ConcurrentMap<String, List<ConsumerModel>> consumers = new ConcurrentHashMap<String, List<ConsumerModel>>();
    private ConcurrentMap<String, ProviderModel> providers = new ConcurrentHashMap<String, ProviderModel>();
    private final FrameworkServiceRepository frameworkServiceRepository;

    public ModuleServiceRepository(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
        this.frameworkServiceRepository = ScopeModelUtil.getFrameworkModel(moduleModel).getServiceRepository();
    }

    public ModuleModel getModuleModel() {
        return this.moduleModel;
    }

    @Deprecated
    public void registerConsumer(String serviceKey, ServiceDescriptor serviceDescriptor, ReferenceConfigBase<?> rc, Object proxy, ServiceMetadata serviceMetadata) {
        ConsumerModel consumerModel = new ConsumerModel(serviceMetadata.getServiceKey(), proxy, serviceDescriptor, rc, serviceMetadata, null);
        this.registerConsumer(consumerModel);
    }

    public void registerConsumer(ConsumerModel consumerModel) {
        this.consumers.computeIfAbsent(consumerModel.getServiceKey(), serviceKey -> new CopyOnWriteArrayList()).add(consumerModel);
    }

    @Deprecated
    public void registerProvider(String serviceKey, Object serviceInstance, ServiceDescriptor serviceModel, ServiceConfigBase<?> serviceConfig, ServiceMetadata serviceMetadata) {
        ProviderModel providerModel = new ProviderModel(serviceKey, serviceInstance, serviceModel, serviceConfig, serviceMetadata);
        this.registerProvider(providerModel);
    }

    public void registerProvider(ProviderModel providerModel) {
        this.providers.putIfAbsent(providerModel.getServiceKey(), providerModel);
        this.frameworkServiceRepository.registerProvider(providerModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDescriptor registerService(Class<?> interfaceClazz) {
        List serviceDescriptors;
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor(interfaceClazz);
        List list = serviceDescriptors = this.services.computeIfAbsent(interfaceClazz.getName(), _k -> new CopyOnWriteArrayList());
        synchronized (list) {
            Optional<ServiceDescriptor> previous = serviceDescriptors.stream().filter(s -> s.getServiceInterfaceClass().equals(interfaceClazz)).findFirst();
            if (previous.isPresent()) {
                return previous.get();
            }
            serviceDescriptors.add(serviceDescriptor);
            return serviceDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDescriptor registerService(String path, Class<?> interfaceClass) {
        ServiceDescriptor serviceDescriptor = this.registerService(interfaceClass);
        if (!interfaceClass.getName().equals(path)) {
            List serviceDescriptors;
            List list = serviceDescriptors = this.services.computeIfAbsent(path, _k -> new CopyOnWriteArrayList());
            synchronized (list) {
                Optional<ServiceDescriptor> previous = serviceDescriptors.stream().filter(s -> s.getServiceInterfaceClass().equals(serviceDescriptor.getServiceInterfaceClass())).findFirst();
                if (previous.isPresent()) {
                    return previous.get();
                }
                serviceDescriptors.add(serviceDescriptor);
                return serviceDescriptor;
            }
        }
        return serviceDescriptor;
    }

    @Deprecated
    public void reRegisterProvider(String newServiceKey, String serviceKey) {
        ProviderModel providerModel = (ProviderModel)this.providers.get(serviceKey);
        providerModel.setServiceKey(newServiceKey);
        this.providers.putIfAbsent(newServiceKey, providerModel);
        this.providers.remove(serviceKey);
    }

    @Deprecated
    public void reRegisterConsumer(String newServiceKey, String serviceKey) {
        List consumerModel = (List)this.consumers.get(serviceKey);
        consumerModel.forEach(c -> c.setServiceKey(newServiceKey));
        this.consumers.computeIfAbsent(newServiceKey, k -> new CopyOnWriteArrayList()).addAll(consumerModel);
        this.consumers.remove(serviceKey);
    }

    public void unregisterService(Class<?> interfaceClazz) {
        this.unregisterService(interfaceClazz.getName());
    }

    public void unregisterService(String path) {
        this.services.remove(path);
    }

    public void unregisterProvider(ProviderModel providerModel) {
        this.frameworkServiceRepository.unregisterProvider(providerModel);
        this.providers.remove(providerModel.getServiceKey());
    }

    public void unregisterConsumer(ConsumerModel consumerModel) {
        ((List)this.consumers.get(consumerModel.getServiceKey())).remove(consumerModel);
    }

    public List<ServiceDescriptor> getAllServices() {
        List serviceDescriptors = this.services.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return Collections.unmodifiableList(serviceDescriptors);
    }

    public ServiceDescriptor lookupService(String interfaceName) {
        if (this.services.containsKey(interfaceName)) {
            List serviceDescriptors = (List)this.services.get(interfaceName);
            return serviceDescriptors.size() > 0 ? (ServiceDescriptor)serviceDescriptors.get(0) : null;
        }
        return null;
    }

    public MethodDescriptor lookupMethod(String interfaceName, String methodName) {
        ServiceDescriptor serviceDescriptor = this.lookupService(interfaceName);
        if (serviceDescriptor == null) {
            return null;
        }
        List<MethodDescriptor> methods = serviceDescriptor.getMethods(methodName);
        if (CollectionUtils.isEmpty(methods)) {
            return null;
        }
        return methods.iterator().next();
    }

    public List<ProviderModel> getExportedServices() {
        return Collections.unmodifiableList(new ArrayList(this.providers.values()));
    }

    @Deprecated
    public ProviderModel lookupExportedService(String serviceKey) {
        return (ProviderModel)this.providers.get(serviceKey);
    }

    public List<ConsumerModel> getReferredServices() {
        List consumerModels = this.consumers.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return Collections.unmodifiableList(consumerModels);
    }

    @Deprecated
    public ConsumerModel lookupReferredService(String serviceKey) {
        if (this.consumers.containsKey(serviceKey)) {
            List consumerModels = (List)this.consumers.get(serviceKey);
            return consumerModels.size() > 0 ? (ConsumerModel)consumerModels.get(0) : null;
        }
        return null;
    }

    @Deprecated
    public List<ConsumerModel> lookupReferredServices(String serviceKey) {
        return (List)this.consumers.get(serviceKey);
    }

    public void destroy() {
        for (ProviderModel providerModel : this.providers.values()) {
            this.frameworkServiceRepository.unregisterProvider(providerModel);
        }
        this.providers.clear();
        this.consumers.clear();
        this.services.clear();
    }
}

