/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ServiceModel {
    private String serviceKey;
    private Object proxyObject;
    private Callable<Void> destroyCaller;
    private ClassLoader classLoader;
    private final ModuleModel moduleModel;
    private final ServiceDescriptor serviceModel;
    private final AbstractInterfaceConfig config;
    private ServiceMetadata serviceMetadata;

    public ServiceModel(Object proxyObject, String serviceKey, ServiceDescriptor serviceModel, AbstractInterfaceConfig config) {
        this(proxyObject, serviceKey, serviceModel, config, null);
    }

    public ServiceModel(Object proxyObject, String serviceKey, ServiceDescriptor serviceModel, AbstractInterfaceConfig config, ServiceMetadata serviceMetadata) {
        this(proxyObject, serviceKey, serviceModel, config, ScopeModelUtil.getModuleModel(config != null ? config.getScopeModel() : null), serviceMetadata);
    }

    public ServiceModel(Object proxyObject, String serviceKey, ServiceDescriptor serviceModel, AbstractInterfaceConfig config, ModuleModel moduleModel, ServiceMetadata serviceMetadata) {
        this.proxyObject = proxyObject;
        this.serviceKey = serviceKey;
        this.serviceModel = serviceModel;
        this.moduleModel = moduleModel;
        this.config = config;
        this.serviceMetadata = serviceMetadata;
        if (serviceMetadata != null) {
            serviceMetadata.setServiceModel(this);
        }
        if (config != null) {
            this.classLoader = config.getInterfaceClassLoader();
        }
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setProxyObject(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public ServiceDescriptor getServiceModel() {
        return this.serviceModel;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<MethodDescriptor> getAllMethods() {
        return this.serviceModel.getAllMethods();
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceModel.getServiceInterfaceClass();
    }

    public AbstractInterfaceConfig getConfig() {
        return this.config;
    }

    public ReferenceConfigBase<?> getReferenceConfig() {
        if (this.config == null) {
            return null;
        }
        if (this.config instanceof ReferenceConfigBase) {
            return (ReferenceConfigBase)this.config;
        }
        throw new IllegalArgumentException("Current ServiceModel is not a ConsumerModel");
    }

    public ServiceConfigBase<?> getServiceConfig() {
        if (this.config == null) {
            return null;
        }
        if (this.config instanceof ServiceConfigBase) {
            return (ServiceConfigBase)this.config;
        }
        throw new IllegalArgumentException("Current ServiceModel is not a ProviderModel");
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
        if (this.serviceMetadata != null) {
            this.serviceMetadata.setServiceKey(serviceKey);
            this.serviceMetadata.setGroup(BaseServiceMetadata.groupFromServiceKey(serviceKey));
        }
    }

    public String getServiceName() {
        return this.serviceMetadata.getServiceKey();
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public ModuleModel getModuleModel() {
        return this.moduleModel;
    }

    public Callable<Void> getDestroyCaller() {
        return this.destroyCaller;
    }

    public void setDestroyCaller(Callable<Void> destroyCaller) {
        this.destroyCaller = destroyCaller;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceModel that = (ServiceModel)o;
        return Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.proxyObject, that.proxyObject) && Objects.equals(this.moduleModel, that.moduleModel) && Objects.equals(this.serviceModel, that.serviceModel) && Objects.equals(this.config, that.config) && Objects.equals(this.serviceMetadata, that.serviceMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.serviceKey, this.proxyObject, this.moduleModel, this.serviceModel, this.config, this.serviceMetadata);
    }
}

