/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceModel;

public class DubboServiceAddressURL
extends ServiceAddressURL {
    private ServiceConfigURL overrideURL;

    public static DubboServiceAddressURL valueOf(String rawURL, URL consumerURL) {
        return DubboServiceAddressURL.valueOf(rawURL, consumerURL, null);
    }

    public static DubboServiceAddressURL valueOf(String rawURL, URL consumerURL, ServiceConfigURL overriddenURL) {
        URL url = DubboServiceAddressURL.valueOf(rawURL, true);
        return new DubboServiceAddressURL(url.getUrlAddress(), url.getUrlParam(), consumerURL, overriddenURL);
    }

    public DubboServiceAddressURL(URLAddress urlAddress, URLParam urlParam, URL consumerURL, ServiceConfigURL overrideURL) {
        super(urlAddress, urlParam, consumerURL);
        this.overrideURL = overrideURL;
    }

    @Override
    protected <T extends URL> T newURL(URLAddress urlAddress, URLParam urlParam) {
        return (T)new DubboServiceAddressURL(urlAddress, urlParam, this.consumerURL, this.overrideURL);
    }

    @Override
    public String getSide() {
        return this.consumerURL.getParameter("side");
    }

    @Override
    public String getParameter(String key) {
        String value = null;
        if (this.overrideURL != null) {
            value = this.overrideURL.getParameter(key);
        }
        if (StringUtils.isEmpty(value)) {
            value = super.getParameter(key);
        }
        return value;
    }

    @Override
    public String getMethodParameter(String method, String key) {
        String value = null;
        if (this.overrideURL != null) {
            value = this.overrideURL.getMethodParameterStrict(method, key);
        }
        if (StringUtils.isEmpty(value)) {
            value = super.getMethodParameter(method, key);
        }
        return value;
    }

    @Override
    public String getAnyMethodParameter(String key) {
        String value = null;
        if (this.overrideURL != null) {
            value = this.overrideURL.getAnyMethodParameter(key);
        }
        if (StringUtils.isEmpty(value)) {
            value = super.getAnyMethodParameter(key);
        }
        return value;
    }

    public ServiceConfigURL getOverrideURL() {
        return this.overrideURL;
    }

    public void setOverrideURL(ServiceConfigURL overrideURL) {
        this.overrideURL = overrideURL;
    }

    @Override
    public ScopeModel getScopeModel() {
        return this.consumerURL.getScopeModel();
    }

    @Override
    public ServiceModel getServiceModel() {
        return this.consumerURL.getServiceModel();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 * super.hashCode() + (this.overrideURL == null ? 0 : this.overrideURL.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DubboServiceAddressURL)) {
            return false;
        }
        if (this.overrideURL == null) {
            return super.equals(obj);
        }
        DubboServiceAddressURL other = (DubboServiceAddressURL)obj;
        boolean overrideEquals = Objects.equals(this.overrideURL.getParameters(), other.getOverrideURL().getParameters());
        if (!overrideEquals) {
            return false;
        }
        Map<String, String> params = this.getParameters();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            if (this.overrideURL.getParameters().containsKey(key) || entry.getValue().equals(other.getUrlParam().getParameter(key))) continue;
            return false;
        }
        return true;
    }
}

