/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.context.AbstractConfigManager;
import org.apache.dubbo.rpc.model.ModuleModel;

public class ModuleConfigManager
extends AbstractConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleConfigManager.class);
    private Map<String, AbstractInterfaceConfig> serviceConfigCache = new ConcurrentHashMap<String, AbstractInterfaceConfig>();

    public ModuleConfigManager(ModuleModel moduleModel) {
        super(moduleModel, Arrays.asList(ModuleConfig.class, ServiceConfigBase.class, ReferenceConfigBase.class, ProviderConfig.class, ConsumerConfig.class));
    }

    @DisableInject
    public void setModule(ModuleConfig module) {
        this.addConfig(module);
    }

    public Optional<ModuleConfig> getModule() {
        return Optional.ofNullable(this.getSingleConfig(AbstractConfig.getTagName(ModuleConfig.class)));
    }

    public void addService(ServiceConfigBase<?> serviceConfig) {
        this.addConfig(serviceConfig);
    }

    public void addServices(Iterable<ServiceConfigBase<?>> serviceConfigs) {
        serviceConfigs.forEach(this::addService);
    }

    public Collection<ServiceConfigBase> getServices() {
        return this.getConfigs(AbstractConfig.getTagName(ServiceConfigBase.class));
    }

    public <T> ServiceConfigBase<T> getService(String id) {
        return this.getConfig(ServiceConfigBase.class, id).orElse(null);
    }

    public void addReference(ReferenceConfigBase<?> referenceConfig) {
        this.addConfig(referenceConfig);
    }

    public void addReferences(Iterable<ReferenceConfigBase<?>> referenceConfigs) {
        referenceConfigs.forEach(this::addReference);
    }

    public Collection<ReferenceConfigBase<?>> getReferences() {
        return this.getConfigs(AbstractConfig.getTagName(ReferenceConfigBase.class));
    }

    public <T> ReferenceConfigBase<T> getReference(String id) {
        return this.getConfig(ReferenceConfigBase.class, id).orElse(null);
    }

    public void addProvider(ProviderConfig providerConfig) {
        this.addConfig(providerConfig);
    }

    public void addProviders(Iterable<ProviderConfig> providerConfigs) {
        providerConfigs.forEach(this::addProvider);
    }

    public Optional<ProviderConfig> getProvider(String id) {
        return this.getConfig(ProviderConfig.class, id);
    }

    public Optional<ProviderConfig> getDefaultProvider() {
        List providerConfigs = ModuleConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ProviderConfig.class)));
        if (CollectionUtils.isNotEmpty(providerConfigs)) {
            return Optional.of(providerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ProviderConfig> getProviders() {
        return this.getConfigs(AbstractConfig.getTagName(ProviderConfig.class));
    }

    public void addConsumer(ConsumerConfig consumerConfig) {
        this.addConfig(consumerConfig);
    }

    public void addConsumers(Iterable<ConsumerConfig> consumerConfigs) {
        consumerConfigs.forEach(this::addConsumer);
    }

    public Optional<ConsumerConfig> getConsumer(String id) {
        return this.getConfig(ConsumerConfig.class, id);
    }

    public Optional<ConsumerConfig> getDefaultConsumer() {
        List consumerConfigs = ModuleConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConsumerConfig.class)));
        if (CollectionUtils.isNotEmpty(consumerConfigs)) {
            return Optional.of(consumerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ConsumerConfig> getConsumers() {
        return this.getConfigs(AbstractConfig.getTagName(ConsumerConfig.class));
    }

    @Override
    public void refreshAll() {
        this.getModule().ifPresent(AbstractConfig::refresh);
        this.getProviders().forEach(AbstractConfig::refresh);
        this.getConsumers().forEach(AbstractConfig::refresh);
        for (ReferenceConfigBase<?> reference : this.getReferences()) {
            reference.refresh();
        }
        for (ServiceConfigBase sc : this.getServices()) {
            sc.refresh();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.serviceConfigCache.clear();
    }

    @Override
    protected <C extends AbstractConfig> Optional<C> findDuplicatedConfig(Map<String, C> configsMap, C config) {
        if (config instanceof ReferenceConfigBase || config instanceof ServiceConfigBase) {
            AbstractInterfaceConfig existedConfig = this.findDuplicatedInterfaceConfig((AbstractInterfaceConfig)config);
            if (existedConfig != null) {
                return Optional.of(existedConfig);
            }
        } else {
            return super.findDuplicatedConfig(configsMap, config);
        }
        return Optional.empty();
    }

    private AbstractInterfaceConfig findDuplicatedInterfaceConfig(AbstractInterfaceConfig config) {
        if (config instanceof ReferenceConfigBase) {
            return null;
        }
        if (!(config instanceof ServiceConfigBase)) {
            throw new IllegalArgumentException("Illegal type of parameter 'config' : " + config.getClass().getName());
        }
        ServiceConfigBase serviceConfig = (ServiceConfigBase)config;
        String uniqueServiceName = serviceConfig.getUniqueServiceName();
        Map<String, AbstractInterfaceConfig> configCache = this.serviceConfigCache;
        AbstractInterfaceConfig prevConfig = configCache.putIfAbsent(uniqueServiceName, config);
        if (prevConfig != null) {
            if (prevConfig == config) {
                return prevConfig;
            }
            if (prevConfig.equals(config)) {
                if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                    logger.warn("Ignore duplicated and equal config: " + config);
                }
                return prevConfig;
            }
            String configType = config.getClass().getSimpleName();
            String msg = "Found multiple " + configType + "s with unique service name [" + uniqueServiceName + "], previous: " + prevConfig + ", later: " + config + ". There can only be one instance of " + configType + " with the same triple (group, interface, version). If multiple instances are required for the same interface, please use a different group or version.";
            if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                logger.warn(msg);
            }
            if (!this.ignoreDuplicatedInterface) {
                throw new IllegalStateException(msg);
            }
        }
        return prevConfig;
    }

    @Override
    public void loadConfigs() {
        this.loadConfigsOfTypeFromProps(ProviderConfig.class);
        this.loadConfigsOfTypeFromProps(ConsumerConfig.class);
        this.loadConfigsOfTypeFromProps(ModuleConfig.class);
        this.checkDefaultAndValidateConfigs(ProviderConfig.class);
        this.checkDefaultAndValidateConfigs(ConsumerConfig.class);
        this.checkDefaultAndValidateConfigs(ModuleConfig.class);
    }
}

