/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URLStrParser;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.convert.Converter;
import org.apache.dubbo.common.url.component.PathURLAddress;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.url.component.URLPlainParam;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.LRUCache;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceModel;

public class URL
implements Serializable {
    private static final long serialVersionUID = -1985165475234910535L;
    private static Map<String, URL> cachedURLs = new LRUCache<String, URL>();
    private final URLAddress urlAddress;
    private final URLParam urlParam;
    private volatile transient Map<String, Number> numbers;
    private volatile transient Map<String, Map<String, Number>> methodNumbers;
    private volatile transient Map<String, URL> urls;
    private transient String serviceKey;
    private transient String protocolServiceKey;
    protected volatile Map<String, Object> attributes;
    private volatile int hashCodeCache = -1;

    protected URL() {
        this.urlAddress = null;
        this.urlParam = null;
        this.attributes = null;
    }

    public URL(URLAddress urlAddress, URLParam urlParam) {
        this(urlAddress, urlParam, null);
    }

    public URL(URLAddress urlAddress, URLParam urlParam, Map<String, Object> attributes) {
        this.urlAddress = urlAddress;
        this.urlParam = urlParam;
        this.attributes = attributes != null ? (attributes.isEmpty() ? null : attributes) : null;
    }

    public URL(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, (Map<String, String>)null);
    }

    public URL(String protocol, String host, int port, String[] pairs) {
        this(protocol, null, null, host, port, null, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public URL(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, (Map<String, String>)null);
    }

    public URL(String protocol, String host, int port, String path, String ... pairs) {
        this(protocol, null, null, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public URL(String protocol, String username, String password, String host, int port, String path) {
        this(protocol, username, password, host, port, path, (Map<String, String>)null);
    }

    public URL(String protocol, String username, String password, String host, int port, String path, String ... pairs) {
        this(protocol, username, password, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        if (StringUtils.isEmpty(username) && StringUtils.isNotEmpty(password)) {
            throw new IllegalArgumentException("Invalid url, password without username!");
        }
        this.urlAddress = new PathURLAddress(protocol, username, password, path, host, port);
        this.urlParam = URLParam.parse(parameters);
        this.attributes = null;
    }

    protected URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, boolean modifiable) {
        if (StringUtils.isEmpty(username) && StringUtils.isNotEmpty(password)) {
            throw new IllegalArgumentException("Invalid url, password without username!");
        }
        this.urlAddress = new PathURLAddress(protocol, username, password, path, host, port);
        this.urlParam = URLParam.parse(parameters);
        this.attributes = null;
    }

    public static URL cacheableValueOf(String url) {
        URL cachedURL = cachedURLs.get(url);
        if (cachedURL != null) {
            return cachedURL;
        }
        cachedURL = URL.valueOf(url, false);
        cachedURLs.put(url, cachedURL);
        return cachedURL;
    }

    public static URL valueOf(String url) {
        return URL.valueOf(url, false);
    }

    public static URL valueOf(String url, ScopeModel scopeModel) {
        return URL.valueOf(url).setScopeModel(scopeModel);
    }

    public static URL valueOf(String url, boolean encoded) {
        if (encoded) {
            return URLStrParser.parseEncodedStr(url);
        }
        return URLStrParser.parseDecodedStr(url);
    }

    public static URL valueOf(String url, String ... reserveParams) {
        URL result = URL.valueOf(url);
        if (reserveParams == null || reserveParams.length == 0) {
            return result;
        }
        HashMap<String, String> newMap = new HashMap<String, String>(reserveParams.length);
        Map<String, String> oldMap = result.getParameters();
        for (String reserveParam : reserveParams) {
            String tmp = oldMap.get(reserveParam);
            if (!StringUtils.isNotEmpty(tmp)) continue;
            newMap.put(reserveParam, tmp);
        }
        return result.clearParameters().addParameters(newMap);
    }

    public static URL valueOf(URL url, String[] reserveParams, String[] reserveParamPrefixes) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        Map<String, String> oldMap = url.getParameters();
        if (reserveParamPrefixes != null && reserveParamPrefixes.length != 0) {
            for (Map.Entry entry : oldMap.entrySet()) {
                for (String reserveParamPrefix : reserveParamPrefixes) {
                    if (!((String)entry.getKey()).startsWith(reserveParamPrefix) || !StringUtils.isNotEmpty((String)entry.getValue())) continue;
                    newMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        if (reserveParams != null) {
            for (String reserveParam : reserveParams) {
                String tmp = oldMap.get(reserveParam);
                if (!StringUtils.isNotEmpty(tmp)) continue;
                newMap.put(reserveParam, tmp);
            }
        }
        return newMap.isEmpty() ? new ServiceConfigURL(url.getProtocol(), url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), url.getPath(), (Map<String, String>)null, url.getAttributes()) : new ServiceConfigURL(url.getProtocol(), url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), url.getPath(), newMap, url.getAttributes());
    }

    public static String encode(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decode(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static String appendDefaultPort(String address, int defaultPort) {
        if (address != null && address.length() > 0 && defaultPort > 0) {
            int i = address.indexOf(58);
            if (i < 0) {
                return address + ":" + defaultPort;
            }
            if (Integer.parseInt(address.substring(i + 1)) == 0) {
                return address.substring(0, i + 1) + defaultPort;
            }
        }
        return address;
    }

    public URLAddress getUrlAddress() {
        return this.urlAddress;
    }

    public URLParam getUrlParam() {
        return this.urlParam;
    }

    public String getProtocol() {
        return this.urlAddress == null ? null : this.urlAddress.getProtocol();
    }

    public URL setProtocol(String protocol) {
        URLAddress newURLAddress = this.urlAddress.setProtocol(protocol);
        return this.returnURL(newURLAddress);
    }

    public String getUsername() {
        return this.urlAddress == null ? null : this.urlAddress.getUsername();
    }

    public URL setUsername(String username) {
        URLAddress newURLAddress = this.urlAddress.setUsername(username);
        return this.returnURL(newURLAddress);
    }

    public String getPassword() {
        return this.urlAddress == null ? null : this.urlAddress.getPassword();
    }

    public URL setPassword(String password) {
        URLAddress newURLAddress = this.urlAddress.setPassword(password);
        return this.returnURL(newURLAddress);
    }

    public String getAuthority() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getUserInformation());
        if (StringUtils.isNotEmpty(this.getHost())) {
            if (StringUtils.isNotEmpty(this.getUsername()) || StringUtils.isNotEmpty(this.getPassword())) {
                ret.append("@");
            }
            ret.append(this.getHost());
            if (this.getPort() != 0) {
                ret.append(":");
                ret.append(this.getPort());
            }
        }
        return ret.length() == 0 ? null : ret.toString();
    }

    public String getUserInformation() {
        StringBuilder ret = new StringBuilder();
        if (StringUtils.isEmpty(this.getUsername()) && StringUtils.isEmpty(this.getPassword())) {
            return ret.toString();
        }
        if (StringUtils.isNotEmpty(this.getUsername())) {
            ret.append(this.getUsername());
        }
        ret.append(":");
        if (StringUtils.isNotEmpty(this.getPassword())) {
            ret.append(this.getPassword());
        }
        return ret.length() == 0 ? null : ret.toString();
    }

    public String getHost() {
        return this.urlAddress == null ? null : this.urlAddress.getHost();
    }

    public URL setHost(String host) {
        URLAddress newURLAddress = this.urlAddress.setHost(host);
        return this.returnURL(newURLAddress);
    }

    public int getPort() {
        return this.urlAddress == null ? 0 : this.urlAddress.getPort();
    }

    public URL setPort(int port) {
        URLAddress newURLAddress = this.urlAddress.setPort(port);
        return this.returnURL(newURLAddress);
    }

    public int getPort(int defaultPort) {
        int port = this.getPort();
        return port <= 0 ? defaultPort : port;
    }

    public String getAddress() {
        return this.urlAddress.getAddress();
    }

    public URL setAddress(String address) {
        String host;
        int i = address.lastIndexOf(58);
        int port = this.getPort();
        if (i >= 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
        }
        URLAddress newURLAddress = this.urlAddress.setAddress(host, port);
        return this.returnURL(newURLAddress);
    }

    public String getIp() {
        return this.urlAddress.getIp();
    }

    public String getBackupAddress() {
        return this.getBackupAddress(0);
    }

    public String getBackupAddress(int defaultPort) {
        StringBuilder address = new StringBuilder(URL.appendDefaultPort(this.getAddress(), defaultPort));
        Object[] backups = this.getParameter("backup", new String[0]);
        if (ArrayUtils.isNotEmpty(backups)) {
            for (Object backup : backups) {
                address.append(',');
                address.append(URL.appendDefaultPort((String)backup, defaultPort));
            }
        }
        return address.toString();
    }

    public List<URL> getBackupUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this);
        String[] backups = this.getParameter("backup", new String[0]);
        if (backups != null && backups.length > 0) {
            for (String backup : backups) {
                urls.add(this.setAddress(backup));
            }
        }
        return urls;
    }

    public String getPath() {
        return this.urlAddress == null ? null : this.urlAddress.getPath();
    }

    public URL setPath(String path) {
        URLAddress newURLAddress = this.urlAddress.setPath(path);
        return this.returnURL(newURLAddress);
    }

    public String getAbsolutePath() {
        String path = this.getPath();
        if (path != null && !path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    public Map<String, String> getParameters() {
        return this.urlParam.getParameters();
    }

    public Map<String, String> getAllParameters() {
        return this.getParameters();
    }

    public Map<String, String> getParameters(Predicate<String> nameToSelect) {
        LinkedHashMap<String, String> selectedParameters = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getParameters().entrySet()) {
            String name = entry.getKey();
            if (!nameToSelect.test(name)) continue;
            selectedParameters.put(name, entry.getValue());
        }
        return Collections.unmodifiableMap(selectedParameters);
    }

    public String getParameterAndDecoded(String key) {
        return this.getParameterAndDecoded(key, null);
    }

    public String getParameterAndDecoded(String key, String defaultValue) {
        return URL.decode(this.getParameter(key, defaultValue));
    }

    public String getParameter(String key) {
        return this.urlParam.getParameter(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public String[] getParameter(String key, String[] defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : CommonConstants.COMMA_SPLIT_PATTERN.split(value);
    }

    public List<String> getParameter(String key, List<String> defaultValue) {
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        String[] strArray = CommonConstants.COMMA_SPLIT_PATTERN.split(value);
        return Arrays.asList(strArray);
    }

    public <T> T getParameter(String key, Class<T> valueType) {
        return this.getParameter(key, valueType, null);
    }

    public <T> T getParameter(String key, Class<T> valueType, T defaultValue) {
        String value = this.getParameter(key);
        T result = null;
        if (!StringUtils.isBlank(value)) {
            result = Converter.convertIfPossible(value, valueType);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public URL setScopeModel(ScopeModel scopeModel) {
        return this.putAttribute("scopeModel", scopeModel);
    }

    public ScopeModel getScopeModel() {
        return (ScopeModel)this.getAttribute("scopeModel");
    }

    public FrameworkModel getOrDefaultFrameworkModel() {
        return ScopeModelUtil.getFrameworkModel(this.getScopeModel());
    }

    public ApplicationModel getOrDefaultApplicationModel() {
        return ScopeModelUtil.getApplicationModel(this.getScopeModel());
    }

    public ApplicationModel getApplicationModel() {
        return ScopeModelUtil.getOrNullApplicationModel(this.getScopeModel());
    }

    public ModuleModel getOrDefaultModuleModel() {
        return ScopeModelUtil.getModuleModel(this.getScopeModel());
    }

    public URL setServiceModel(ServiceModel serviceModel) {
        return this.putAttribute("serviceModel", serviceModel);
    }

    public ServiceModel getServiceModel() {
        return (ServiceModel)this.getAttribute("serviceModel");
    }

    protected Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }

    protected Map<String, Map<String, Number>> getMethodNumbers() {
        if (this.methodNumbers == null) {
            this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
        }
        return this.methodNumbers;
    }

    private Map<String, URL> getUrls() {
        if (this.urls == null) {
            this.urls = new ConcurrentHashMap<String, URL>();
        }
        return this.urls;
    }

    public URL getUrlParameter(String key) {
        URL u = this.getUrls().get(key);
        if (u != null) {
            return u;
        }
        String value = this.getParameterAndDecoded(key);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        u = URL.valueOf(value);
        this.getUrls().put(key, u);
        return u;
    }

    public double getParameter(String key, double defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    public float getParameter(String key, float defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    public long getParameter(String key, long defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    public int getParameter(String key, int defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(key, i);
        return i;
    }

    public short getParameter(String key, short defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    public byte getParameter(String key, byte defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    public float getPositiveParameter(String key, float defaultValue) {
        if (defaultValue <= 0.0f) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        float value = this.getParameter(key, defaultValue);
        return value <= 0.0f ? defaultValue : value;
    }

    public double getPositiveParameter(String key, double defaultValue) {
        if (defaultValue <= 0.0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        double value = this.getParameter(key, defaultValue);
        return value <= 0.0 ? defaultValue : value;
    }

    public long getPositiveParameter(String key, long defaultValue) {
        if (defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        long value = this.getParameter(key, defaultValue);
        return value <= 0L ? defaultValue : value;
    }

    public int getPositiveParameter(String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getParameter(key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public short getPositiveParameter(String key, short defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        short value = this.getParameter(key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public byte getPositiveParameter(String key, byte defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        byte value = this.getParameter(key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public char getParameter(String key, char defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : value.charAt(0);
    }

    public boolean getParameter(String key, boolean defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return value != null && value.length() > 0;
    }

    public String getMethodParameterAndDecoded(String method, String key) {
        return URL.decode(this.getMethodParameter(method, key));
    }

    public String getMethodParameterAndDecoded(String method, String key, String defaultValue) {
        return URL.decode(this.getMethodParameter(method, key, defaultValue));
    }

    public String getMethodParameter(String method, String key) {
        return this.urlParam.getMethodParameter(method, key);
    }

    public String getMethodParameterStrict(String method, String key) {
        return this.urlParam.getMethodParameterStrict(method, key);
    }

    public String getMethodParameter(String method, String key, String defaultValue) {
        String value = this.getMethodParameter(method, key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public double getMethodParameter(String method, String key, double defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.updateCachedNumber(method, key, d);
        return d;
    }

    public float getMethodParameter(String method, String key, float defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.updateCachedNumber(method, key, Float.valueOf(f));
        return f;
    }

    public long getMethodParameter(String method, String key, long defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.updateCachedNumber(method, key, l);
        return l;
    }

    public int getMethodParameter(String method, String key, int defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.updateCachedNumber(method, key, i);
        return i;
    }

    public short getMethodParameter(String method, String key, short defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.updateCachedNumber(method, key, s);
        return s;
    }

    public byte getMethodParameter(String method, String key, byte defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.updateCachedNumber(method, key, b);
        return b;
    }

    private Number getCachedNumber(String method, String key) {
        Map<String, Number> keyNumber = this.getMethodNumbers().get(method);
        if (keyNumber != null) {
            return keyNumber.get(key);
        }
        return null;
    }

    private void updateCachedNumber(String method, String key, Number n) {
        Map keyNumber = this.getMethodNumbers().computeIfAbsent(method, m -> new HashMap());
        keyNumber.put(key, n);
    }

    public double getMethodPositiveParameter(String method, String key, double defaultValue) {
        if (defaultValue <= 0.0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        double value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0.0 ? defaultValue : value;
    }

    public float getMethodPositiveParameter(String method, String key, float defaultValue) {
        if (defaultValue <= 0.0f) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        float value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0.0f ? defaultValue : value;
    }

    public long getMethodPositiveParameter(String method, String key, long defaultValue) {
        if (defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        long value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0L ? defaultValue : value;
    }

    public int getMethodPositiveParameter(String method, String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public short getMethodPositiveParameter(String method, String key, short defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        short value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public byte getMethodPositiveParameter(String method, String key, byte defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        byte value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public char getMethodParameter(String method, String key, char defaultValue) {
        String value = this.getMethodParameter(method, key);
        return StringUtils.isEmpty(value) ? defaultValue : value.charAt(0);
    }

    public boolean getMethodParameter(String method, String key, boolean defaultValue) {
        String value = this.getMethodParameter(method, key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public boolean hasMethodParameter(String method, String key) {
        if (method == null) {
            String suffix = "." + key;
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (key == null) {
            String prefix = method + ".";
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        String value = this.getMethodParameterStrict(method, key);
        return StringUtils.isNotEmpty(value);
    }

    public String getAnyMethodParameter(String key) {
        return this.urlParam.getAnyMethodParameter(key);
    }

    public boolean hasMethodParameter(String method) {
        return this.urlParam.hasMethodParameter(method);
    }

    public boolean isLocalHost() {
        return NetUtils.isLocalHost(this.getHost()) || this.getParameter("localhost", false);
    }

    public boolean isAnyHost() {
        return "0.0.0.0".equals(this.getHost()) || this.getParameter("anyhost", false);
    }

    public URL addParameterAndEncoded(String key, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.addParameter(key, URL.encode(value));
    }

    public URL addParameter(String key, boolean value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, char value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, byte value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, short value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, int value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, long value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, float value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, double value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, Enum<?> value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, Number value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, String value) {
        URLParam newParam = this.urlParam.addParameter(key, value);
        return this.returnURL(newParam);
    }

    public URL addParameterIfAbsent(String key, String value) {
        URLParam newParam = this.urlParam.addParameterIfAbsent(key, value);
        return this.returnURL(newParam);
    }

    public URL addParameters(Map<String, String> parameters) {
        URLParam newParam = this.urlParam.addParameters(parameters);
        return this.returnURL(newParam);
    }

    public URL addParametersIfAbsent(Map<String, String> parameters) {
        URLParam newURLParam = this.urlParam.addParametersIfAbsent(parameters);
        return this.returnURL(newURLParam);
    }

    public URL addParameters(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Map pairs can not be odd number.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int len = pairs.length / 2;
        for (int i = 0; i < len; ++i) {
            map.put(pairs[2 * i], pairs[2 * i + 1]);
        }
        return this.addParameters(map);
    }

    public URL addParameterString(String query) {
        if (StringUtils.isEmpty(query)) {
            return this;
        }
        return this.addParameters(StringUtils.parseQueryString(query));
    }

    public URL removeParameter(String key) {
        if (StringUtils.isEmpty(key)) {
            return this;
        }
        return this.removeParameters(key);
    }

    public URL removeParameters(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return this;
        }
        return this.removeParameters(keys.toArray(new String[0]));
    }

    public URL removeParameters(String ... keys) {
        URLParam newURLParam = this.urlParam.removeParameters(keys);
        return this.returnURL(newURLParam);
    }

    public URL clearParameters() {
        URLParam newURLParam = this.urlParam.clearParameters();
        return this.returnURL(newURLParam);
    }

    public String getRawParameter(String key) {
        if ("protocol".equals(key)) {
            return this.urlAddress.getProtocol();
        }
        if ("username".equals(key)) {
            return this.urlAddress.getUsername();
        }
        if ("password".equals(key)) {
            return this.urlAddress.getPassword();
        }
        if ("host".equals(key)) {
            return this.urlAddress.getHost();
        }
        if ("port".equals(key)) {
            return String.valueOf(this.urlAddress.getPort());
        }
        if ("path".equals(key)) {
            return this.urlAddress.getPath();
        }
        return this.urlParam.getParameter(key);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        if (this.getProtocol() != null) {
            map.put("protocol", this.getProtocol());
        }
        if (this.getUsername() != null) {
            map.put("username", this.getUsername());
        }
        if (this.getPassword() != null) {
            map.put("password", this.getPassword());
        }
        if (this.getHost() != null) {
            map.put("host", this.getHost());
        }
        if (this.getPort() > 0) {
            map.put("port", String.valueOf(this.getPort()));
        }
        if (this.getPath() != null) {
            map.put("path", this.getPath());
        }
        return map;
    }

    public String toString() {
        return this.buildString(false, true, new String[0]);
    }

    public String toString(String ... parameters) {
        return this.buildString(false, true, parameters);
    }

    public String toIdentityString() {
        return this.buildString(true, false, new String[0]);
    }

    public String toIdentityString(String ... parameters) {
        return this.buildString(true, false, parameters);
    }

    public String toFullString() {
        return this.buildString(true, true, new String[0]);
    }

    public String toFullString(String ... parameters) {
        return this.buildString(true, true, parameters);
    }

    public String toParameterString() {
        return this.toParameterString(new String[0]);
    }

    public String toParameterString(String ... parameters) {
        StringBuilder buf = new StringBuilder();
        this.buildParameters(buf, false, parameters);
        return buf.toString();
    }

    protected void buildParameters(StringBuilder buf, boolean concat, String[] parameters) {
        if (CollectionUtils.isNotEmptyMap(this.getParameters())) {
            List<String> includes = ArrayUtils.isEmpty(parameters) ? null : Arrays.asList(parameters);
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.getParameters()).entrySet()) {
                if (!StringUtils.isNotEmpty(entry.getKey()) || includes != null && !includes.contains(entry.getKey())) continue;
                if (first) {
                    if (concat) {
                        buf.append('?');
                    }
                    first = false;
                } else {
                    buf.append('&');
                }
                buf.append(entry.getKey());
                buf.append('=');
                buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
    }

    private String buildString(boolean appendUser, boolean appendParameter, String ... parameters) {
        return this.buildString(appendUser, appendParameter, false, false, parameters);
    }

    private String buildString(boolean appendUser, boolean appendParameter, boolean useIP, boolean useService, String ... parameters) {
        String path;
        String host;
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty(this.getProtocol())) {
            buf.append(this.getProtocol());
            buf.append("://");
        }
        if (appendUser && StringUtils.isNotEmpty(this.getUsername())) {
            buf.append(this.getUsername());
            if (StringUtils.isNotEmpty(this.getPassword())) {
                buf.append(':');
                buf.append(this.getPassword());
            }
            buf.append('@');
        }
        if (StringUtils.isNotEmpty(host = useIP ? this.urlAddress.getIp() : this.getHost())) {
            buf.append(host);
            if (this.getPort() > 0) {
                buf.append(':');
                buf.append(this.getPort());
            }
        }
        if (StringUtils.isNotEmpty(path = useService ? this.getServiceKey() : this.getPath())) {
            buf.append('/');
            buf.append(path);
        }
        if (appendParameter) {
            this.buildParameters(buf, true, parameters);
        }
        return buf.toString();
    }

    public java.net.URL toJavaURL() {
        try {
            return new java.net.URL(this.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public String getColonSeparatedKey() {
        StringBuilder serviceNameBuilder = new StringBuilder();
        serviceNameBuilder.append(this.getServiceInterface());
        this.append(serviceNameBuilder, "version", false);
        this.append(serviceNameBuilder, "group", false);
        return serviceNameBuilder.toString();
    }

    private void append(StringBuilder target, String parameterName, boolean first) {
        String parameterValue = this.getParameter(parameterName);
        if (!StringUtils.isBlank(parameterValue)) {
            if (!first) {
                target.append(':');
            }
            target.append(parameterValue);
        } else {
            target.append(':');
        }
    }

    public String getServiceKey() {
        if (this.serviceKey != null) {
            return this.serviceKey;
        }
        String inf = this.getServiceInterface();
        if (inf == null) {
            return null;
        }
        this.serviceKey = URL.buildKey(inf, this.getGroup(), this.getVersion());
        return this.serviceKey;
    }

    public String getDisplayServiceKey() {
        if (StringUtils.isEmpty(this.getVersion())) {
            return this.getServiceInterface();
        }
        return this.getServiceInterface() + ':' + this.getVersion();
    }

    public String getPathKey() {
        String inf;
        String string = inf = StringUtils.isNotEmpty(this.getPath()) ? this.getPath() : this.getServiceInterface();
        if (inf == null) {
            return null;
        }
        return URL.buildKey(inf, this.getGroup(), this.getVersion());
    }

    public static String buildKey(String path, String group, String version) {
        return BaseServiceMetadata.buildServiceKey(path, group, version);
    }

    public String getProtocolServiceKey() {
        if (this.protocolServiceKey != null) {
            return this.protocolServiceKey;
        }
        this.protocolServiceKey = this.getServiceKey();
        if (!"consumer".equals(this.getProtocol())) {
            this.protocolServiceKey = this.protocolServiceKey + ":" + this.getProtocol();
        }
        return this.protocolServiceKey;
    }

    public String toServiceStringWithoutResolving() {
        return this.buildString(true, false, false, true, new String[0]);
    }

    public String toServiceString() {
        return this.buildString(true, false, true, true, new String[0]);
    }

    @Deprecated
    public String getServiceName() {
        return this.getServiceInterface();
    }

    public String getServiceInterface() {
        return this.getParameter("interface", this.getPath());
    }

    public URL setServiceInterface(String service) {
        return this.addParameter("interface", service);
    }

    @Deprecated
    public int getIntParameter(String key) {
        return this.getParameter(key, 0);
    }

    @Deprecated
    public int getIntParameter(String key, int defaultValue) {
        return this.getParameter(key, defaultValue);
    }

    @Deprecated
    public int getPositiveIntParameter(String key, int defaultValue) {
        return this.getPositiveParameter(key, defaultValue);
    }

    @Deprecated
    public boolean getBooleanParameter(String key) {
        return this.getParameter(key, false);
    }

    @Deprecated
    public boolean getBooleanParameter(String key, boolean defaultValue) {
        return this.getParameter(key, defaultValue);
    }

    @Deprecated
    public int getMethodIntParameter(String method, String key) {
        return this.getMethodParameter(method, key, 0);
    }

    @Deprecated
    public int getMethodIntParameter(String method, String key, int defaultValue) {
        return this.getMethodParameter(method, key, defaultValue);
    }

    @Deprecated
    public int getMethodPositiveIntParameter(String method, String key, int defaultValue) {
        return this.getMethodPositiveParameter(method, key, defaultValue);
    }

    @Deprecated
    public boolean getMethodBooleanParameter(String method, String key) {
        return this.getMethodParameter(method, key, false);
    }

    @Deprecated
    public boolean getMethodBooleanParameter(String method, String key, boolean defaultValue) {
        return this.getMethodParameter(method, key, defaultValue);
    }

    public Configuration toConfiguration() {
        InmemoryConfiguration configuration = new InmemoryConfiguration();
        configuration.addProperties(this.getParameters());
        return configuration;
    }

    public int hashCode() {
        if (this.hashCodeCache == -1) {
            this.hashCodeCache = Objects.hash(this.urlAddress, this.urlParam);
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URL)) {
            return false;
        }
        URL other = (URL)obj;
        return Objects.equals(this.getUrlAddress(), other.getUrlAddress()) && Objects.equals(this.getUrlParam(), other.getUrlParam());
    }

    public static void putMethodParameter(String method, String key, String value, Map<String, Map<String, String>> methodParameters) {
        Map subParameter = methodParameters.computeIfAbsent(method, k -> new HashMap());
        subParameter.put(key, value);
    }

    protected <T extends URL> T newURL(URLAddress urlAddress, URLParam urlParam) {
        return (T)new ServiceConfigURL(urlAddress, urlParam, this.attributes);
    }

    public String getApplication(String defaultValue) {
        String value = this.getApplication();
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public String getApplication() {
        return this.getParameter("application");
    }

    public String getRemoteApplication() {
        return this.getParameter("remote.application");
    }

    public String getGroup() {
        return this.getParameter("group");
    }

    public String getGroup(String defaultValue) {
        String value = this.getGroup();
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public String getVersion() {
        return this.getParameter("version");
    }

    public String getVersion(String defaultValue) {
        String value = this.getVersion();
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public String getConcatenatedParameter(String key) {
        return this.getParameter(key);
    }

    public String getCategory(String defaultValue) {
        String value = this.getCategory();
        if (StringUtils.isEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getCategory(String[] defaultValue) {
        String value = this.getCategory();
        return StringUtils.isEmpty(value) ? defaultValue : CommonConstants.COMMA_SPLIT_PATTERN.split(value);
    }

    public String getCategory() {
        return this.getParameter("category");
    }

    public String getSide(String defaultValue) {
        String value = this.getSide();
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public String getSide() {
        return this.getParameter("side");
    }

    public Map<String, Object> getAttributes() {
        return this.attributes == null ? Collections.emptyMap() : this.attributes;
    }

    public URL addAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            attributes.putAll(attributes);
        }
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        Object val = this.attributes == null ? null : this.attributes.get(key);
        return val != null ? val : defaultValue;
    }

    public URL putAttribute(String key, Object obj) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, obj);
        return this;
    }

    public URL removeAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
        return this;
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    private URL returnURL(URLAddress newURLAddress) {
        if (this.urlAddress == newURLAddress) {
            return this;
        }
        return this.newURL(newURLAddress, this.urlParam);
    }

    private URL returnURL(URLParam newURLParam) {
        if (this.urlParam == newURLParam) {
            return this;
        }
        return this.newURL(this.urlAddress, newURLParam);
    }

    public Map<String, String> getServiceParameters(String service) {
        return this.getParameters();
    }

    public String getServiceParameter(String service, String key) {
        return this.getParameter(key);
    }

    public String getServiceParameter(String service, String key, String defaultValue) {
        String value = this.getServiceParameter(service, key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public int getServiceParameter(String service, String key, int defaultValue) {
        return this.getParameter(key, defaultValue);
    }

    public double getServiceParameter(String service, String key, double defaultValue) {
        Number n = this.getServiceNumbers(service).get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    public float getServiceParameter(String service, String key, float defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    public long getServiceParameter(String service, String key, long defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    public short getServiceParameter(String service, String key, short defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    public byte getServiceParameter(String service, String key, byte defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    public char getServiceParameter(String service, String key, char defaultValue) {
        String value = this.getServiceParameter(service, key);
        return StringUtils.isEmpty(value) ? defaultValue : value.charAt(0);
    }

    public boolean getServiceParameter(String service, String key, boolean defaultValue) {
        String value = this.getServiceParameter(service, key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public boolean hasServiceParameter(String service, String key) {
        String value = this.getServiceParameter(service, key);
        return value != null && value.length() > 0;
    }

    public float getPositiveServiceParameter(String service, String key, float defaultValue) {
        if (defaultValue <= 0.0f) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        float value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0.0f ? defaultValue : value;
    }

    public double getPositiveServiceParameter(String service, String key, double defaultValue) {
        if (defaultValue <= 0.0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        double value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0.0 ? defaultValue : value;
    }

    public long getPositiveServiceParameter(String service, String key, long defaultValue) {
        if (defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        long value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0L ? defaultValue : value;
    }

    public int getPositiveServiceParameter(String service, String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public short getPositiveServiceParameter(String service, String key, short defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        short value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public byte getPositiveServiceParameter(String service, String key, byte defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        byte value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public String getServiceMethodParameterAndDecoded(String service, String method, String key) {
        return URL.decode(this.getServiceMethodParameter(service, method, key));
    }

    public String getServiceMethodParameterAndDecoded(String service, String method, String key, String defaultValue) {
        return URL.decode(this.getServiceMethodParameter(service, method, key, defaultValue));
    }

    public String getServiceMethodParameterStrict(String service, String method, String key) {
        return this.getMethodParameterStrict(method, key);
    }

    public String getServiceMethodParameter(String service, String method, String key) {
        return this.getMethodParameter(method, key);
    }

    public String getServiceMethodParameter(String service, String method, String key, String defaultValue) {
        String value = this.getServiceMethodParameter(service, method, key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public double getServiceMethodParameter(String service, String method, String key, double defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.updateCachedNumber(method, key, d);
        return d;
    }

    public float getServiceMethodParameter(String service, String method, String key, float defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.updateCachedNumber(method, key, Float.valueOf(f));
        return f;
    }

    public long getServiceMethodParameter(String service, String method, String key, long defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.updateCachedNumber(method, key, l);
        return l;
    }

    public int getServiceMethodParameter(String service, String method, String key, int defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.updateCachedNumber(method, key, i);
        return i;
    }

    public short getMethodParameter(String service, String method, String key, short defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.updateCachedNumber(method, key, s);
        return s;
    }

    public byte getServiceMethodParameter(String service, String method, String key, byte defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.updateCachedNumber(method, key, b);
        return b;
    }

    public boolean hasServiceMethodParameter(String service, String method, String key) {
        return this.hasMethodParameter(method, key);
    }

    public boolean hasServiceMethodParameter(String service, String method) {
        return this.hasMethodParameter(method);
    }

    protected Map<String, Number> getServiceNumbers(String service) {
        return this.getNumbers();
    }

    protected Map<String, Map<String, Number>> getServiceMethodNumbers(String service) {
        return this.getMethodNumbers();
    }

    public URL toSerializableURL() {
        return this.returnURL(URLPlainParam.toURLPlainParam(this.urlParam));
    }
}

