/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter.wrapper;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class CompositeDynamicConfiguration
implements DynamicConfiguration {
    public static final String NAME = "COMPOSITE";
    private static final Logger logger = LoggerFactory.getLogger(CompositeDynamicConfiguration.class);
    private Set<DynamicConfiguration> configurations = new HashSet<DynamicConfiguration>();

    public void addConfiguration(DynamicConfiguration configuration) {
        if (configuration != null) {
            this.configurations.add(configuration);
        }
    }

    public Set<DynamicConfiguration> getInnerConfigurations() {
        return this.configurations;
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        this.iterateListenerOperation(configuration -> configuration.addListener(key, group, listener));
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        this.iterateListenerOperation(configuration -> configuration.removeListener(key, group, listener));
    }

    @Override
    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.iterateConfigOperation(configuration -> configuration.getConfig(key, group, timeout));
    }

    @Override
    public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.iterateConfigOperation(configuration -> configuration.getProperties(key, group, timeout));
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.iterateConfigOperation(configuration -> configuration.getInternalProperty(key));
    }

    @Override
    public boolean publishConfig(String key, String group, String content) throws UnsupportedOperationException {
        boolean publishedAll = true;
        for (DynamicConfiguration configuration : this.configurations) {
            if (configuration.publishConfig(key, group, content)) continue;
            publishedAll = false;
        }
        return publishedAll;
    }

    @Override
    public SortedSet<String> getConfigKeys(String group) throws UnsupportedOperationException {
        return (SortedSet)this.iterateConfigOperation(configuration -> configuration.getConfigKeys(group));
    }

    @Override
    public void close() throws Exception {
        for (DynamicConfiguration configuration : this.configurations) {
            try {
                configuration.close();
            }
            catch (Exception e) {
                logger.warn("close dynamic configuration " + configuration.getClass().getName() + "failed: " + e.getMessage(), e);
            }
        }
        this.configurations.clear();
    }

    private void iterateListenerOperation(Consumer<DynamicConfiguration> consumer) {
        for (DynamicConfiguration configuration : this.configurations) {
            consumer.accept(configuration);
        }
    }

    private Object iterateConfigOperation(Function<DynamicConfiguration, Object> func) {
        DynamicConfiguration configuration;
        Object value = null;
        Iterator<DynamicConfiguration> iterator = this.configurations.iterator();
        while (iterator.hasNext() && (value = func.apply(configuration = iterator.next())) == null) {
        }
        return value;
    }
}

