/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataReportConfig
extends AbstractConfig {
    private static final long serialVersionUID = 55233L;
    private String protocol;
    private String address;
    private Integer port;
    private String username;
    private String password;
    private Integer timeout;
    private String group;
    private Map<String, String> parameters;
    private Integer retryTimes;
    private Integer retryPeriod;
    private Boolean cycleReport;
    private Boolean syncReport;
    private Boolean cluster;
    private String registry;
    private String file;
    private Boolean check;
    private Boolean reportMetadata;
    private Boolean reportDefinition;

    public MetadataReportConfig() {
    }

    public MetadataReportConfig(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public MetadataReportConfig(String address) {
        this.setAddress(address);
    }

    public MetadataReportConfig(ApplicationModel applicationModel, String address) {
        super(applicationModel);
        this.setAddress(address);
    }

    public URL toUrl() throws IllegalArgumentException {
        String address = this.getAddress();
        if (StringUtils.isEmpty(address)) {
            throw new IllegalArgumentException("The address of metadata report is invalid.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        URL url = URL.valueOf(address, this.getScopeModel());
        map.putAll(url.getParameters());
        MetadataReportConfig.appendParameters(map, this);
        map.putAll(MetadataReportConfig.convert(map, null));
        map.put("metadata", StringUtils.isEmpty(url.getProtocol()) ? (String)map.get("protocol") : url.getProtocol());
        return new ServiceConfigURL("metadata", url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), url.getPath(), map).setScopeModel(this.getScopeModel());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Parameter(excluded=true)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (address != null) {
            try {
                URL url = URL.valueOf(address);
                PojoUtils.updatePropertyIfAbsent(this::getUsername, this::setUsername, url.getUsername());
                PojoUtils.updatePropertyIfAbsent(this::getPassword, this::setPassword, url.getPassword());
                PojoUtils.updatePropertyIfAbsent(this::getProtocol, this::setProtocol, url.getProtocol());
                PojoUtils.updatePropertyIfAbsent(this::getPort, this::setPort, url.getPort());
                Map<String, String> params = url.getParameters();
                if (CollectionUtils.isNotEmptyMap(params)) {
                    params.remove("backup");
                }
                this.updateParameters(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Parameter(key="retry-times")
    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    @Parameter(key="retry-period")
    public Integer getRetryPeriod() {
        return this.retryPeriod;
    }

    public void setRetryPeriod(Integer retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @Parameter(key="cycle-report")
    public Boolean getCycleReport() {
        return this.cycleReport;
    }

    public void setCycleReport(Boolean cycleReport) {
        this.cycleReport = cycleReport;
    }

    @Parameter(key="sync-report")
    public Boolean getSyncReport() {
        return this.syncReport;
    }

    public void setSyncReport(Boolean syncReport) {
        this.syncReport = syncReport;
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public boolean isValid() {
        return StringUtils.isNotEmpty(this.address);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getCluster() {
        return this.cluster;
    }

    public void setCluster(Boolean cluster) {
        this.cluster = cluster;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void updateParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = parameters;
        } else {
            this.parameters.putAll(parameters);
        }
    }

    public Boolean isCheck() {
        return this.check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    @Parameter(key="report-metadata")
    public Boolean getReportMetadata() {
        return this.reportMetadata;
    }

    public void setReportMetadata(Boolean reportMetadata) {
        this.reportMetadata = reportMetadata;
    }

    @Parameter(key="report-definition")
    public Boolean getReportDefinition() {
        return this.reportDefinition;
    }

    public void setReportDefinition(Boolean reportDefinition) {
        this.reportDefinition = reportDefinition;
    }
}

