/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.resource;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.apache.dubbo.common.concurrent.CallableSafeInitializer;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.resource.GlobalResourcesRepository;

public class GlobalResourceInitializer<T>
extends CallableSafeInitializer<T> {
    private Consumer<T> disposeAction;
    private Disposable disposable;

    public GlobalResourceInitializer(Callable<T> initializer) {
        super(initializer);
    }

    public GlobalResourceInitializer(Callable initializer, Consumer<T> disposeAction) {
        super(initializer);
        this.disposeAction = disposeAction;
    }

    public GlobalResourceInitializer(Callable<T> callable, Disposable disposable) {
        super(callable);
        this.disposable = disposable;
    }

    @Override
    protected T initialize() {
        Object value = super.initialize();
        if (this.disposable != null) {
            GlobalResourcesRepository.getInstance().registerDisposable(this.disposable);
        } else {
            GlobalResourcesRepository.getInstance().registerDisposable(() -> this.remove(this.disposeAction));
        }
        return value;
    }

    public static interface DestroyHandler<T> {
        public void dispose(GlobalResourceInitializer<T> var1);
    }
}

