/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.dubbo.common.metrics.collector.MetricsCollector;
import org.apache.dubbo.common.metrics.collector.stat.MetricsStatComposite;
import org.apache.dubbo.common.metrics.collector.stat.MetricsStatHandler;
import org.apache.dubbo.common.metrics.event.RequestEvent;
import org.apache.dubbo.common.metrics.listener.MetricsListener;
import org.apache.dubbo.common.metrics.model.MetricsCategory;
import org.apache.dubbo.common.metrics.model.MetricsKey;
import org.apache.dubbo.common.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.common.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultMetricsCollector
implements MetricsCollector {
    private AtomicBoolean collectEnabled = new AtomicBoolean(false);
    private final List<MetricsListener> listeners = new ArrayList<MetricsListener>();
    private final ApplicationModel applicationModel;
    private final MetricsStatComposite stats;

    public DefaultMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.stats = new MetricsStatComposite(applicationModel.getApplicationName(), this);
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        this.collectEnabled.compareAndSet(this.isCollectEnabled(), collectEnabled);
    }

    public Boolean isCollectEnabled() {
        return this.collectEnabled.get();
    }

    public void addListener(MetricsListener listener) {
        this.listeners.add(listener);
    }

    public List<MetricsListener> getListener() {
        return this.listeners;
    }

    public void increaseTotalRequests(String interfaceName, String methodName, String group, String version) {
        this.doExecute(RequestEvent.Type.TOTAL, (MetricsStatHandler statHandler) -> statHandler.increase(interfaceName, methodName, group, version));
    }

    public void increaseSucceedRequests(String interfaceName, String methodName, String group, String version) {
        this.doExecute(RequestEvent.Type.SUCCEED, (MetricsStatHandler statHandler) -> statHandler.increase(interfaceName, methodName, group, version));
    }

    public void increaseFailedRequests(String interfaceName, String methodName, String group, String version) {
        this.doExecute(RequestEvent.Type.FAILED, (MetricsStatHandler statHandler) -> statHandler.increase(interfaceName, methodName, group, version));
    }

    public void businessFailedRequests(String interfaceName, String methodName, String group, String version) {
        this.doExecute(RequestEvent.Type.BUSINESS_FAILED, (MetricsStatHandler statHandler) -> statHandler.increase(interfaceName, methodName, group, version));
    }

    public void increaseProcessingRequests(String interfaceName, String methodName, String group, String version) {
        this.doExecute(RequestEvent.Type.PROCESSING, (MetricsStatHandler statHandler) -> statHandler.increase(interfaceName, methodName, group, version));
    }

    public void decreaseProcessingRequests(String interfaceName, String methodName, String group, String version) {
        this.doExecute(RequestEvent.Type.PROCESSING, (MetricsStatHandler statHandler) -> statHandler.decrease(interfaceName, methodName, group, version));
    }

    public void addRT(String interfaceName, String methodName, String group, String version, Long responseTime) {
        this.stats.addRT(interfaceName, methodName, group, version, responseTime);
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        this.collectRequests(list);
        this.collectRT(list);
        return list;
    }

    private void collectRequests(List<MetricSample> list) {
        this.doExecute(RequestEvent.Type.TOTAL, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_REQUESTS_TOTAL, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doExecute(RequestEvent.Type.SUCCEED, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_REQUESTS_SUCCEED, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doExecute(RequestEvent.Type.FAILED, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_REQUESTS_FAILED, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doExecute(RequestEvent.Type.PROCESSING, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_REQUESTS_PROCESSING, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doExecute(RequestEvent.Type.BUSINESS_FAILED, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_REQUEST_BUSINESS_FAILED, k.getTags(), MetricsCategory.REQUESTS, v::get))));
    }

    private void collectRT(List<MetricSample> list) {
        this.stats.getLastRT().forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_RT_LAST, k.getTags(), MetricsCategory.RT, v::get)));
        this.stats.getMinRT().forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_RT_MIN, k.getTags(), MetricsCategory.RT, v::get)));
        this.stats.getMaxRT().forEach((k, v) -> list.add(new GaugeMetricSample(MetricsKey.METRIC_RT_MAX, k.getTags(), MetricsCategory.RT, v::get)));
        this.stats.getTotalRT().forEach((k, v) -> {
            list.add(new GaugeMetricSample(MetricsKey.METRIC_RT_TOTAL, k.getTags(), MetricsCategory.RT, v::get));
            AtomicLong avg = this.stats.getAvgRT().get(k);
            AtomicLong count = this.stats.getRtCount().get(k);
            avg.set(v.get() / count.get());
            list.add(new GaugeMetricSample(MetricsKey.METRIC_RT_AVG, k.getTags(), MetricsCategory.RT, avg::get));
        });
    }

    private <T> Optional<T> doExecute(RequestEvent.Type requestType, Function<MetricsStatHandler, T> statExecutor) {
        if (this.isCollectEnabled().booleanValue()) {
            MetricsStatHandler handler = this.stats.getHandler(requestType);
            T result = statExecutor.apply(handler);
            return Optional.ofNullable(result);
        }
        return Optional.empty();
    }

    private void doExecute(RequestEvent.Type requestType, Consumer<MetricsStatHandler> statExecutor) {
        if (this.isCollectEnabled().booleanValue()) {
            MetricsStatHandler handler = this.stats.getHandler(requestType);
            statExecutor.accept(handler);
        }
    }
}

