/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;

public abstract class AbstractDynamicConfiguration
implements DynamicConfiguration {
    public static final String PARAM_NAME_PREFIX = "dubbo.config-center.";
    public static final String THREAD_POOL_PREFIX_PARAM_NAME = "dubbo.config-center.thread-pool.prefix";
    public static final String DEFAULT_THREAD_POOL_PREFIX = "dubbo.config-center.workers";
    public static final String THREAD_POOL_SIZE_PARAM_NAME = "dubbo.config-center.thread-pool.size";
    public static final String THREAD_POOL_KEEP_ALIVE_TIME_PARAM_NAME = "dubbo.config-center.thread-pool.keep-alive-time";
    public static final String GROUP_PARAM_NAME = "dubbo.config-center.group";
    public static final String TIMEOUT_PARAM_NAME = "dubbo.config-center.timeout";
    public static final int DEFAULT_THREAD_POOL_SIZE = 1;
    public static final long DEFAULT_THREAD_POOL_KEEP_ALIVE_TIME = TimeUnit.MINUTES.toMillis(1L);
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final ThreadPoolExecutor workersThreadPool;
    private final String group;
    private final long timeout;

    protected AbstractDynamicConfiguration(URL url) {
        this(AbstractDynamicConfiguration.getThreadPoolPrefixName(url), AbstractDynamicConfiguration.getThreadPoolSize(url), AbstractDynamicConfiguration.getThreadPoolKeepAliveTime(url), AbstractDynamicConfiguration.getGroup(url), AbstractDynamicConfiguration.getTimeout(url));
    }

    protected AbstractDynamicConfiguration(String threadPoolPrefixName, int threadPoolSize, long keepAliveTime, String group, long timeout) {
        this.workersThreadPool = this.initWorkersThreadPool(threadPoolPrefixName, threadPoolSize, keepAliveTime);
        this.group = group;
        this.timeout = timeout;
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
    }

    @Override
    public final String getConfig(String key, String group, long timeout) throws IllegalStateException {
        return this.execute(() -> this.doGetConfig(key, group), timeout);
    }

    @Override
    public Object getInternalProperty(String key) {
        return null;
    }

    @Override
    public final void close() throws Exception {
        try {
            this.doClose();
        }
        finally {
            this.doFinally();
        }
    }

    @Override
    public boolean removeConfig(String key, String group) {
        return Boolean.TRUE.equals(this.execute(() -> this.doRemoveConfig(key, group), -1L));
    }

    @Override
    public String getDefaultGroup() {
        return this.getGroup();
    }

    @Override
    public long getDefaultTimeout() {
        return this.getTimeout();
    }

    protected abstract String doGetConfig(String var1, String var2) throws Exception;

    protected abstract void doClose() throws Exception;

    protected abstract boolean doRemoveConfig(String var1, String var2) throws Exception;

    protected final void execute(Runnable task, long timeout) {
        this.execute(() -> {
            task.run();
            return null;
        }, timeout);
    }

    protected final <V> V execute(Callable<V> task, long timeout) {
        V value;
        block4: {
            value = null;
            try {
                if (timeout < 1L) {
                    value = task.call();
                } else {
                    Future<V> future = this.workersThreadPool.submit(task);
                    value = future.get(timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error(e.getMessage(), e);
            }
        }
        return value;
    }

    protected ThreadPoolExecutor getWorkersThreadPool() {
        return this.workersThreadPool;
    }

    private void doFinally() {
        this.shutdownWorkersThreadPool();
    }

    private void shutdownWorkersThreadPool() {
        if (!this.workersThreadPool.isShutdown()) {
            this.workersThreadPool.shutdown();
        }
    }

    protected ThreadPoolExecutor initWorkersThreadPool(String threadPoolPrefixName, int threadPoolSize, long keepAliveTime) {
        return new ThreadPoolExecutor(threadPoolSize, threadPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolPrefixName, true));
    }

    protected static String getThreadPoolPrefixName(URL url) {
        return AbstractDynamicConfiguration.getParameter(url, THREAD_POOL_PREFIX_PARAM_NAME, DEFAULT_THREAD_POOL_PREFIX);
    }

    protected static int getThreadPoolSize(URL url) {
        return AbstractDynamicConfiguration.getParameter(url, THREAD_POOL_SIZE_PARAM_NAME, 1);
    }

    protected static long getThreadPoolKeepAliveTime(URL url) {
        return AbstractDynamicConfiguration.getParameter(url, THREAD_POOL_KEEP_ALIVE_TIME_PARAM_NAME, DEFAULT_THREAD_POOL_KEEP_ALIVE_TIME);
    }

    protected static String getParameter(URL url, String name, String defaultValue) {
        if (url != null) {
            return url.getParameter(name, defaultValue);
        }
        return defaultValue;
    }

    protected static int getParameter(URL url, String name, int defaultValue) {
        if (url != null) {
            return url.getParameter(name, defaultValue);
        }
        return defaultValue;
    }

    protected static long getParameter(URL url, String name, long defaultValue) {
        if (url != null) {
            return url.getParameter(name, defaultValue);
        }
        return defaultValue;
    }

    protected String getGroup() {
        return this.group;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected static String getGroup(URL url) {
        String group = AbstractDynamicConfiguration.getParameter(url, GROUP_PARAM_NAME, null);
        return StringUtils.isBlank(group) ? AbstractDynamicConfiguration.getParameter(url, "group", "dubbo") : group;
    }

    protected static long getTimeout(URL url) {
        return AbstractDynamicConfiguration.getParameter(url, TIMEOUT_PARAM_NAME, -1L);
    }
}

