/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.compiler.support.AdaptiveCompiler;
import org.apache.dubbo.common.infra.InfraAdapter;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ApplicationConfig
extends AbstractConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationConfig.class);
    private static final long serialVersionUID = 5508512956753757169L;
    private String name;
    private String version;
    private String owner;
    private String organization;
    private String architecture;
    private String environment;
    private String compiler;
    private String logger;
    private List<RegistryConfig> registries;
    private String registryIds;
    private MonitorConfig monitor;
    private String dumpDirectory;
    private Boolean qosEnable;
    private String qosHost;
    private Integer qosPort;
    private Boolean qosAcceptForeignIp;
    private Map<String, String> parameters;
    private String shutwait;
    private String hostname;
    private String metadataType;
    private Boolean registerConsumer;
    private String repository;
    private Boolean enableFileCache;
    private String protocol;
    private String metadataServiceProtocol;
    private Integer metadataServicePort;
    private String livenessProbe;
    private String readinessProbe;
    private String startupProbe;
    private String registerMode;
    private Boolean enableEmptyProtection;
    private String executorManagementMode;

    public ApplicationConfig() {
    }

    public ApplicationConfig(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public ApplicationConfig(String name) {
        this.setName(name);
    }

    public ApplicationConfig(ApplicationModel applicationModel, String name) {
        super(applicationModel);
        this.setName(name);
    }

    @Override
    protected void checkDefault() {
        super.checkDefault();
        if (this.protocol == null) {
            this.protocol = "dubbo";
        }
        if (this.hostname == null) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Failed to get the hostname of current instance.", e);
                this.hostname = "UNKNOWN";
            }
        }
        if (this.executorManagementMode == null) {
            this.executorManagementMode = "default";
        }
    }

    @Parameter(key="application", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Parameter(key="application.version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        if (!(environment == null || "develop".equals(environment) || "test".equals(environment) || "product".equals(environment))) {
            throw new IllegalStateException(String.format("Unsupported environment: %s, only support %s/%s/%s, default is %s.", environment, "develop", "test", "product", "product"));
        }
        this.environment = environment;
    }

    public RegistryConfig getRegistry() {
        return CollectionUtils.isEmpty(this.registries) ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.registries = registries;
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        this.registries = registries;
    }

    @Parameter(excluded=true)
    public String getRegistryIds() {
        return this.registryIds;
    }

    public void setRegistryIds(String registryIds) {
        this.registryIds = registryIds;
    }

    public MonitorConfig getMonitor() {
        return this.monitor;
    }

    public void setMonitor(String monitor) {
        this.monitor = new MonitorConfig(monitor);
    }

    public void setMonitor(MonitorConfig monitor) {
        this.monitor = monitor;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
        AdaptiveCompiler.setDefaultCompiler(compiler);
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
        LoggerFactory.setLoggerAdapter(this.getApplicationModel().getFrameworkModel(), logger);
    }

    @Parameter(key="dump.directory")
    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public void setDumpDirectory(String dumpDirectory) {
        this.dumpDirectory = dumpDirectory;
    }

    @Parameter(key="qos.enable")
    public Boolean getQosEnable() {
        return this.qosEnable;
    }

    public void setQosEnable(Boolean qosEnable) {
        this.qosEnable = qosEnable;
    }

    @Parameter(key="qos.host")
    public String getQosHost() {
        return this.qosHost;
    }

    public void setQosHost(String qosHost) {
        this.qosHost = qosHost;
    }

    @Parameter(key="qos.port")
    public Integer getQosPort() {
        return this.qosPort;
    }

    public void setQosPort(Integer qosPort) {
        this.qosPort = qosPort;
    }

    @Parameter(key="qos.accept.foreign.ip")
    public Boolean getQosAcceptForeignIp() {
        return this.qosAcceptForeignIp;
    }

    public void setQosAcceptForeignIp(Boolean qosAcceptForeignIp) {
        this.qosAcceptForeignIp = qosAcceptForeignIp;
    }

    @Parameter(key="qos-enable", excluded=true, attribute=false)
    public Boolean getQosEnableCompatible() {
        return this.getQosEnable();
    }

    public void setQosEnableCompatible(Boolean qosEnable) {
        this.setQosEnable(qosEnable);
    }

    @Parameter(key="qos-host", excluded=true, attribute=false)
    public String getQosHostCompatible() {
        return this.getQosHost();
    }

    public void setQosHostCompatible(String qosHost) {
        this.setQosHost(qosHost);
    }

    @Parameter(key="qos-port", excluded=true, attribute=false)
    public Integer getQosPortCompatible() {
        return this.getQosPort();
    }

    public void setQosPortCompatible(Integer qosPort) {
        this.setQosPort(qosPort);
    }

    @Parameter(key="qos-accept-foreign-ip", excluded=true, attribute=false)
    public Boolean getQosAcceptForeignIpCompatible() {
        return this.getQosAcceptForeignIp();
    }

    public void setQosAcceptForeignIpCompatible(Boolean qosAcceptForeignIp) {
        this.setQosAcceptForeignIp(qosAcceptForeignIp);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getShutwait() {
        return this.shutwait;
    }

    public void setShutwait(String shutwait) {
        System.setProperty("dubbo.service.shutdown.wait", shutwait);
        this.shutwait = shutwait;
    }

    @Parameter(excluded=true)
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public boolean isValid() {
        return !StringUtils.isEmpty(this.name);
    }

    @Parameter(key="metadata-type")
    public String getMetadataType() {
        return this.metadataType;
    }

    public void setMetadataType(String metadataType) {
        this.metadataType = metadataType;
    }

    public Boolean getRegisterConsumer() {
        return this.registerConsumer;
    }

    public void setRegisterConsumer(Boolean registerConsumer) {
        this.registerConsumer = registerConsumer;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    @Parameter(key="file.cache")
    public Boolean getEnableFileCache() {
        return this.enableFileCache;
    }

    public void setEnableFileCache(Boolean enableFileCache) {
        this.enableFileCache = enableFileCache;
    }

    @Parameter(key="register-mode")
    public String getRegisterMode() {
        return this.registerMode;
    }

    public void setRegisterMode(String registerMode) {
        this.registerMode = registerMode;
    }

    @Parameter(key="enable-empty-protection")
    public Boolean getEnableEmptyProtection() {
        return this.enableEmptyProtection;
    }

    public void setEnableEmptyProtection(Boolean enableEmptyProtection) {
        this.enableEmptyProtection = enableEmptyProtection;
    }

    @Parameter(excluded=true, key="application-protocol")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Parameter(key="metadata-service-port")
    public Integer getMetadataServicePort() {
        return this.metadataServicePort;
    }

    public void setMetadataServicePort(Integer metadataServicePort) {
        this.metadataServicePort = metadataServicePort;
    }

    @Parameter(key="metadata-service-protocol")
    public String getMetadataServiceProtocol() {
        return this.metadataServiceProtocol;
    }

    public void setMetadataServiceProtocol(String metadataServiceProtocol) {
        this.metadataServiceProtocol = metadataServiceProtocol;
    }

    @Parameter(key="liveness-probe")
    public String getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(String livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Parameter(key="readiness-probe")
    public String getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(String readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @Parameter(key="startup-probe")
    public String getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(String startupProbe) {
        this.startupProbe = startupProbe;
    }

    public void setExecutorManagementMode(String executorManagementMode) {
        this.executorManagementMode = executorManagementMode;
    }

    @Parameter(key="executor-management-mode")
    public String getExecutorManagementMode() {
        return this.executorManagementMode;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.appendEnvironmentProperties();
    }

    private void appendEnvironmentProperties() {
        Set<InfraAdapter> adapters;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        if (CollectionUtils.isNotEmpty(adapters = this.getExtensionLoader(InfraAdapter.class).getSupportedExtensionInstances())) {
            HashMap<String, String> inputParameters = new HashMap<String, String>();
            inputParameters.put("application", this.getName());
            inputParameters.put("host", this.getHostname());
            for (InfraAdapter adapter : adapters) {
                Map<String, String> extraParameters = adapter.getExtraAttributes(inputParameters);
                if (!CollectionUtils.isNotEmptyMap(extraParameters)) continue;
                extraParameters.forEach((key, value) -> {
                    block1: {
                        Iterator<String> iterator = this.getPrefixes().iterator();
                        if (!iterator.hasNext()) break block1;
                        String prefix = iterator.next();
                        if (key.startsWith(prefix = prefix + ".")) {
                            key = key.substring(prefix.length());
                        }
                        this.parameters.put((String)key, (String)value);
                    }
                });
            }
        }
    }
}

