/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component.param;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.url.component.param.ParamValue;

public class DynamicValues
implements ParamValue {
    private volatile String[] index2Value = new String[1];
    private final Map<String, Integer> value2Index = new ConcurrentHashMap<String, Integer>();
    private int indexSeq = 0;

    public DynamicValues(String defaultVal) {
        if (defaultVal == null) {
            ++this.indexSeq;
        } else {
            this.add(defaultVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(String value) {
        Integer index = this.value2Index.get(value);
        if (index != null) {
            return index;
        }
        DynamicValues dynamicValues = this;
        synchronized (dynamicValues) {
            if (!this.value2Index.containsKey(value)) {
                if (this.indexSeq == Integer.MAX_VALUE) {
                    throw new IllegalStateException("URL Param Cache is full.");
                }
                String[] newValues = new String[this.indexSeq + 1];
                System.arraycopy(this.index2Value, 0, newValues, 0, this.indexSeq);
                newValues[this.indexSeq] = value;
                this.index2Value = newValues;
                this.value2Index.put(value, this.indexSeq);
                ++this.indexSeq;
            }
        }
        return this.value2Index.get(value);
    }

    @Override
    public String getN(int n) {
        if (n == -1) {
            return null;
        }
        return this.index2Value[n];
    }

    @Override
    public int getIndex(String value) {
        if (value == null) {
            return -1;
        }
        Integer index = this.value2Index.get(value);
        if (index == null) {
            return this.add(value);
        }
        return index;
    }
}

