/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.beans.Transient;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public abstract class AbstractMethodConfig
extends AbstractConfig {
    private static final long serialVersionUID = 5809761483000878437L;
    protected Integer timeout;
    protected Integer retries;
    protected Integer actives;
    protected String loadbalance;
    protected Boolean async;
    protected Boolean sent;
    protected String mock;
    protected String merger;
    protected String cache;
    protected String validation;
    protected Map<String, String> parameters;
    protected Integer forks;

    public AbstractMethodConfig() {
    }

    public AbstractMethodConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    @Override
    @Transient
    public ModuleModel getScopeModel() {
        return (ModuleModel)super.getScopeModel();
    }

    @Override
    @Transient
    protected ScopeModel getDefaultModel() {
        return ApplicationModel.defaultModel().getDefaultModule();
    }

    @Override
    protected void checkScopeModel(ScopeModel scopeModel) {
        if (scopeModel == null) {
            throw new IllegalArgumentException("scopeModel cannot be null");
        }
        if (!(scopeModel instanceof ModuleModel)) {
            throw new IllegalArgumentException("Invalid scope model, expect to be a ModuleModel but got: " + scopeModel);
        }
    }

    @Transient
    protected ModuleConfigManager getModuleConfigManager() {
        return this.getScopeModel().getConfigManager();
    }

    public Integer getForks() {
        return this.forks;
    }

    public void setForks(Integer forks) {
        this.forks = forks;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public String getLoadbalance() {
        return this.loadbalance;
    }

    public void setLoadbalance(String loadbalance) {
        this.loadbalance = loadbalance;
    }

    public Boolean isAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public Integer getActives() {
        return this.actives;
    }

    public void setActives(Integer actives) {
        this.actives = actives;
    }

    public Boolean getSent() {
        return this.sent;
    }

    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    @Parameter(escaped=true)
    public String getMock() {
        return this.mock;
    }

    public void setMock(String mock) {
        this.mock = mock;
    }

    @Deprecated
    public void setMock(Object mock) {
        if (mock == null) {
            return;
        }
        this.setMock(String.valueOf(mock));
    }

    public String getMerger() {
        return this.merger;
    }

    public void setMerger(String merger) {
        this.merger = merger;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public Map<String, String> getParameters() {
        this.parameters = Optional.ofNullable(this.parameters).orElseGet(HashMap::new);
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

