/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.support.eager;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.threadpool.support.eager.TaskQueue;

public class EagerThreadPoolExecutor
extends ThreadPoolExecutor {
    public EagerThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TaskQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException rx) {
            TaskQueue queue = (TaskQueue)super.getQueue();
            try {
                if (!queue.retryOffer(command, 0L, TimeUnit.MILLISECONDS)) {
                    throw new RejectedExecutionException("Queue capacity is full.", rx);
                }
            }
            catch (InterruptedException x) {
                throw new RejectedExecutionException(x);
            }
        }
    }
}

