/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.utils.Log;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="Dubbo", category="Core", elementType="appender")
public class DubboAppender
extends AbstractAppender {
    private static final String DEFAULT_FILE_NAME = "dubbo.log";
    public static boolean available = false;
    public static List<Log> logList = new ArrayList<Log>();
    private final FileAppender fileAppender;

    public DubboAppender() {
        this("Dubbo", null);
    }

    private DubboAppender(String name, FileAppender fileAppender) {
        super(name, null, null, true, Property.EMPTY_ARRAY);
        this.fileAppender = fileAppender;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return (Builder)new Builder().asBuilder();
    }

    public static void doStart() {
        available = true;
    }

    public static void doStop() {
        available = false;
    }

    public static void clear() {
        logList.clear();
    }

    public void append(LogEvent event) {
        if (this.fileAppender != null) {
            this.fileAppender.append(event);
        }
        if (available) {
            logList.add(this.parseLog(event));
        }
    }

    public void initialize() {
        this.fileAppender.initialize();
        super.initialize();
    }

    public void start() {
        this.fileAppender.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.fileAppender.stop();
    }

    private Log parseLog(LogEvent event) {
        Log log = new Log();
        log.setLogName(event.getLoggerName());
        log.setLogLevel(Level.valueOf(event.getLevel().name()));
        log.setLogThread(event.getThreadName());
        log.setLogMessage(event.getMessage().getFormattedMessage());
        return log;
    }

    public static class Builder
    extends AbstractOutputStreamAppender.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<DubboAppender> {
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;

        public Builder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setAppend(boolean append) {
            this.append = append;
            return this;
        }

        public Builder setLocking(boolean locking) {
            this.locking = locking;
            return this;
        }

        public DubboAppender build() {
            return new DubboAppender(this.getName(), this.buildFileAppender());
        }

        private <B extends FileAppender.Builder<B>> FileAppender buildFileAppender() {
            FileAppender.Builder builder = FileAppender.newBuilder();
            builder.setIgnoreExceptions(this.isIgnoreExceptions());
            builder.setLayout(this.getLayout());
            builder.setName(this.getName() + "-File");
            builder.setConfiguration(this.getConfiguration());
            builder.setBufferedIo(this.isBufferedIo());
            builder.setBufferSize(this.getBufferSize());
            builder.setImmediateFlush(this.isImmediateFlush());
            builder.withFileName(this.fileName == null || this.fileName.isEmpty() ? DubboAppender.DEFAULT_FILE_NAME : this.fileName);
            builder.withAppend(this.append);
            builder.withLocking(this.locking);
            return builder.build();
        }
    }
}

