/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.constants.CommonConstants;

public class SystemPropertyConfigUtils {
    private static Set<String> systemProperties;

    public static String getSystemProperty(String key) {
        if (SystemPropertyConfigUtils.containsKey(key)) {
            return System.getProperty(key);
        }
        throw new IllegalStateException(String.format("System property [%s] does not define in org.apache.dubbo.common.constants.CommonConstants", key));
    }

    public static String getSystemProperty(String key, String defaultValue) {
        if (SystemPropertyConfigUtils.containsKey(key)) {
            return System.getProperty(key, defaultValue);
        }
        throw new IllegalStateException(String.format("System property [%s] does not define in org.apache.dubbo.common.constants.CommonConstants", key));
    }

    public static String setSystemProperty(String key, String value) {
        if (SystemPropertyConfigUtils.containsKey(key)) {
            return System.setProperty(key, value);
        }
        throw new IllegalStateException(String.format("System property [%s] does not define in org.apache.dubbo.common.constants.CommonConstants", key));
    }

    public static String clearSystemProperty(String key) {
        if (SystemPropertyConfigUtils.containsKey(key)) {
            return System.clearProperty(key);
        }
        throw new IllegalStateException(String.format("System property [%s] does not define in org.apache.dubbo.common.constants.CommonConstants", key));
    }

    private static boolean containsKey(String key) {
        return systemProperties.contains(key);
    }

    static {
        Class[] classes;
        systemProperties = new HashSet<String>();
        for (Class clazz : classes = new Class[]{CommonConstants.SystemProperty.class, CommonConstants.ThirdPartyProperty.class, CommonConstants.DubboProperty.class}) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                try {
                    assert (systemProperties != null);
                    Object value = field.get(null);
                    if (!(value instanceof String)) continue;
                    systemProperties.add((String)value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(String.format("%s does not have field of %s", clazz.getName(), field.getName()));
                }
            }
        }
    }
}

