/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.metric.reportor;

import java.util.Arrays;
import org.apache.eagle.metric.reportor.EagleMetric;
import org.apache.eagle.metric.reportor.EagleMetricListener;
import org.apache.eagle.metric.reportor.MetricKeyCodeDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagleCounterMetric
extends EagleMetric {
    private static final Logger LOG = LoggerFactory.getLogger(EagleCounterMetric.class);

    public EagleCounterMetric(long latestUserTimeClock, String name, double value, long granularity) {
        super(latestUserTimeClock, name, value, granularity);
    }

    public EagleCounterMetric(EagleCounterMetric metric) {
        super(metric);
    }

    public long trim(long latestUserTimeClock) {
        return latestUserTimeClock / this.granularity * this.granularity;
    }

    public void flush(long latestUserTimeClock) {
        for (EagleMetricListener listener : this.metricListeners) {
            EagleCounterMetric newEagleMetric = new EagleCounterMetric(this);
            newEagleMetric.name = MetricKeyCodeDecoder.addTimestampToMetricKey(this.trim(latestUserTimeClock), newEagleMetric.name);
            listener.onMetricFlushed(Arrays.asList(newEagleMetric));
        }
    }

    public boolean checkIfNeedFlush(long currentUserTimeClock) {
        return currentUserTimeClock - this.latestUserTimeClock > this.granularity;
    }

    @Override
    public boolean update(double d, long currentUserTimeClock) {
        Boolean readyToFlushed = this.checkIfNeedFlush(currentUserTimeClock);
        if (!readyToFlushed.booleanValue()) {
            if (currentUserTimeClock < this.latestUserTimeClock) {
                LOG.warn("Something must be wrong, event should come in order of userTimeClock");
            }
            this.value.addAndGet(d);
        } else {
            this.flush(this.latestUserTimeClock);
            this.value.getAndSet(1.0);
            this.latestUserTimeClock = currentUserTimeClock;
        }
        return readyToFlushed;
    }
}

