/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.metric.reportor;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.List;
import org.apache.eagle.metric.reportor.EagleCounterMetric;
import org.apache.eagle.metric.reportor.EagleMetricListener;
import org.apache.eagle.metric.reportor.IEagleMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EagleMetric
implements IEagleMetric {
    public long latestUserTimeClock;
    public AtomicDouble value;
    public String name;
    public long granularity;
    public List<EagleMetricListener> metricListeners = new ArrayList<EagleMetricListener>();
    private static final Logger LOG = LoggerFactory.getLogger(EagleCounterMetric.class);

    public EagleMetric(EagleMetric metric) {
        this.latestUserTimeClock = metric.latestUserTimeClock;
        this.name = metric.name;
        this.value = new AtomicDouble(metric.value.doubleValue());
        this.granularity = metric.granularity;
    }

    public EagleMetric(long latestUserTimeClock, String name, double value, long granularity) {
        this.latestUserTimeClock = latestUserTimeClock;
        this.name = name;
        this.value = new AtomicDouble(value);
        this.granularity = granularity;
    }

    public EagleMetric(long latestUserTimeClock, String metricName, double value) {
        this(latestUserTimeClock, metricName, value, 300000L);
    }

    @Override
    public void registerListener(EagleMetricListener listener) {
        this.metricListeners.add(listener);
    }

    public Double getValue() {
        return this.value.doubleValue();
    }
}

