/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.metric.reportor;

import com.codahale.metrics.Metric;
import java.util.ArrayList;
import java.util.List;
import org.apache.eagle.log.entity.GenericMetricEntity;
import org.apache.eagle.log.entity.GenericServiceAPIResponseEntity;
import org.apache.eagle.metric.reportor.EagleMetric;
import org.apache.eagle.metric.reportor.EagleMetricListener;
import org.apache.eagle.metric.reportor.MetricEntityAdaptor;
import org.apache.eagle.service.client.impl.EagleServiceClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagleServiceReporterMetricListener
implements EagleMetricListener {
    private EagleServiceClientImpl client;
    private static final Logger LOG = LoggerFactory.getLogger(EagleServiceReporterMetricListener.class);

    public EagleServiceReporterMetricListener(String host, int port, String username, String password) {
        this.client = new EagleServiceClientImpl(host, port, username, password);
    }

    public EagleServiceReporterMetricListener(String host, int port) {
        this.client = new EagleServiceClientImpl(host, port, null, null);
    }

    @Override
    public void onMetricFlushed(List<EagleMetric> metrics) {
        ArrayList<GenericMetricEntity> entities = new ArrayList<GenericMetricEntity>();
        for (EagleMetric metric : metrics) {
            String metricName = metric.name;
            entities.add(MetricEntityAdaptor.convert(metricName, (Metric)metric));
        }
        try {
            int total = entities.size();
            GenericServiceAPIResponseEntity response = this.client.create(entities, "GenericMetricService");
            if (response.isSuccess()) {
                LOG.info("Wrote " + total + " entities to service");
            } else {
                LOG.error("Failed to write " + total + " entities to service, due to server exception: " + response.getException());
            }
        }
        catch (Exception ex) {
            LOG.error("Got exception while writing entities: ", (Throwable)ex);
        }
    }
}

