/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.metric.reportor;

import com.codahale.metrics.Metric;
import org.apache.eagle.log.entity.GenericMetricEntity;
import org.apache.eagle.metric.reportor.EagleCounterMetric;
import org.apache.eagle.metric.reportor.EagleGaugeMetric;
import org.apache.eagle.metric.reportor.EagleMetricKey;
import org.apache.eagle.metric.reportor.MetricKeyCodeDecoder;

public class MetricEntityAdaptor {
    public static GenericMetricEntity convert(String name, Metric metric) {
        EagleMetricKey metricName = MetricKeyCodeDecoder.decodeTSMetricKey(name);
        if (metric instanceof EagleCounterMetric) {
            EagleCounterMetric counter = (EagleCounterMetric)metric;
            GenericMetricEntity entity = new GenericMetricEntity();
            entity.setPrefix(metricName.metricName);
            entity.setValue(new double[]{counter.getValue()});
            entity.setTags(metricName.tags);
            entity.setTimestamp(metricName.timestamp);
            return entity;
        }
        if (metric instanceof EagleGaugeMetric) {
            EagleGaugeMetric gauge = (EagleGaugeMetric)metric;
            GenericMetricEntity entity = new GenericMetricEntity();
            entity.setPrefix(metricName.metricName);
            entity.setValue(new double[]{gauge.getValue()});
            entity.setTags(metricName.tags);
            entity.setTimestamp(metricName.timestamp);
            return entity;
        }
        throw new RuntimeException("Not support this metric type for now!");
    }
}

