/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class NonDuplicatingTypeSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = -7633631762221447524L;
    private final TypeSerializer<T> typeSerializer;
    private transient IdentityHashMap<T, Integer> identityMap;
    private transient ArrayList<T> elementList;

    public NonDuplicatingTypeSerializer(TypeSerializer<T> typeSerializer) {
        this.typeSerializer = typeSerializer;
        this.identityMap = new IdentityHashMap();
        this.elementList = new ArrayList();
    }

    public TypeSerializer<T> getTypeSerializer() {
        return this.typeSerializer;
    }

    public void clearReferences() {
        this.identityMap.clear();
        this.elementList.clear();
    }

    public boolean isImmutableType() {
        return this.typeSerializer.isImmutableType();
    }

    public TypeSerializer<T> duplicate() {
        return new NonDuplicatingTypeSerializer<T>(this.typeSerializer);
    }

    public T createInstance() {
        return (T)this.typeSerializer.createInstance();
    }

    public T copy(T from) {
        return (T)this.typeSerializer.copy(from);
    }

    public T copy(T from, T reuse) {
        return (T)this.typeSerializer.copy(from, reuse);
    }

    public int getLength() {
        return this.typeSerializer.getLength();
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        if (this.identityMap.containsKey(record)) {
            target.writeBoolean(true);
            target.writeInt(this.identityMap.get(record).intValue());
        } else {
            target.writeBoolean(false);
            this.typeSerializer.serialize(record, target);
        }
    }

    public T deserialize(DataInputView source) throws IOException {
        boolean alreadyRead = source.readBoolean();
        if (alreadyRead) {
            int index = source.readInt();
            return this.elementList.get(index);
        }
        Object element = this.typeSerializer.deserialize(source);
        this.elementList.add(element);
        return (T)element;
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        boolean alreadyRead = source.readBoolean();
        if (alreadyRead) {
            int index = source.readInt();
            this.typeSerializer.serialize(this.elementList.get(index), target);
        } else {
            Object element = this.typeSerializer.deserialize(source);
            this.typeSerializer.serialize(element, target);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof NonDuplicatingTypeSerializer) {
            NonDuplicatingTypeSerializer other = (NonDuplicatingTypeSerializer)((Object)obj);
            return other.canEqual((Object)this) && this.typeSerializer.equals(other.typeSerializer);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof NonDuplicatingTypeSerializer;
    }

    public int hashCode() {
        return this.typeSerializer.hashCode();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.identityMap = new IdentityHashMap();
        this.elementList = new ArrayList();
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        throw new UnsupportedOperationException("This serializer is not registered for managed state.");
    }

    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        throw new UnsupportedOperationException("This serializer is not registered for managed state.");
    }
}

