/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.operator.CEPOperatorUtils;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.types.Either;
import org.apache.flink.util.Collector;

public class PatternStream<T> {
    private final DataStream<T> inputStream;
    private final Pattern<T, ?> pattern;

    PatternStream(DataStream<T> inputStream, Pattern<T, ?> pattern) {
        this.inputStream = inputStream;
        this.pattern = pattern;
    }

    public Pattern<T, ?> getPattern() {
        return this.pattern;
    }

    public DataStream<T> getInputStream() {
        return this.inputStream;
    }

    public <R> SingleOutputStreamOperator<R> select(PatternSelectFunction<T, R> patternSelectFunction) {
        TypeInformation returnType = TypeExtractor.getUnaryOperatorReturnType(patternSelectFunction, PatternSelectFunction.class, (int)0, (int)1, (int[])new int[]{0, 1, 0}, (int[])new int[0], (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        return this.select(patternSelectFunction, returnType);
    }

    public <R> SingleOutputStreamOperator<R> select(PatternSelectFunction<T, R> patternSelectFunction, TypeInformation<R> outTypeInfo) {
        SingleOutputStreamOperator<Map<String, List<T>>> patternStream = CEPOperatorUtils.createPatternStream(this.inputStream, this.pattern);
        return patternStream.map(new PatternSelectMapper((PatternSelectFunction)patternStream.getExecutionEnvironment().clean(patternSelectFunction))).returns(outTypeInfo);
    }

    public <L, R> SingleOutputStreamOperator<Either<L, R>> select(PatternTimeoutFunction<T, L> patternTimeoutFunction, PatternSelectFunction<T, R> patternSelectFunction) {
        SingleOutputStreamOperator<Either<Tuple2<Map<String, List<T>>, Long>, Map<String, List<T>>>> patternStream = CEPOperatorUtils.createTimeoutPatternStream(this.inputStream, this.pattern);
        TypeInformation leftTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternTimeoutFunction, PatternTimeoutFunction.class, (int)0, (int)1, (int[])new int[]{0, 1, 0}, (int[])new int[0], (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternSelectFunction, PatternSelectFunction.class, (int)0, (int)1, (int[])new int[]{0, 1, 0}, (int[])new int[0], (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        EitherTypeInfo outTypeInfo = new EitherTypeInfo(leftTypeInfo, rightTypeInfo);
        return patternStream.map(new PatternSelectTimeoutMapper((PatternSelectFunction)patternStream.getExecutionEnvironment().clean(patternSelectFunction), (PatternTimeoutFunction)patternStream.getExecutionEnvironment().clean(patternTimeoutFunction))).returns((TypeInformation)outTypeInfo);
    }

    public <R> SingleOutputStreamOperator<R> flatSelect(PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        TypeInformation outTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatSelectFunction, PatternFlatSelectFunction.class, (int)0, (int)1, (int[])new int[]{0, 1, 0}, (int[])new int[]{1, 0}, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        return this.flatSelect(patternFlatSelectFunction, outTypeInfo);
    }

    public <R> SingleOutputStreamOperator<R> flatSelect(PatternFlatSelectFunction<T, R> patternFlatSelectFunction, TypeInformation<R> outTypeInfo) {
        SingleOutputStreamOperator<Map<String, List<T>>> patternStream = CEPOperatorUtils.createPatternStream(this.inputStream, this.pattern);
        return patternStream.flatMap(new PatternFlatSelectMapper((PatternFlatSelectFunction)patternStream.getExecutionEnvironment().clean(patternFlatSelectFunction))).returns(outTypeInfo);
    }

    public <L, R> SingleOutputStreamOperator<Either<L, R>> flatSelect(PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction, PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        SingleOutputStreamOperator<Either<Tuple2<Map<String, List<T>>, Long>, Map<String, List<T>>>> patternStream = CEPOperatorUtils.createTimeoutPatternStream(this.inputStream, this.pattern);
        TypeInformation leftTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatTimeoutFunction, PatternFlatTimeoutFunction.class, (int)0, (int)1, (int[])new int[]{0, 1, 0}, (int[])new int[]{2, 0}, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatSelectFunction, PatternFlatSelectFunction.class, (int)0, (int)1, (int[])new int[]{0, 1, 0}, (int[])new int[]{1, 0}, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        EitherTypeInfo outTypeInfo = new EitherTypeInfo(leftTypeInfo, rightTypeInfo);
        return patternStream.flatMap(new PatternFlatSelectTimeoutWrapper((PatternFlatSelectFunction)patternStream.getExecutionEnvironment().clean(patternFlatSelectFunction), (PatternFlatTimeoutFunction)patternStream.getExecutionEnvironment().clean(patternFlatTimeoutFunction))).returns((TypeInformation)outTypeInfo);
    }

    private static class PatternFlatSelectMapper<T, R>
    implements FlatMapFunction<Map<String, List<T>>, R> {
        private static final long serialVersionUID = -8610796233077989108L;
        private final PatternFlatSelectFunction<T, R> patternFlatSelectFunction;

        public PatternFlatSelectMapper(PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
            this.patternFlatSelectFunction = patternFlatSelectFunction;
        }

        public void flatMap(Map<String, List<T>> value, Collector<R> out) throws Exception {
            this.patternFlatSelectFunction.flatSelect(value, out);
        }
    }

    private static class PatternFlatSelectTimeoutWrapper<T, L, R>
    implements FlatMapFunction<Either<Tuple2<Map<String, List<T>>, Long>, Map<String, List<T>>>, Either<L, R>> {
        private static final long serialVersionUID = 7483674669662261667L;
        private final PatternFlatSelectFunction<T, R> patternFlatSelectFunction;
        private final PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction;

        public PatternFlatSelectTimeoutWrapper(PatternFlatSelectFunction<T, R> patternFlatSelectFunction, PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction) {
            this.patternFlatSelectFunction = patternFlatSelectFunction;
            this.patternFlatTimeoutFunction = patternFlatTimeoutFunction;
        }

        public void flatMap(Either<Tuple2<Map<String, List<T>>, Long>, Map<String, List<T>>> value, Collector<Either<L, R>> out) throws Exception {
            if (value.isLeft()) {
                Tuple2 timeout = (Tuple2)value.left();
                this.patternFlatTimeoutFunction.timeout((Map)timeout.f0, (Long)timeout.f1, new LeftCollector(out));
            } else {
                this.patternFlatSelectFunction.flatSelect((Map)value.right(), new RightCollector(out));
            }
        }

        private static class RightCollector<L, R>
        implements Collector<R> {
            private final Collector<Either<L, R>> out;

            private RightCollector(Collector<Either<L, R>> out) {
                this.out = out;
            }

            public void collect(R record) {
                this.out.collect((Object)Either.Right(record));
            }

            public void close() {
                this.out.close();
            }
        }

        private static class LeftCollector<L, R>
        implements Collector<L> {
            private final Collector<Either<L, R>> out;

            private LeftCollector(Collector<Either<L, R>> out) {
                this.out = out;
            }

            public void collect(L record) {
                this.out.collect((Object)Either.Left(record));
            }

            public void close() {
                this.out.close();
            }
        }
    }

    private static class PatternSelectTimeoutMapper<T, L, R>
    implements MapFunction<Either<Tuple2<Map<String, List<T>>, Long>, Map<String, List<T>>>, Either<L, R>> {
        private static final long serialVersionUID = 8259477556738887724L;
        private final PatternSelectFunction<T, R> patternSelectFunction;
        private final PatternTimeoutFunction<T, L> patternTimeoutFunction;

        public PatternSelectTimeoutMapper(PatternSelectFunction<T, R> patternSelectFunction, PatternTimeoutFunction<T, L> patternTimeoutFunction) {
            this.patternSelectFunction = patternSelectFunction;
            this.patternTimeoutFunction = patternTimeoutFunction;
        }

        public Either<L, R> map(Either<Tuple2<Map<String, List<T>>, Long>, Map<String, List<T>>> value) throws Exception {
            if (value.isLeft()) {
                Tuple2 timeout = (Tuple2)value.left();
                return Either.Left(this.patternTimeoutFunction.timeout((Map)timeout.f0, (Long)timeout.f1));
            }
            return Either.Right(this.patternSelectFunction.select((Map)value.right()));
        }
    }

    private static class PatternSelectMapper<T, R>
    implements MapFunction<Map<String, List<T>>, R> {
        private static final long serialVersionUID = 2273300432692943064L;
        private final PatternSelectFunction<T, R> patternSelectFunction;

        public PatternSelectMapper(PatternSelectFunction<T, R> patternSelectFunction) {
            this.patternSelectFunction = patternSelectFunction;
        }

        public R map(Map<String, List<T>> value) throws Exception {
            return this.patternSelectFunction.select(value);
        }
    }
}

