/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.util.Preconditions;

public class ComputationState<T> {
    private final State<T> state;
    private final T event;
    private final int counter;
    private final long timestamp;
    private final DeweyNumber version;
    private final long startTimestamp;
    private final State<T> previousState;
    private final ConditionContext conditionContext;

    private ComputationState(NFA<T> nfa, State<T> currentState, State<T> previousState, T event, int counter, long timestamp, DeweyNumber version, long startTimestamp) {
        this.state = currentState;
        this.event = event;
        this.counter = counter;
        this.timestamp = timestamp;
        this.version = version;
        this.startTimestamp = startTimestamp;
        this.previousState = previousState;
        this.conditionContext = new ConditionContext(nfa, this);
    }

    public int getCounter() {
        return this.counter;
    }

    public ConditionContext getConditionContext() {
        return this.conditionContext;
    }

    public boolean isFinalState() {
        return this.state.isFinal();
    }

    public boolean isStartState() {
        return this.state.isStart() && this.event == null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public State<T> getState() {
        return this.state;
    }

    public State<T> getPreviousState() {
        return this.previousState;
    }

    public T getEvent() {
        return this.event;
    }

    public DeweyNumber getVersion() {
        return this.version;
    }

    public static <T> ComputationState<T> createStartState(NFA<T> nfa, State<T> state) {
        Preconditions.checkArgument((boolean)state.isStart());
        return new ComputationState<Object>(nfa, state, null, null, 0, -1L, new DeweyNumber(1), -1L);
    }

    public static <T> ComputationState<T> createStartState(NFA<T> nfa, State<T> state, DeweyNumber version) {
        Preconditions.checkArgument((boolean)state.isStart());
        return new ComputationState<Object>(nfa, state, null, null, 0, -1L, version, -1L);
    }

    public static <T> ComputationState<T> createState(NFA<T> nfa, State<T> currentState, State<T> previousState, T event, int counter, long timestamp, DeweyNumber version, long startTimestamp) {
        return new ComputationState<T>(nfa, currentState, previousState, event, counter, timestamp, version, startTimestamp);
    }

    public boolean isStopState() {
        return this.state.isStop();
    }

    public class ConditionContext
    implements IterativeCondition.Context<T> {
        private static final long serialVersionUID = -6733978464782277795L;
        private boolean shouldUpdate;
        private transient ComputationState<T> computationState;
        private final NFA<T> nfa;
        private transient Map<String, List<T>> matchedEvents;

        public ConditionContext(NFA<T> nfa, ComputationState<T> computationState) {
            this.nfa = nfa;
            this.computationState = computationState;
            this.shouldUpdate = true;
        }

        @Override
        public Iterable<T> getEventsForPattern(final String key) {
            Preconditions.checkNotNull((Object)key);
            if (this.shouldUpdate) {
                this.matchedEvents = this.nfa.extractCurrentMatches(this.computationState);
                this.shouldUpdate = false;
            }
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    List elements = (List)ConditionContext.this.matchedEvents.get(key);
                    return elements == null ? Collections.EMPTY_LIST.iterator() : elements.iterator();
                }
            };
        }
    }
}

