/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.cep.NonDuplicatingTypeSerializer;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.SharedBuffer;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransition;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.nfa.compiler.NFAStateNameHandler;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.shaded.com.google.common.base.Predicate;
import org.apache.flink.shaded.com.google.common.collect.Iterators;
import org.apache.flink.util.Preconditions;

public class NFA<T>
implements Serializable {
    private static final long serialVersionUID = 2957674889294717265L;
    @Deprecated
    private final SharedBuffer<State<T>, T> sharedBuffer = null;
    @Deprecated
    private int startEventCounter;
    @Deprecated
    private final NonDuplicatingTypeSerializer<T> nonDuplicatingTypeSerializer;
    private Set<State<T>> states;
    private final long windowTime;
    private final boolean handleTimeout;
    private transient Queue<ComputationState<T>> computationStates;
    private SharedBuffer<String, T> eventSharedBuffer;
    private TypeSerializer<T> eventSerializer;
    private static final String BEGINNING_STATE_NAME = "$beginningState$";

    public NFA(TypeSerializer<T> eventSerializer, long windowTime, boolean handleTimeout) {
        this.eventSerializer = eventSerializer;
        this.nonDuplicatingTypeSerializer = new NonDuplicatingTypeSerializer<T>(eventSerializer);
        this.windowTime = windowTime;
        this.handleTimeout = handleTimeout;
        this.eventSharedBuffer = new SharedBuffer(this.nonDuplicatingTypeSerializer);
        this.computationStates = new LinkedList<ComputationState<T>>();
        this.states = new HashSet<State<T>>();
    }

    public Set<State<T>> getStates() {
        return this.states;
    }

    public void addStates(Collection<State<T>> newStates) {
        for (State<T> state : newStates) {
            this.addState(state);
        }
    }

    public void addState(State<T> state) {
        this.states.add(state);
        if (state.isStart()) {
            this.computationStates.add(ComputationState.createStartState(this, state));
        }
    }

    public boolean isEmpty() {
        return this.eventSharedBuffer.isEmpty();
    }

    public Tuple2<Collection<Map<String, List<T>>>, Collection<Tuple2<Map<String, List<T>>, Long>>> process(T event, long timestamp) {
        long pruningTimestamp;
        int numberComputationStates = this.computationStates.size();
        ArrayList<Map<String, List<T>>> result = new ArrayList<Map<String, List<T>>>();
        ArrayList<Tuple2> timeoutResult = new ArrayList<Tuple2>();
        for (int i = 0; i < numberComputationStates; ++i) {
            Collection<ComputationState<T>> newComputationStates;
            ComputationState<T> computationState = this.computationStates.poll();
            if (!computationState.isStartState() && this.windowTime > 0L && timestamp - computationState.getStartTimestamp() >= this.windowTime) {
                if (this.handleTimeout) {
                    Map<String, List<T>> timedoutPattern = this.extractCurrentMatches(computationState);
                    timeoutResult.add(Tuple2.of(timedoutPattern, (Object)timestamp));
                }
                this.eventSharedBuffer.release(NFAStateNameHandler.getOriginalNameFromInternal(computationState.getPreviousState().getName()), computationState.getEvent(), computationState.getTimestamp(), computationState.getCounter());
                newComputationStates = Collections.emptyList();
            } else {
                newComputationStates = event != null ? this.computeNextStates(computationState, event, timestamp) : Collections.singleton(computationState);
            }
            ArrayList<ComputationState<T>> statesToRetain = new ArrayList<ComputationState<T>>();
            boolean shouldDiscardPath = false;
            for (ComputationState<T> computationState2 : newComputationStates) {
                if (computationState2.isFinalState()) {
                    Map<String, List<T>> matchedPattern = this.extractCurrentMatches(computationState2);
                    result.add(matchedPattern);
                    this.eventSharedBuffer.release(NFAStateNameHandler.getOriginalNameFromInternal(computationState2.getPreviousState().getName()), computationState2.getEvent(), computationState2.getTimestamp(), computationState.getCounter());
                    continue;
                }
                if (computationState2.isStopState()) {
                    shouldDiscardPath = true;
                    this.eventSharedBuffer.release(NFAStateNameHandler.getOriginalNameFromInternal(computationState2.getPreviousState().getName()), computationState2.getEvent(), computationState2.getTimestamp(), computationState.getCounter());
                    continue;
                }
                statesToRetain.add(computationState2);
            }
            if (shouldDiscardPath) {
                for (ComputationState<Object> computationState3 : statesToRetain) {
                    this.eventSharedBuffer.release(NFAStateNameHandler.getOriginalNameFromInternal(computationState3.getPreviousState().getName()), computationState3.getEvent(), computationState3.getTimestamp(), computationState3.getCounter());
                }
                continue;
            }
            this.computationStates.addAll(statesToRetain);
        }
        if (this.windowTime > 0L && (pruningTimestamp = timestamp - this.windowTime) < timestamp) {
            this.eventSharedBuffer.prune(pruningTimestamp);
        }
        return Tuple2.of(result, timeoutResult);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NFA) {
            NFA other = (NFA)obj;
            return this.nonDuplicatingTypeSerializer.equals(other.nonDuplicatingTypeSerializer) && this.eventSharedBuffer.equals(other.eventSharedBuffer) && this.states.equals(other.states) && this.windowTime == other.windowTime;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nonDuplicatingTypeSerializer, this.eventSharedBuffer, this.states, this.windowTime});
    }

    private static <T> boolean isEquivalentState(State<T> s1, State<T> s2) {
        return s1.getName().equals(s2.getName());
    }

    private Collection<ComputationState<T>> computeNextStates(ComputationState<T> computationState, T event, long timestamp) {
        OutgoingEdges<T> outgoingEdges = this.createDecisionGraph(computationState, event);
        List<StateTransition<T>> edges = outgoingEdges.getEdges();
        int takeBranchesToVisit = Math.max(0, outgoingEdges.getTotalTakeBranches() - 1);
        int ignoreBranchesToVisit = outgoingEdges.getTotalIgnoreBranches();
        int totalTakeToSkip = Math.max(0, outgoingEdges.getTotalTakeBranches() - 1);
        ArrayList<ComputationState<T>> resultingComputationStates = new ArrayList<ComputationState<T>>();
        for (StateTransition<T> edge : edges) {
            switch (edge.getAction()) {
                case IGNORE: {
                    DeweyNumber version;
                    if (computationState.isStartState()) break;
                    if (NFA.isEquivalentState(edge.getTargetState(), computationState.getState())) {
                        int toIncrease = this.calculateIncreasingSelfState(outgoingEdges.getTotalIgnoreBranches(), outgoingEdges.getTotalTakeBranches());
                        version = computationState.getVersion().increase(toIncrease);
                    } else {
                        version = computationState.getVersion().increase(totalTakeToSkip + ignoreBranchesToVisit).addStage();
                        --ignoreBranchesToVisit;
                    }
                    this.addComputationState(resultingComputationStates, edge.getTargetState(), computationState.getPreviousState(), computationState.getEvent(), computationState.getCounter(), computationState.getTimestamp(), version, computationState.getStartTimestamp());
                    break;
                }
                case TAKE: {
                    int counter;
                    long startTimestamp;
                    State<T> nextState = edge.getTargetState();
                    State<T> currentState = edge.getSourceState();
                    State<T> previousState = computationState.getPreviousState();
                    T previousEvent = computationState.getEvent();
                    DeweyNumber currentVersion = computationState.getVersion().increase(takeBranchesToVisit);
                    DeweyNumber nextVersion = new DeweyNumber(currentVersion).addStage();
                    --takeBranchesToVisit;
                    if (computationState.isStartState()) {
                        startTimestamp = timestamp;
                        counter = this.eventSharedBuffer.put(NFAStateNameHandler.getOriginalNameFromInternal(currentState.getName()), event, timestamp, currentVersion);
                    } else {
                        startTimestamp = computationState.getStartTimestamp();
                        counter = this.eventSharedBuffer.put(NFAStateNameHandler.getOriginalNameFromInternal(currentState.getName()), event, timestamp, NFAStateNameHandler.getOriginalNameFromInternal(previousState.getName()), previousEvent, computationState.getTimestamp(), computationState.getCounter(), currentVersion);
                    }
                    this.addComputationState(resultingComputationStates, nextState, currentState, event, counter, timestamp, nextVersion, startTimestamp);
                    State<T> finalState = this.findFinalStateAfterProceed(nextState, event, computationState);
                    if (finalState == null) break;
                    this.addComputationState(resultingComputationStates, finalState, currentState, event, counter, timestamp, nextVersion, startTimestamp);
                }
            }
        }
        if (computationState.isStartState()) {
            int totalBranches = this.calculateIncreasingSelfState(outgoingEdges.getTotalIgnoreBranches(), outgoingEdges.getTotalTakeBranches());
            DeweyNumber startVersion = computationState.getVersion().increase(totalBranches);
            ComputationState<T> startState = ComputationState.createStartState(this, computationState.getState(), startVersion);
            resultingComputationStates.add(startState);
        }
        if (computationState.getEvent() != null) {
            this.eventSharedBuffer.release(NFAStateNameHandler.getOriginalNameFromInternal(computationState.getPreviousState().getName()), computationState.getEvent(), computationState.getTimestamp(), computationState.getCounter());
        }
        return resultingComputationStates;
    }

    private void addComputationState(List<ComputationState<T>> computationStates, State<T> currentState, State<T> previousState, T event, int counter, long timestamp, DeweyNumber version, long startTimestamp) {
        ComputationState<T> computationState = ComputationState.createState(this, currentState, previousState, event, counter, timestamp, version, startTimestamp);
        computationStates.add(computationState);
        String originalStateName = NFAStateNameHandler.getOriginalNameFromInternal(previousState.getName());
        this.eventSharedBuffer.lock(originalStateName, event, timestamp, counter);
    }

    private State<T> findFinalStateAfterProceed(State<T> state, T event, ComputationState<T> computationState) {
        Stack statesToCheck = new Stack();
        statesToCheck.push(state);
        try {
            while (!statesToCheck.isEmpty()) {
                State currentState = (State)statesToCheck.pop();
                for (StateTransition transition : currentState.getStateTransitions()) {
                    if (transition.getAction() != StateTransitionAction.PROCEED || !this.checkFilterCondition(computationState, transition.getCondition(), event)) continue;
                    if (transition.getTargetState().isFinal()) {
                        return transition.getTargetState();
                    }
                    statesToCheck.push(transition.getTargetState());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failure happened in filter function.", e);
        }
        return null;
    }

    private int calculateIncreasingSelfState(int ignoreBranches, int takeBranches) {
        return takeBranches == 0 && ignoreBranches == 0 ? 0 : ignoreBranches + Math.max(1, takeBranches);
    }

    private OutgoingEdges<T> createDecisionGraph(ComputationState<T> computationState, T event) {
        OutgoingEdges outgoingEdges = new OutgoingEdges(computationState.getState());
        Stack states = new Stack();
        states.push(computationState.getState());
        while (!states.isEmpty()) {
            State currentState = (State)states.pop();
            Collection stateTransitions = currentState.getStateTransitions();
            for (StateTransition stateTransition : stateTransitions) {
                try {
                    if (!this.checkFilterCondition(computationState, stateTransition.getCondition(), event)) continue;
                    switch (stateTransition.getAction()) {
                        case PROCEED: {
                            states.push(stateTransition.getTargetState());
                            break;
                        }
                        case IGNORE: 
                        case TAKE: {
                            outgoingEdges.add(stateTransition);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failure happened in filter function.", e);
                }
            }
        }
        return outgoingEdges;
    }

    private boolean checkFilterCondition(ComputationState<T> computationState, IterativeCondition<T> condition, T event) throws Exception {
        return condition == null || condition.filter(event, computationState.getConditionContext());
    }

    Map<String, List<T>> extractCurrentMatches(ComputationState<T> computationState) {
        List<Map<String, List<T>>> paths;
        if (computationState.getPreviousState() == null) {
            return new HashMap<String, List<T>>();
        }
        if (this.eventSerializer == null) {
            this.eventSerializer = this.nonDuplicatingTypeSerializer.getTypeSerializer();
        }
        if ((paths = this.eventSharedBuffer.extractPatterns(NFAStateNameHandler.getOriginalNameFromInternal(computationState.getPreviousState().getName()), computationState.getEvent(), computationState.getTimestamp(), computationState.getCounter(), computationState.getVersion())).isEmpty()) {
            return new HashMap<String, List<T>>();
        }
        Preconditions.checkState((paths.size() == 1 ? 1 : 0) != 0);
        HashMap<String, List<T>> result = new HashMap<String, List<T>>();
        Map<String, List<T>> path = paths.get(0);
        for (String key : path.keySet()) {
            List<T> events = path.get(key);
            ArrayList<T> values = (ArrayList<T>)result.get(key);
            if (values == null) {
                values = new ArrayList<T>(events.size());
                result.put(key, values);
            }
            for (T event : events) {
                values.add(this.eventSerializer.isImmutableType() ? event : this.eventSerializer.copy(event));
            }
        }
        return result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int numberComputationStates = ois.readInt();
        this.computationStates = new LinkedList<ComputationState<T>>();
        ArrayList<ComputationState<T>> readComputationStates = new ArrayList<ComputationState<T>>(numberComputationStates);
        boolean afterMigration = false;
        for (int i = 0; i < numberComputationStates; ++i) {
            ComputationState<T> computationState = this.readComputationState(ois);
            if (computationState.getState().getName().equals(BEGINNING_STATE_NAME)) {
                afterMigration = true;
            }
            readComputationStates.add(computationState);
        }
        if (afterMigration && !readComputationStates.isEmpty()) {
            try {
                this.computationStates.addAll(this.migrateNFA(readComputationStates));
                Field newSharedBufferField = NFA.class.getDeclaredField("eventSharedBuffer");
                Field sharedBufferField = NFA.class.getDeclaredField("sharedBuffer");
                sharedBufferField.setAccessible(true);
                newSharedBufferField.setAccessible(true);
                newSharedBufferField.set(this, SharedBuffer.migrateSharedBuffer(this.sharedBuffer));
                sharedBufferField.set(this, null);
                sharedBufferField.setAccessible(false);
                newSharedBufferField.setAccessible(false);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not migrate from earlier version", e);
            }
        } else {
            this.computationStates.addAll(readComputationStates);
        }
        this.nonDuplicatingTypeSerializer.clearReferences();
    }

    private Collection<ComputationState<T>> migrateNFA(Collection<ComputationState<T>> readStates) {
        ArrayList<ComputationState<T>> computationStates = new ArrayList<ComputationState<T>>();
        State<T> startState = Iterators.find(readStates.iterator(), new Predicate<ComputationState<T>>(){

            @Override
            public boolean apply(@Nullable ComputationState<T> input) {
                return input != null && input.getState().getName().equals(NFA.BEGINNING_STATE_NAME);
            }
        }).getState();
        Map<String, State<T>> convertedStates = NFACompiler.migrateGraph(startState);
        for (ComputationState<T> readState : readStates) {
            if (readState.isStartState()) continue;
            String previousName = readState.getState().getName();
            String currentName = Iterators.find(readState.getState().getStateTransitions().iterator(), new Predicate<StateTransition<T>>(){

                @Override
                public boolean apply(@Nullable StateTransition<T> input) {
                    return input != null && input.getAction() == StateTransitionAction.TAKE;
                }
            }).getTargetState().getName();
            State<T> previousState = convertedStates.get(previousName);
            computationStates.add(ComputationState.createState(this, convertedStates.get(currentName), previousState, readState.getEvent(), 0, readState.getTimestamp(), readState.getVersion(), readState.getStartTimestamp()));
        }
        String startName = Iterators.find(convertedStates.values().iterator(), new Predicate<State<T>>(){

            @Override
            public boolean apply(@Nullable State<T> input) {
                return input != null && input.isStart();
            }
        }).getName();
        computationStates.add(ComputationState.createStartState(this, convertedStates.get(startName), new DeweyNumber(this.startEventCounter)));
        this.states.clear();
        this.states.addAll(convertedStates.values());
        return computationStates;
    }

    private ComputationState<T> readComputationState(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object event;
        State previousState;
        State state = (State)ois.readObject();
        try {
            previousState = (State)ois.readObject();
        }
        catch (OptionalDataException e) {
            previousState = null;
        }
        long timestamp = ois.readLong();
        DeweyNumber version = (DeweyNumber)ois.readObject();
        long startTimestamp = ois.readLong();
        boolean hasEvent = ois.readBoolean();
        if (hasEvent) {
            DataInputViewStreamWrapper input = new DataInputViewStreamWrapper((InputStream)ois);
            event = this.nonDuplicatingTypeSerializer.deserialize((DataInputView)input);
        } else {
            event = null;
        }
        return ComputationState.createState(this, state, previousState, event, 0, timestamp, version, startTimestamp);
    }

    public static class Serializer<T>
    extends TypeSerializerSingleton<NFA<T>> {
        private static final long serialVersionUID = 1L;

        public boolean isImmutableType() {
            return false;
        }

        public NFA<T> createInstance() {
            return null;
        }

        public NFA<T> copy(NFA<T> from) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(from);
                oos.close();
                baos.close();
                byte[] data = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bais);
                NFA copy = (NFA)ois.readObject();
                ois.close();
                bais.close();
                return copy;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Could not copy NFA.", e);
            }
        }

        public NFA<T> copy(NFA<T> from, NFA<T> reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return 0;
        }

        public void serialize(NFA<T> record, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException("This is the deprecated serialization strategy.");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public NFA<T> deserialize(DataInputView source) throws IOException {
            try (ObjectInputStream ois = new ObjectInputStream((InputStream)new DataInputViewStream(source));){
                NFA nFA = (NFA)ois.readObject();
                return nFA;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not deserialize NFA.", e);
            }
        }

        public NFA<T> deserialize(NFA<T> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            int size = source.readInt();
            target.writeInt(size);
            target.write(source, size);
        }

        public boolean canEqual(Object obj) {
            return obj instanceof Serializer;
        }
    }

    public static class NFASerializer<T>
    extends TypeSerializer<NFA<T>> {
        private static final long serialVersionUID = 2098282423980597010L;
        private final TypeSerializer<SharedBuffer<String, T>> sharedBufferSerializer;
        private final TypeSerializer<T> eventSerializer;

        public NFASerializer(TypeSerializer<T> typeSerializer) {
            this(typeSerializer, new SharedBuffer.SharedBufferSerializer(StringSerializer.INSTANCE, typeSerializer));
        }

        public NFASerializer(TypeSerializer<T> typeSerializer, TypeSerializer<SharedBuffer<String, T>> sharedBufferSerializer) {
            this.eventSerializer = typeSerializer;
            this.sharedBufferSerializer = sharedBufferSerializer;
        }

        public boolean isImmutableType() {
            return false;
        }

        public TypeSerializer<NFA<T>> duplicate() {
            return this;
        }

        public NFA<T> createInstance() {
            return null;
        }

        public NFA<T> copy(NFA<T> from) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                this.serialize(from, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)oos));
                oos.close();
                baos.close();
                byte[] data = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object copy = this.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)ois));
                ois.close();
                bais.close();
                return copy;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy NFA.", e);
            }
        }

        public NFA<T> copy(NFA<T> from, NFA<T> reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(NFA<T> record, DataOutputView target) throws IOException {
            this.serializeStates(((NFA)record).states, target);
            target.writeLong(((NFA)record).windowTime);
            target.writeBoolean(((NFA)record).handleTimeout);
            this.sharedBufferSerializer.serialize((Object)((NFA)record).eventSharedBuffer, target);
            target.writeInt(((NFA)record).computationStates.size());
            StringSerializer stateNameSerializer = StringSerializer.INSTANCE;
            LongSerializer timestampSerializer = LongSerializer.INSTANCE;
            DeweyNumber.DeweyNumberSerializer versionSerializer = new DeweyNumber.DeweyNumberSerializer();
            for (ComputationState computationState : ((NFA)record).computationStates) {
                stateNameSerializer.serialize(computationState.getState().getName(), target);
                stateNameSerializer.serialize(computationState.getPreviousState() == null ? null : computationState.getPreviousState().getName(), target);
                timestampSerializer.serialize(Long.valueOf(computationState.getTimestamp()), target);
                versionSerializer.serialize(computationState.getVersion(), target);
                timestampSerializer.serialize(Long.valueOf(computationState.getStartTimestamp()), target);
                target.writeInt(computationState.getCounter());
                if (computationState.getEvent() == null) {
                    target.writeBoolean(false);
                    continue;
                }
                target.writeBoolean(true);
                this.eventSerializer.serialize(computationState.getEvent(), target);
            }
        }

        public NFA<T> deserialize(DataInputView source) throws IOException {
            Set<State<T>> states = this.deserializeStates(source);
            long windowTime = source.readLong();
            boolean handleTimeout = source.readBoolean();
            NFA<T> nfa = new NFA<T>(this.eventSerializer, windowTime, handleTimeout);
            ((NFA)nfa).states = states;
            ((NFA)nfa).eventSharedBuffer = (SharedBuffer)this.sharedBufferSerializer.deserialize(source);
            LinkedList<ComputationState<Object>> computationStates = new LinkedList<ComputationState<Object>>();
            StringSerializer stateNameSerializer = StringSerializer.INSTANCE;
            LongSerializer timestampSerializer = LongSerializer.INSTANCE;
            DeweyNumber.DeweyNumberSerializer versionSerializer = new DeweyNumber.DeweyNumberSerializer();
            int computationStateNo = source.readInt();
            for (int i = 0; i < computationStateNo; ++i) {
                State<T> state = this.getStateByName(stateNameSerializer.deserialize(source), nfa);
                State<T> prevState = this.getStateByName(stateNameSerializer.deserialize(source), nfa);
                long timestamp = timestampSerializer.deserialize(source);
                DeweyNumber version = versionSerializer.deserialize(source);
                long startTimestamp = timestampSerializer.deserialize(source);
                int counter = source.readInt();
                Object event = null;
                if (source.readBoolean()) {
                    event = this.eventSerializer.deserialize(source);
                }
                computationStates.add(ComputationState.createState(nfa, state, prevState, event, counter, timestamp, version, startTimestamp));
            }
            ((NFA)nfa).computationStates = computationStates;
            return nfa;
        }

        private State<T> getStateByName(String name, NFA<T> nfa) {
            for (State state : ((NFA)nfa).states) {
                if (!state.getName().equals(name)) continue;
                return state;
            }
            return null;
        }

        public NFA<T> deserialize(NFA<T> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            Set<State<T>> states = this.deserializeStates(source);
            this.serializeStates(states, target);
            long windowTime = source.readLong();
            target.writeLong(windowTime);
            boolean handleTimeout = source.readBoolean();
            target.writeBoolean(handleTimeout);
            SharedBuffer sharedBuffer = (SharedBuffer)this.sharedBufferSerializer.deserialize(source);
            this.sharedBufferSerializer.serialize((Object)sharedBuffer, target);
            StringSerializer stateNameSerializer = StringSerializer.INSTANCE;
            LongSerializer timestampSerializer = LongSerializer.INSTANCE;
            DeweyNumber.DeweyNumberSerializer versionSerializer = new DeweyNumber.DeweyNumberSerializer();
            int computationStateNo = source.readInt();
            target.writeInt(computationStateNo);
            for (int i = 0; i < computationStateNo; ++i) {
                String stateName = stateNameSerializer.deserialize(source);
                stateNameSerializer.serialize(stateName, target);
                String prevStateName = stateNameSerializer.deserialize(source);
                stateNameSerializer.serialize(prevStateName, target);
                long timestamp = timestampSerializer.deserialize(source);
                timestampSerializer.serialize(Long.valueOf(timestamp), target);
                DeweyNumber version = versionSerializer.deserialize(source);
                versionSerializer.serialize(version, target);
                long startTimestamp = timestampSerializer.deserialize(source);
                timestampSerializer.serialize(Long.valueOf(startTimestamp), target);
                int counter = source.readInt();
                target.writeInt(counter);
                boolean hasEvent = source.readBoolean();
                target.writeBoolean(hasEvent);
                if (!hasEvent) continue;
                Object event = this.eventSerializer.deserialize(source);
                this.eventSerializer.serialize(event, target);
            }
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(((Object)((Object)this)).getClass()) && this.sharedBufferSerializer.equals(((NFASerializer)((Object)obj)).sharedBufferSerializer) && this.eventSerializer.equals(((NFASerializer)((Object)obj)).eventSerializer);
        }

        public boolean canEqual(Object obj) {
            return true;
        }

        public int hashCode() {
            return 37 * this.sharedBufferSerializer.hashCode() + this.eventSerializer.hashCode();
        }

        public TypeSerializerConfigSnapshot snapshotConfiguration() {
            return new NFASerializerConfigSnapshot<T>(this.eventSerializer, this.sharedBufferSerializer);
        }

        public CompatibilityResult<NFA<T>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
            if (configSnapshot instanceof NFASerializerConfigSnapshot) {
                List serializersAndConfigs = ((NFASerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
                CompatibilityResult eventCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)((Tuple2)serializersAndConfigs.get((int)0)).f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)((Tuple2)serializersAndConfigs.get((int)0)).f1), this.eventSerializer);
                CompatibilityResult sharedBufCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)((Tuple2)serializersAndConfigs.get((int)1)).f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)((Tuple2)serializersAndConfigs.get((int)1)).f1), this.sharedBufferSerializer);
                if (!sharedBufCompatResult.isRequiresMigration() && !eventCompatResult.isRequiresMigration()) {
                    return CompatibilityResult.compatible();
                }
                if (eventCompatResult.getConvertDeserializer() != null && sharedBufCompatResult.getConvertDeserializer() != null) {
                    return CompatibilityResult.requiresMigration(new NFASerializer<T>(new TypeDeserializerAdapter(eventCompatResult.getConvertDeserializer()), new TypeDeserializerAdapter(sharedBufCompatResult.getConvertDeserializer())));
                }
            }
            return CompatibilityResult.requiresMigration();
        }

        private void serializeStates(Set<State<T>> states, DataOutputView out) throws IOException {
            StringSerializer nameSerializer = StringSerializer.INSTANCE;
            EnumSerializer stateTypeSerializer = new EnumSerializer(State.StateType.class);
            EnumSerializer actionSerializer = new EnumSerializer(StateTransitionAction.class);
            out.writeInt(states.size());
            for (State<T> state : states) {
                nameSerializer.serialize((Object)state.getName(), out);
                stateTypeSerializer.serialize((Object)state.getStateType(), out);
            }
            for (State<T> state : states) {
                nameSerializer.serialize((Object)state.getName(), out);
                out.writeInt(state.getStateTransitions().size());
                for (StateTransition<T> transition : state.getStateTransitions()) {
                    nameSerializer.serialize((Object)transition.getSourceState().getName(), out);
                    nameSerializer.serialize((Object)transition.getTargetState().getName(), out);
                    actionSerializer.serialize((Object)transition.getAction(), out);
                    this.serializeCondition(transition.getCondition(), out);
                }
            }
        }

        private Set<State<T>> deserializeStates(DataInputView in) throws IOException {
            int i;
            StringSerializer nameSerializer = StringSerializer.INSTANCE;
            EnumSerializer stateTypeSerializer = new EnumSerializer(State.StateType.class);
            EnumSerializer actionSerializer = new EnumSerializer(StateTransitionAction.class);
            int noOfStates = in.readInt();
            HashMap states = new HashMap(noOfStates);
            for (i = 0; i < noOfStates; ++i) {
                String stateName = (String)nameSerializer.deserialize(in);
                State.StateType stateType = (State.StateType)((Object)stateTypeSerializer.deserialize(in));
                State state = new State(stateName, stateType);
                states.put(stateName, state);
            }
            for (i = 0; i < noOfStates; ++i) {
                String srcName = (String)nameSerializer.deserialize(in);
                int noOfTransitions = in.readInt();
                for (int j = 0; j < noOfTransitions; ++j) {
                    String src = (String)nameSerializer.deserialize(in);
                    Preconditions.checkState((boolean)src.equals(srcName), (Object)("Source Edge names do not match (" + srcName + " - " + src + ")."));
                    String trgt = (String)nameSerializer.deserialize(in);
                    StateTransitionAction action = (StateTransitionAction)((Object)actionSerializer.deserialize(in));
                    IterativeCondition<T> condition = null;
                    try {
                        condition = this.deserializeCondition(in);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    State srcState = (State)states.get(src);
                    State trgtState = (State)states.get(trgt);
                    srcState.addStateTransition(action, trgtState, condition);
                }
            }
            return new HashSet<State<T>>(states.values());
        }

        private void serializeCondition(IterativeCondition<T> condition, DataOutputView out) throws IOException {
            out.writeBoolean(condition != null);
            if (condition != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(condition);
                oos.close();
                baos.close();
                byte[] serCondition = baos.toByteArray();
                out.writeInt(serCondition.length);
                out.write(serCondition);
            }
        }

        private IterativeCondition<T> deserializeCondition(DataInputView in) throws IOException, ClassNotFoundException {
            boolean hasCondition = in.readBoolean();
            if (hasCondition) {
                int length = in.readInt();
                byte[] serCondition = new byte[length];
                in.read(serCondition);
                ByteArrayInputStream bais = new ByteArrayInputStream(serCondition);
                ObjectInputStream ois = new ObjectInputStream(bais);
                IterativeCondition condition = (IterativeCondition)ois.readObject();
                ois.close();
                bais.close();
                return condition;
            }
            return null;
        }
    }

    public static final class NFASerializerConfigSnapshot<T>
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 1;

        public NFASerializerConfigSnapshot() {
        }

        public NFASerializerConfigSnapshot(TypeSerializer<T> eventSerializer, TypeSerializer<SharedBuffer<String, T>> sharedBufferSerializer) {
            super(new TypeSerializer[]{eventSerializer, sharedBufferSerializer});
        }

        public int getVersion() {
            return 1;
        }
    }

    private static class OutgoingEdges<T> {
        private List<StateTransition<T>> edges = new ArrayList<StateTransition<T>>();
        private final State<T> currentState;
        private int totalTakeBranches = 0;
        private int totalIgnoreBranches = 0;

        OutgoingEdges(State<T> currentState) {
            this.currentState = currentState;
        }

        void add(StateTransition<T> edge) {
            if (!this.isSelfIgnore(edge)) {
                if (edge.getAction() == StateTransitionAction.IGNORE) {
                    ++this.totalIgnoreBranches;
                } else if (edge.getAction() == StateTransitionAction.TAKE) {
                    ++this.totalTakeBranches;
                }
            }
            this.edges.add(edge);
        }

        int getTotalIgnoreBranches() {
            return this.totalIgnoreBranches;
        }

        int getTotalTakeBranches() {
            return this.totalTakeBranches;
        }

        List<StateTransition<T>> getEdges() {
            return this.edges;
        }

        private boolean isSelfIgnore(StateTransition<T> edge) {
            return NFA.isEquivalentState(edge.getTargetState(), this.currentState) && edge.getAction() == StateTransitionAction.IGNORE;
        }
    }
}

