/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.NonDuplicatingTypeSerializer;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;

public class SharedBuffer<K extends Serializable, V>
implements Serializable {
    private static final long serialVersionUID = 9213251042562206495L;
    @Deprecated
    private final TypeSerializer<V> valueSerializer;
    private transient Map<K, SharedBufferPage<K, V>> pages;

    public SharedBuffer(TypeSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        this.pages = new HashMap<K, SharedBufferPage<K, V>>();
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer instanceof NonDuplicatingTypeSerializer ? ((NonDuplicatingTypeSerializer)this.valueSerializer).getTypeSerializer() : this.valueSerializer;
    }

    public int put(K key, V value, long timestamp, K previousKey, V previousValue, long previousTimestamp, int previousCounter, DeweyNumber version) {
        SharedBufferEntry<K, V> previousSharedBufferEntry = this.get(previousKey, previousValue, previousTimestamp, previousCounter);
        if (previousSharedBufferEntry == null && previousValue != null) {
            throw new IllegalStateException("Could not find previous entry with key: " + previousKey + ", value: " + previousValue + " and timestamp: " + previousTimestamp + ". This can indicate that either you did not implement the equals() and hashCode() methods of your input elements properly or that the element belonging to that entry has been already pruned.");
        }
        return this.put(key, value, timestamp, previousSharedBufferEntry, version);
    }

    public int put(K key, V value, long timestamp, DeweyNumber version) {
        return this.put(key, value, timestamp, null, version);
    }

    private int put(K key, V value, long timestamp, SharedBufferEntry<K, V> previousSharedBufferEntry, DeweyNumber version) {
        ValueTimeWrapper<V> prev;
        SharedBufferPage<K, V> page = this.pages.get(key);
        if (page == null) {
            page = new SharedBufferPage(key);
            this.pages.put(key, page);
        }
        int counter = 0;
        if (previousSharedBufferEntry != null && (prev = previousSharedBufferEntry.getValueTime()) != null && prev.getTimestamp() == timestamp) {
            counter = prev.getCounter() + 1;
        }
        page.add(new ValueTimeWrapper<V>(value, timestamp, counter), previousSharedBufferEntry, version);
        return counter;
    }

    public boolean isEmpty() {
        for (SharedBufferPage<K, V> page : this.pages.values()) {
            if (page.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void prune(long pruningTimestamp) {
        Iterator<Map.Entry<K, SharedBufferPage<K, V>>> iter = this.pages.entrySet().iterator();
        while (iter.hasNext()) {
            SharedBufferPage<K, V> page = iter.next().getValue();
            page.prune(pruningTimestamp);
            if (!page.isEmpty()) continue;
            iter.remove();
        }
    }

    public List<Map<K, List<V>>> extractPatterns(K key, V value, long timestamp, int counter, DeweyNumber version) {
        ArrayList<Map<K, List<V>>> result = new ArrayList<Map<K, List<V>>>();
        Stack extractionStates = new Stack();
        SharedBufferEntry<K, V> entry = this.get(key, value, timestamp, counter);
        if (entry != null) {
            extractionStates.add(new ExtractionState<K, V>(entry, version, new Stack()));
            while (!extractionStates.isEmpty()) {
                ExtractionState extractionState = (ExtractionState)extractionStates.pop();
                Stack currentPath = extractionState.getPath();
                SharedBufferEntry currentEntry = extractionState.getEntry();
                if (currentEntry == null) {
                    HashMap completePath = new HashMap();
                    while (!currentPath.isEmpty()) {
                        SharedBufferEntry currentPathEntry = currentPath.pop();
                        Serializable k = (Serializable)currentPathEntry.getKey();
                        ArrayList values = (ArrayList)completePath.get(k);
                        if (values == null) {
                            values = new ArrayList();
                            completePath.put(k, values);
                        }
                        values.add(currentPathEntry.getValueTime().getValue());
                    }
                    result.add(completePath);
                    continue;
                }
                currentPath.push(currentEntry);
                boolean firstMatch = true;
                for (SharedBufferEdge edge : currentEntry.getEdges()) {
                    DeweyNumber currentVersion = extractionState.getVersion();
                    if (!currentVersion.isCompatibleWith(edge.getVersion())) continue;
                    if (firstMatch) {
                        extractionStates.push(new ExtractionState(edge.getTarget(), edge.getVersion(), currentPath));
                        firstMatch = false;
                        continue;
                    }
                    Stack copy = new Stack();
                    copy.addAll(currentPath);
                    extractionStates.push(new ExtractionState(edge.getTarget(), edge.getVersion(), copy));
                }
            }
        }
        return result;
    }

    public void lock(K key, V value, long timestamp, int counter) {
        SharedBufferEntry<K, V> entry = this.get(key, value, timestamp, counter);
        if (entry != null) {
            entry.increaseReferenceCounter();
        }
    }

    public void release(K key, V value, long timestamp, int counter) {
        SharedBufferEntry<K, V> entry = this.get(key, value, timestamp, counter);
        if (entry != null) {
            this.internalRemove(entry);
        }
    }

    private SharedBuffer(TypeSerializer<V> valueSerializer, Map<K, SharedBufferPage<K, V>> pages) {
        this.valueSerializer = valueSerializer;
        this.pages = pages;
    }

    @Internal
    static <T> SharedBuffer<String, T> migrateSharedBuffer(SharedBuffer<State<T>, T> buffer) {
        HashMap pageMap = new HashMap();
        HashMap entries = new HashMap();
        for (Map.Entry page : buffer.pages.entrySet()) {
            SharedBufferPage newPage = new SharedBufferPage(((State)page.getKey()).getName());
            pageMap.put(newPage.getKey(), newPage);
            for (Map.Entry pageEntry : page.getValue().entries.entrySet()) {
                SharedBufferEntry newSharedBufferEntry = new SharedBufferEntry((ValueTimeWrapper)pageEntry.getKey(), newPage);
                newSharedBufferEntry.referenceCounter = ((SharedBufferEntry)pageEntry.getValue()).referenceCounter;
                entries.put(pageEntry.getValue(), newSharedBufferEntry);
                newPage.entries.put(pageEntry.getKey(), newSharedBufferEntry);
            }
        }
        for (Map.Entry page : buffer.pages.entrySet()) {
            for (Map.Entry pageEntry : page.getValue().entries.entrySet()) {
                SharedBufferEntry newEntry = (SharedBufferEntry)entries.get(pageEntry.getValue());
                for (SharedBufferEdge edge : ((SharedBufferEntry)pageEntry.getValue()).edges) {
                    SharedBufferEntry targetNewEntry = (SharedBufferEntry)entries.get(edge.getTarget());
                    SharedBufferEdge newEdge = new SharedBufferEdge(targetNewEntry, edge.getVersion());
                    newEntry.edges.add(newEdge);
                }
            }
        }
        return new SharedBuffer(buffer.valueSerializer, pageMap);
    }

    private SharedBufferEntry<K, V> get(K key, V value, long timestamp, int counter) {
        SharedBufferPage<K, V> page = this.pages.get(key);
        return page == null ? null : page.get(new ValueTimeWrapper<V>(value, timestamp, counter));
    }

    private void internalRemove(SharedBufferEntry<K, V> entry) {
        Stack entriesToRemove = new Stack();
        entriesToRemove.add(entry);
        while (!entriesToRemove.isEmpty()) {
            SharedBufferEntry currentEntry = (SharedBufferEntry)entriesToRemove.pop();
            currentEntry.decreaseReferenceCounter();
            if (currentEntry.getReferenceCounter() != 0) continue;
            currentEntry.remove();
            for (SharedBufferEdge edge : currentEntry.getEdges()) {
                if (edge.getTarget() == null) continue;
                entriesToRemove.push(edge.getTarget());
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<K, SharedBufferPage<K, V>> entry : this.pages.entrySet()) {
            builder.append("Key: ").append(entry.getKey()).append("\n");
            builder.append("Value: ").append(entry.getValue()).append("\n");
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SharedBuffer) {
            SharedBuffer other = (SharedBuffer)obj;
            return this.pages.equals(other.pages) && this.getValueSerializer().equals(other.getValueSerializer());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pages, this.getValueSerializer());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)ois);
        ArrayList<SharedBufferEntry<Serializable, Object>> entryList = new ArrayList<SharedBufferEntry<Serializable, Object>>();
        ois.defaultReadObject();
        this.pages = new HashMap<K, SharedBufferPage<K, V>>();
        int numberPages = ois.readInt();
        for (int i = 0; i < numberPages; ++i) {
            Serializable key = (Serializable)ois.readObject();
            SharedBufferPage page = new SharedBufferPage(key);
            this.pages.put(key, page);
            int numberEntries = ois.readInt();
            for (int j = 0; j < numberEntries; ++j) {
                Object value = this.valueSerializer.deserialize((DataInputView)source);
                long timestamp = ois.readLong();
                ValueTimeWrapper<Object> valueTimeWrapper = new ValueTimeWrapper<Object>(value, timestamp, 0);
                SharedBufferEntry<Serializable, Object> sharedBufferEntry = new SharedBufferEntry<Serializable, Object>(valueTimeWrapper, page);
                ((SharedBufferEntry)sharedBufferEntry).referenceCounter = ois.readInt();
                page.entries.put(valueTimeWrapper, sharedBufferEntry);
                entryList.add(sharedBufferEntry);
            }
        }
        int numberEdges = ois.readInt();
        for (int j = 0; j < numberEdges; ++j) {
            SharedBufferEntry target;
            int sourceIndex = ois.readInt();
            int targetIndex = ois.readInt();
            if (sourceIndex >= entryList.size() || sourceIndex < 0) {
                throw new RuntimeException("Could not find source entry with index " + sourceIndex + ". This indicates a corrupted state.");
            }
            SharedBufferEntry sourceEntry = (SharedBufferEntry)entryList.get(sourceIndex);
            DeweyNumber version = (DeweyNumber)ois.readObject();
            if (targetIndex >= 0) {
                if (targetIndex >= entryList.size()) {
                    throw new RuntimeException("Could not find target entry with index " + targetIndex + ". This indicates a corrupted state.");
                }
                target = (SharedBufferEntry)entryList.get(targetIndex);
            } else {
                target = null;
            }
            sourceEntry.edges.add(new SharedBufferEdge(target, version));
        }
    }

    public static class SharedBufferSerializer<K extends Serializable, V>
    extends TypeSerializer<SharedBuffer<K, V>> {
        private static final long serialVersionUID = -3254176794680331560L;
        private final TypeSerializer<K> keySerializer;
        private final TypeSerializer<V> valueSerializer;
        private final TypeSerializer<DeweyNumber> versionSerializer;

        public SharedBufferSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
            this(keySerializer, valueSerializer, (TypeSerializer<DeweyNumber>)new DeweyNumber.DeweyNumberSerializer());
        }

        public SharedBufferSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, TypeSerializer<DeweyNumber> versionSerializer) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.versionSerializer = versionSerializer;
        }

        public boolean isImmutableType() {
            return false;
        }

        public TypeSerializer<SharedBuffer<K, V>> duplicate() {
            return new SharedBufferSerializer<K, V>(this.keySerializer, this.valueSerializer);
        }

        public SharedBuffer<K, V> createInstance() {
            return new SharedBuffer(new NonDuplicatingTypeSerializer<V>(this.valueSerializer));
        }

        public SharedBuffer<K, V> copy(SharedBuffer from) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                this.serialize(from, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)oos));
                oos.close();
                baos.close();
                byte[] data = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bais);
                SharedBuffer copy = this.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)ois));
                ois.close();
                bais.close();
                return copy;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy SharredBuffer.", e);
            }
        }

        public SharedBuffer<K, V> copy(SharedBuffer from, SharedBuffer reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(SharedBuffer record, DataOutputView target) throws IOException {
            SharedBufferEntry sharedBuffer;
            SharedBufferPage page;
            Map pages = record.pages;
            HashMap<SharedBufferEntry, Integer> entryIDs = new HashMap<SharedBufferEntry, Integer>();
            int totalEdges = 0;
            int entryCounter = 0;
            target.writeInt(pages.size());
            for (Map.Entry pageEntry : pages.entrySet()) {
                page = (SharedBufferPage)pageEntry.getValue();
                this.keySerializer.serialize(page.getKey(), target);
                target.writeInt(page.entries.size());
                for (Map.Entry sharedBufferEntry : page.entries.entrySet()) {
                    sharedBuffer = (SharedBufferEntry)sharedBufferEntry.getValue();
                    entryIDs.put(sharedBuffer, entryCounter++);
                    ValueTimeWrapper valueTimeWrapper = sharedBuffer.getValueTime();
                    this.valueSerializer.serialize(valueTimeWrapper.getValue(), target);
                    target.writeLong(valueTimeWrapper.getTimestamp());
                    target.writeInt(valueTimeWrapper.getCounter());
                    int edges = sharedBuffer.edges.size();
                    totalEdges += edges;
                    target.writeInt(sharedBuffer.referenceCounter);
                }
            }
            target.writeInt(totalEdges);
            for (Map.Entry pageEntry : pages.entrySet()) {
                page = (SharedBufferPage)pageEntry.getValue();
                for (Map.Entry sharedBufferEntry : page.entries.entrySet()) {
                    sharedBuffer = (SharedBufferEntry)sharedBufferEntry.getValue();
                    Integer id = (Integer)entryIDs.get(sharedBuffer);
                    Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)("Could not find id for entry: " + sharedBuffer));
                    for (SharedBufferEdge edge : sharedBuffer.edges) {
                        if (edge.target != null) {
                            Integer targetId = (Integer)entryIDs.get(edge.getTarget());
                            Preconditions.checkState((targetId != null ? 1 : 0) != 0, (Object)("Could not find id for entry: " + edge.getTarget()));
                            target.writeInt(id.intValue());
                            target.writeInt(targetId.intValue());
                            this.versionSerializer.serialize((Object)edge.version, target);
                            continue;
                        }
                        target.writeInt(id.intValue());
                        target.writeInt(-1);
                        this.versionSerializer.serialize((Object)edge.version, target);
                    }
                }
            }
        }

        public SharedBuffer deserialize(DataInputView source) throws IOException {
            ArrayList<SharedBufferEntry<Serializable, Object>> entryList = new ArrayList<SharedBufferEntry<Serializable, Object>>();
            HashMap pages = new HashMap();
            int totalPages = source.readInt();
            for (int i = 0; i < totalPages; ++i) {
                Serializable key = (Serializable)this.keySerializer.deserialize(source);
                SharedBufferPage page = new SharedBufferPage(key);
                pages.put(key, page);
                int numberEntries = source.readInt();
                for (int j = 0; j < numberEntries; ++j) {
                    Object value = this.valueSerializer.deserialize(source);
                    long timestamp = source.readLong();
                    int counter = source.readInt();
                    ValueTimeWrapper<Object> valueTimeWrapper = new ValueTimeWrapper<Object>(value, timestamp, counter);
                    SharedBufferEntry<Serializable, Object> sharedBufferEntry = new SharedBufferEntry<Serializable, Object>(valueTimeWrapper, page);
                    ((SharedBufferEntry)sharedBufferEntry).referenceCounter = source.readInt();
                    page.entries.put(valueTimeWrapper, sharedBufferEntry);
                    entryList.add(sharedBufferEntry);
                }
            }
            int totalEdges = source.readInt();
            for (int j = 0; j < totalEdges; ++j) {
                int sourceIndex = source.readInt();
                Preconditions.checkState((sourceIndex < entryList.size() && sourceIndex >= 0 ? 1 : 0) != 0, (Object)("Could not find source entry with index " + sourceIndex + ". This indicates a corrupted state."));
                int targetIndex = source.readInt();
                Preconditions.checkState((targetIndex < entryList.size() ? 1 : 0) != 0, (Object)("Could not find target entry with index " + sourceIndex + ". This indicates a corrupted state."));
                DeweyNumber version = (DeweyNumber)this.versionSerializer.deserialize(source);
                SharedBufferEntry sourceEntry = (SharedBufferEntry)entryList.get(sourceIndex);
                SharedBufferEntry targetEntry = targetIndex < 0 ? null : (SharedBufferEntry)entryList.get(targetIndex);
                sourceEntry.edges.add(new SharedBufferEdge(targetEntry, version));
            }
            return new SharedBuffer(new NonDuplicatingTypeSerializer<V>(this.valueSerializer), pages);
        }

        public SharedBuffer deserialize(SharedBuffer reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            int numberPages = source.readInt();
            target.writeInt(numberPages);
            for (int i = 0; i < numberPages; ++i) {
                Serializable key = (Serializable)this.keySerializer.deserialize(source);
                this.keySerializer.serialize((Object)key, target);
                int numberEntries = source.readInt();
                for (int j = 0; j < numberEntries; ++j) {
                    Object value = this.valueSerializer.deserialize(source);
                    this.valueSerializer.serialize(value, target);
                    long timestamp = source.readLong();
                    target.writeLong(timestamp);
                    int counter = source.readInt();
                    target.writeInt(counter);
                    int referenceCounter = source.readInt();
                    target.writeInt(referenceCounter);
                }
            }
            int numberEdges = source.readInt();
            target.writeInt(numberEdges);
            for (int j = 0; j < numberEdges; ++j) {
                int sourceIndex = source.readInt();
                int targetIndex = source.readInt();
                target.writeInt(sourceIndex);
                target.writeInt(targetIndex);
                DeweyNumber version = (DeweyNumber)this.versionSerializer.deserialize(source);
                this.versionSerializer.serialize((Object)version, target);
            }
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(((Object)((Object)this)).getClass()) && this.keySerializer.equals(((SharedBufferSerializer)((Object)obj)).keySerializer) && this.valueSerializer.equals(((SharedBufferSerializer)((Object)obj)).valueSerializer) && this.versionSerializer.equals(((SharedBufferSerializer)((Object)obj)).versionSerializer);
        }

        public boolean canEqual(Object obj) {
            return true;
        }

        public int hashCode() {
            return 37 * this.keySerializer.hashCode() + this.valueSerializer.hashCode();
        }

        public TypeSerializerConfigSnapshot snapshotConfiguration() {
            return new SharedBufferSerializerConfigSnapshot<K, V>(this.keySerializer, this.valueSerializer, this.versionSerializer);
        }

        public CompatibilityResult<SharedBuffer<K, V>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
            if (configSnapshot instanceof SharedBufferSerializerConfigSnapshot) {
                List serializerConfigSnapshots = ((SharedBufferSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
                CompatibilityResult keyCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)((Tuple2)serializerConfigSnapshots.get((int)0)).f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)((Tuple2)serializerConfigSnapshots.get((int)0)).f1), this.keySerializer);
                CompatibilityResult valueCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)((Tuple2)serializerConfigSnapshots.get((int)1)).f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)((Tuple2)serializerConfigSnapshots.get((int)1)).f1), this.valueSerializer);
                CompatibilityResult versionCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)((Tuple2)serializerConfigSnapshots.get((int)2)).f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)((Tuple2)serializerConfigSnapshots.get((int)2)).f1), this.versionSerializer);
                if (!(keyCompatResult.isRequiresMigration() || valueCompatResult.isRequiresMigration() || versionCompatResult.isRequiresMigration())) {
                    return CompatibilityResult.compatible();
                }
                if (keyCompatResult.getConvertDeserializer() != null && valueCompatResult.getConvertDeserializer() != null && versionCompatResult.getConvertDeserializer() != null) {
                    return CompatibilityResult.requiresMigration(new SharedBufferSerializer<K, V>(new TypeDeserializerAdapter(keyCompatResult.getConvertDeserializer()), new TypeDeserializerAdapter(valueCompatResult.getConvertDeserializer()), (TypeSerializer<DeweyNumber>)new TypeDeserializerAdapter(versionCompatResult.getConvertDeserializer())));
                }
            }
            return CompatibilityResult.requiresMigration();
        }
    }

    public static final class SharedBufferSerializerConfigSnapshot<K, V>
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 1;

        public SharedBufferSerializerConfigSnapshot() {
        }

        public SharedBufferSerializerConfigSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, TypeSerializer<DeweyNumber> versionSerializer) {
            super(new TypeSerializer[]{keySerializer, valueSerializer, versionSerializer});
        }

        public int getVersion() {
            return 1;
        }
    }

    private static class ExtractionState<K, V> {
        private final SharedBufferEntry<K, V> entry;
        private final DeweyNumber version;
        private final Stack<SharedBufferEntry<K, V>> path;

        ExtractionState(SharedBufferEntry<K, V> entry, DeweyNumber version, Stack<SharedBufferEntry<K, V>> path) {
            this.entry = entry;
            this.version = version;
            this.path = path;
        }

        public SharedBufferEntry<K, V> getEntry() {
            return this.entry;
        }

        public DeweyNumber getVersion() {
            return this.version;
        }

        public Stack<SharedBufferEntry<K, V>> getPath() {
            return this.path;
        }

        public String toString() {
            return "ExtractionState(" + this.entry + ", " + this.version + ", [" + StringUtils.join(this.path, (String)", ") + "])";
        }
    }

    static class ValueTimeWrapper<V> {
        private final V value;
        private final long timestamp;
        private final int counter;

        ValueTimeWrapper(V value, long timestamp, int counter) {
            this.value = value;
            this.timestamp = timestamp;
            this.counter = counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public V getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "ValueTimeWrapper(" + this.value + ", " + this.timestamp + ", " + this.counter + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValueTimeWrapper) {
                ValueTimeWrapper other = (ValueTimeWrapper)obj;
                return this.timestamp == other.getTimestamp() && this.value.equals(other.getValue()) && this.counter == other.getCounter();
            }
            return false;
        }

        public int hashCode() {
            return (int)(31L * (31L * (this.timestamp ^ this.timestamp >>> 32) + (long)this.value.hashCode()) + (long)this.counter);
        }
    }

    public static class SharedBufferEdge<K, V> {
        private final SharedBufferEntry<K, V> target;
        private final DeweyNumber version;

        public SharedBufferEdge(SharedBufferEntry<K, V> target, DeweyNumber version) {
            this.target = target;
            this.version = version;
        }

        public SharedBufferEntry<K, V> getTarget() {
            return this.target;
        }

        public DeweyNumber getVersion() {
            return this.version;
        }

        public String toString() {
            return "SharedBufferEdge(" + this.target + ", " + this.version + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof SharedBufferEdge) {
                SharedBufferEdge other = (SharedBufferEdge)obj;
                if (this.version.equals(other.version)) {
                    if (this.target == null && other.target == null) {
                        return true;
                    }
                    if (this.target != null && other.target != null) {
                        return this.target.getKey().equals(other.target.getKey()) && this.target.getValueTime().equals(other.target.getValueTime());
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            if (this.target != null) {
                return Objects.hash(this.target.getKey(), this.target.getValueTime(), this.version);
            }
            return this.version.hashCode();
        }
    }

    private static class SharedBufferEntry<K, V> {
        private final ValueTimeWrapper<V> valueTime;
        private final Set<SharedBufferEdge<K, V>> edges;
        private final SharedBufferPage<K, V> page;
        private int referenceCounter;

        SharedBufferEntry(ValueTimeWrapper<V> valueTime, SharedBufferPage<K, V> page) {
            this(valueTime, null, page);
        }

        SharedBufferEntry(ValueTimeWrapper<V> valueTime, SharedBufferEdge<K, V> edge, SharedBufferPage<K, V> page) {
            this.valueTime = valueTime;
            this.edges = new HashSet<SharedBufferEdge<K, V>>();
            if (edge != null) {
                this.edges.add(edge);
            }
            this.referenceCounter = 0;
            this.page = page;
        }

        public ValueTimeWrapper<V> getValueTime() {
            return this.valueTime;
        }

        public Collection<SharedBufferEdge<K, V>> getEdges() {
            return this.edges;
        }

        public K getKey() {
            return this.page.getKey();
        }

        public void addEdge(SharedBufferEdge<K, V> edge) {
            this.edges.add(edge);
        }

        public boolean remove() {
            if (this.page != null) {
                this.page.remove(this.valueTime);
                return true;
            }
            return false;
        }

        public void increaseReferenceCounter() {
            ++this.referenceCounter;
        }

        public void decreaseReferenceCounter() {
            if (this.referenceCounter > 0) {
                --this.referenceCounter;
            }
        }

        public int getReferenceCounter() {
            return this.referenceCounter;
        }

        public String toString() {
            return "SharedBufferEntry(" + this.valueTime + ", [" + StringUtils.join(this.edges, (String)", ") + "], " + this.referenceCounter + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof SharedBufferEntry) {
                SharedBufferEntry other = (SharedBufferEntry)obj;
                return this.valueTime.equals(other.valueTime) && this.getKey().equals(other.getKey()) && this.referenceCounter == other.referenceCounter && this.edges.equals(other.edges);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.valueTime, this.getKey(), this.referenceCounter, this.edges);
        }
    }

    private static class SharedBufferPage<K, V> {
        private final K key;
        private final HashMap<ValueTimeWrapper<V>, SharedBufferEntry<K, V>> entries;

        public SharedBufferPage(K key) {
            this.key = key;
            this.entries = new HashMap();
        }

        public K getKey() {
            return this.key;
        }

        public void add(ValueTimeWrapper<V> valueTime, SharedBufferEntry<K, V> previous, DeweyNumber version) {
            SharedBufferEdge<K, V> newEdge;
            SharedBufferEntry<K, V> sharedBufferEntry = this.entries.get(valueTime);
            if (sharedBufferEntry == null) {
                sharedBufferEntry = new SharedBufferEntry(valueTime, this);
                this.entries.put(valueTime, sharedBufferEntry);
            }
            if (previous != null) {
                newEdge = new SharedBufferEdge<K, V>(previous, version);
                previous.increaseReferenceCounter();
            } else {
                newEdge = new SharedBufferEdge(null, version);
            }
            sharedBufferEntry.addEdge(newEdge);
        }

        public SharedBufferEntry<K, V> get(ValueTimeWrapper<V> valueTime) {
            return this.entries.get(valueTime);
        }

        public void prune(long pruningTimestamp) {
            Iterator<Map.Entry<ValueTimeWrapper<V>, SharedBufferEntry<K, V>>> iterator = this.entries.entrySet().iterator();
            boolean continuePruning = true;
            while (iterator.hasNext() && continuePruning) {
                SharedBufferEntry<K, V> entry = iterator.next().getValue();
                if (entry.getValueTime().getTimestamp() <= pruningTimestamp) {
                    iterator.remove();
                    continue;
                }
                continuePruning = false;
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public SharedBufferEntry<K, V> remove(ValueTimeWrapper<V> valueTime) {
            return this.entries.remove(valueTime);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SharedBufferPage(\n");
            for (SharedBufferEntry<K, V> entry : this.entries.values()) {
                builder.append(entry.toString()).append("\n");
            }
            builder.append(")");
            return builder.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SharedBufferPage) {
                SharedBufferPage other = (SharedBufferPage)obj;
                return this.key.equals(other.key) && this.entries.equals(other.entries);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.entries);
        }
    }
}

