/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.cep.nfa.StateTransition;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;

public class State<T>
implements Serializable {
    private static final long serialVersionUID = 6658700025989097781L;
    private final String name;
    private StateType stateType;
    private final Collection<StateTransition<T>> stateTransitions;

    public State(String name, StateType stateType) {
        this.name = name;
        this.stateType = stateType;
        this.stateTransitions = new ArrayList<StateTransition<T>>();
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public boolean isFinal() {
        return this.stateType == StateType.Final;
    }

    public boolean isStart() {
        return this.stateType == StateType.Start;
    }

    public String getName() {
        return this.name;
    }

    public Collection<StateTransition<T>> getStateTransitions() {
        return this.stateTransitions;
    }

    public void makeStart() {
        this.stateType = StateType.Start;
    }

    public void addStateTransition(StateTransitionAction action, State<T> targetState, IterativeCondition<T> condition) {
        this.stateTransitions.add(new StateTransition<T>(this, action, targetState, condition));
    }

    public void addIgnore(IterativeCondition<T> condition) {
        this.addStateTransition(StateTransitionAction.IGNORE, this, condition);
    }

    public void addIgnore(State<T> targetState, IterativeCondition<T> condition) {
        this.addStateTransition(StateTransitionAction.IGNORE, targetState, condition);
    }

    public void addTake(State<T> targetState, IterativeCondition<T> condition) {
        this.addStateTransition(StateTransitionAction.TAKE, targetState, condition);
    }

    public void addProceed(State<T> targetState, IterativeCondition<T> condition) {
        this.addStateTransition(StateTransitionAction.PROCEED, targetState, condition);
    }

    public void addTake(IterativeCondition<T> condition) {
        this.addStateTransition(StateTransitionAction.TAKE, this, condition);
    }

    public boolean equals(Object obj) {
        if (obj instanceof State) {
            State other = (State)obj;
            return this.name.equals(other.name) && this.stateType == other.stateType && this.stateTransitions.equals(other.stateTransitions);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.stateType).append(" State ").append(this.name).append(" [\n");
        for (StateTransition<T> stateTransition : this.stateTransitions) {
            builder.append("\t").append(stateTransition).append(",\n");
        }
        builder.append("])");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.stateType, this.stateTransitions});
    }

    public boolean isStop() {
        return this.stateType == StateType.Stop;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (!this.stateTransitions.isEmpty() && this.stateTransitions.iterator().next().getSourceState() == null) {
            ArrayList<StateTransition<T>> tmp = new ArrayList<StateTransition<T>>();
            tmp.addAll(this.stateTransitions);
            this.stateTransitions.clear();
            for (StateTransition stateTransition : tmp) {
                this.addStateTransition(stateTransition.getAction(), stateTransition.getTargetState(), stateTransition.getCondition());
            }
        }
    }

    public static enum StateType {
        Start,
        Final,
        Normal,
        Stop;

    }
}

