/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;

public class StateTransition<T>
implements Serializable {
    private static final long serialVersionUID = -4825345749997891838L;
    private final StateTransitionAction action;
    private final State<T> sourceState;
    private final State<T> targetState;
    private IterativeCondition<T> newCondition;
    @Deprecated
    private FilterFunction<T> condition;

    public StateTransition(State<T> sourceState, StateTransitionAction action, State<T> targetState, IterativeCondition<T> condition) {
        this.action = action;
        this.targetState = targetState;
        this.sourceState = sourceState;
        this.newCondition = condition;
    }

    public StateTransitionAction getAction() {
        return this.action;
    }

    public State<T> getTargetState() {
        return this.targetState;
    }

    public State<T> getSourceState() {
        return this.sourceState;
    }

    public IterativeCondition<T> getCondition() {
        if (this.condition != null) {
            this.newCondition = new FilterWrapper<T>(this.condition);
            this.condition = null;
        }
        return this.newCondition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StateTransition) {
            StateTransition other = (StateTransition)obj;
            return this.action == other.action && this.sourceState.getName().equals(other.sourceState.getName()) && this.targetState.getName().equals(other.targetState.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.targetState.getName(), this.sourceState.getName()});
    }

    public String toString() {
        return "StateTransition(" + (Object)((Object)this.action) + ", " + "from " + this.sourceState.getName() + "to " + this.targetState.getName() + (this.newCondition != null ? ", with condition)" : ")");
    }

    private static class FilterWrapper<T>
    extends SimpleCondition<T> {
        private static final long serialVersionUID = -4973016745698940430L;
        private final FilterFunction<T> filterFunction;

        FilterWrapper(FilterFunction<T> filterFunction) {
            this.filterFunction = filterFunction;
        }

        public boolean filter(T value) throws Exception {
            return this.filterFunction.filter(value);
        }
    }
}

