/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransition;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.nfa.compiler.NFAStateNameHandler;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.cep.pattern.conditions.BooleanConditions;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.NotCondition;
import org.apache.flink.shaded.com.google.common.base.Predicate;
import org.apache.flink.shaded.com.google.common.collect.Iterators;
import org.apache.flink.streaming.api.windowing.time.Time;

public class NFACompiler {
    protected static final String ENDING_STATE_NAME = "$endState$";

    public static <T> NFA<T> compile(Pattern<T, ?> pattern, TypeSerializer<T> inputTypeSerializer, boolean timeoutHandling) {
        NFAFactory<T> factory = NFACompiler.compileFactory(pattern, inputTypeSerializer, timeoutHandling);
        return factory.createNFA();
    }

    public static <T> NFAFactory<T> compileFactory(Pattern<T, ?> pattern, TypeSerializer<T> inputTypeSerializer, boolean timeoutHandling) {
        if (pattern == null) {
            return new NFAFactoryImpl(inputTypeSerializer, 0L, Collections.emptyList(), timeoutHandling);
        }
        NFAFactoryCompiler<T> nfaFactoryCompiler = new NFAFactoryCompiler<T>(pattern);
        nfaFactoryCompiler.compileFactory();
        return new NFAFactoryImpl(inputTypeSerializer, nfaFactoryCompiler.getWindowTime(), nfaFactoryCompiler.getStates(), timeoutHandling);
    }

    @Internal
    public static <T> Map<String, State<T>> migrateGraph(State<T> oldStartState) {
        State<T> oldFirst = oldStartState;
        State<T> oldSecond = oldStartState.getStateTransitions().iterator().next().getTargetState();
        StateTransition<T> oldFirstToSecondTake = Iterators.find(oldFirst.getStateTransitions().iterator(), new Predicate<StateTransition<T>>(){

            @Override
            public boolean apply(@Nullable StateTransition<T> input) {
                return input != null && input.getAction() == StateTransitionAction.TAKE;
            }
        });
        StateTransition oldFirstIgnore = Iterators.find(oldFirst.getStateTransitions().iterator(), new Predicate<StateTransition<T>>(){

            @Override
            public boolean apply(@Nullable StateTransition<T> input) {
                return input != null && input.getAction() == StateTransitionAction.IGNORE;
            }
        }, null);
        StateTransition oldSecondToThirdTake = Iterators.find(oldSecond.getStateTransitions().iterator(), new Predicate<StateTransition<T>>(){

            @Override
            public boolean apply(@Nullable StateTransition<T> input) {
                return input != null && input.getAction() == StateTransitionAction.TAKE;
            }
        }, null);
        HashMap<String, State<T>> convertedStates = new HashMap<String, State<T>>();
        State newFirst = new State(oldSecond.getName(), State.StateType.Start);
        convertedStates.put(newFirst.getName(), newFirst);
        while (oldSecondToThirdTake != null) {
            State newSecond = new State(oldSecondToThirdTake.getTargetState().getName(), State.StateType.Normal);
            convertedStates.put(newSecond.getName(), newSecond);
            newFirst.addTake(newSecond, oldFirstToSecondTake.getCondition());
            if (oldFirstIgnore != null) {
                newFirst.addIgnore(oldFirstIgnore.getCondition());
            }
            oldFirst = oldSecond;
            oldFirstToSecondTake = Iterators.find(oldFirst.getStateTransitions().iterator(), new Predicate<StateTransition<T>>(){

                @Override
                public boolean apply(@Nullable StateTransition<T> input) {
                    return input != null && input.getAction() == StateTransitionAction.TAKE;
                }
            });
            oldFirstIgnore = Iterators.find(oldFirst.getStateTransitions().iterator(), new Predicate<StateTransition<T>>(){

                @Override
                public boolean apply(@Nullable StateTransition<T> input) {
                    return input != null && input.getAction() == StateTransitionAction.IGNORE;
                }
            }, null);
            oldSecond = oldSecondToThirdTake.getTargetState();
            oldSecondToThirdTake = Iterators.find(oldSecond.getStateTransitions().iterator(), new Predicate<StateTransition<T>>(){

                @Override
                public boolean apply(@Nullable StateTransition<T> input) {
                    return input != null && input.getAction() == StateTransitionAction.TAKE;
                }
            }, null);
            newFirst = newSecond;
        }
        State endingState = new State(ENDING_STATE_NAME, State.StateType.Final);
        newFirst.addTake(endingState, oldFirstToSecondTake.getCondition());
        if (oldFirstIgnore != null) {
            newFirst.addIgnore(oldFirstIgnore.getCondition());
        }
        convertedStates.put(endingState.getName(), endingState);
        return convertedStates;
    }

    private static class NFAFactoryImpl<T>
    implements NFAFactory<T> {
        private static final long serialVersionUID = 8939783698296714379L;
        private final TypeSerializer<T> inputTypeSerializer;
        private final long windowTime;
        private final Collection<State<T>> states;
        private final boolean timeoutHandling;

        private NFAFactoryImpl(TypeSerializer<T> inputTypeSerializer, long windowTime, Collection<State<T>> states, boolean timeoutHandling) {
            this.inputTypeSerializer = inputTypeSerializer;
            this.windowTime = windowTime;
            this.states = states;
            this.timeoutHandling = timeoutHandling;
        }

        @Override
        public NFA<T> createNFA() {
            NFA<T> result = new NFA<T>(this.inputTypeSerializer.duplicate(), this.windowTime, this.timeoutHandling);
            result.addStates(this.states);
            return result;
        }
    }

    public static interface NFAFactory<T>
    extends Serializable {
        public NFA<T> createNFA();
    }

    static class NFAFactoryCompiler<T> {
        private final NFAStateNameHandler stateNameHandler = new NFAStateNameHandler();
        private final Map<String, State<T>> stopStates = new HashMap<String, State<T>>();
        private final List<State<T>> states = new ArrayList<State<T>>();
        private long windowTime = 0L;
        private Pattern<T, ?> currentPattern;
        private Pattern<T, ?> followingPattern;

        NFAFactoryCompiler(Pattern<T, ?> pattern) {
            this.currentPattern = pattern;
        }

        void compileFactory() {
            if (this.currentPattern.getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW) {
                throw new MalformedPatternException("NotFollowedBy is not supported as a last part of a Pattern!");
            }
            State<T> sinkState = this.createEndingState();
            sinkState = this.createMiddleStates(sinkState);
            this.createStartState(sinkState);
        }

        List<State<T>> getStates() {
            return this.states;
        }

        long getWindowTime() {
            return this.windowTime;
        }

        private List<Tuple2<IterativeCondition<T>, String>> getCurrentNotCondition() {
            ArrayList<Tuple2<IterativeCondition<T>, String>> notConditions = new ArrayList<Tuple2<IterativeCondition<T>, String>>();
            Pattern<T, Object> previousPattern = this.currentPattern;
            while (previousPattern.getPrevious() != null && (previousPattern.getPrevious().getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL) || previousPattern.getPrevious().getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW)) {
                if ((previousPattern = previousPattern.getPrevious()).getQuantifier().getConsumingStrategy() != Quantifier.ConsumingStrategy.NOT_FOLLOW) continue;
                IterativeCondition<Object> notCondition = previousPattern.getCondition();
                notConditions.add(Tuple2.of(notCondition, (Object)previousPattern.getName()));
            }
            return notConditions;
        }

        private State<T> createEndingState() {
            State<T> endState = this.createState(NFACompiler.ENDING_STATE_NAME, State.StateType.Final);
            this.windowTime = this.currentPattern.getWindowTime() != null ? this.currentPattern.getWindowTime().toMilliseconds() : 0L;
            return endState;
        }

        private State<T> createMiddleStates(State<T> sinkState) {
            State<T> lastSink = sinkState;
            while (this.currentPattern.getPrevious() != null) {
                if (this.currentPattern.getQuantifier().getConsumingStrategy() != Quantifier.ConsumingStrategy.NOT_FOLLOW) {
                    if (this.currentPattern.getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_NEXT) {
                        this.stateNameHandler.checkNameUniqueness(this.currentPattern.getName());
                        State<Object> notNext = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                        IterativeCondition<?> notCondition = this.currentPattern.getCondition();
                        State<?> stopState = this.createStopState(notCondition, this.currentPattern.getName());
                        if (lastSink.isFinal()) {
                            notNext.addIgnore(lastSink, new NotCondition(notCondition));
                        } else {
                            notNext.addProceed(lastSink, new NotCondition(notCondition));
                        }
                        notNext.addProceed(stopState, notCondition);
                        lastSink = notNext;
                    } else {
                        this.stateNameHandler.checkNameUniqueness(this.currentPattern.getName());
                        lastSink = this.convertPattern(lastSink);
                    }
                }
                this.followingPattern = this.currentPattern;
                this.currentPattern = this.currentPattern.getPrevious();
                Time currentWindowTime = this.currentPattern.getWindowTime();
                if (currentWindowTime == null || currentWindowTime.toMilliseconds() >= this.windowTime) continue;
                this.windowTime = currentWindowTime.toMilliseconds();
            }
            return lastSink;
        }

        private State<T> createStartState(State<T> sinkState) {
            this.stateNameHandler.checkNameUniqueness(this.currentPattern.getName());
            State<T> beginningState = this.convertPattern(sinkState);
            beginningState.makeStart();
            return beginningState;
        }

        private State<T> convertPattern(State<T> sinkState) {
            State<T> lastSink;
            Quantifier quantifier = this.currentPattern.getQuantifier();
            if (quantifier.hasProperty(Quantifier.QuantifierProperty.LOOPING)) {
                State<T> sink = this.copyWithoutTransitiveNots(sinkState);
                State<T> looping = this.createLooping(sink);
                lastSink = !quantifier.hasProperty(Quantifier.QuantifierProperty.OPTIONAL) ? this.createInitMandatoryStateOfOneOrMore(looping) : this.createInitOptionalStateOfZeroOrMore(looping, sinkState);
            } else {
                lastSink = quantifier.hasProperty(Quantifier.QuantifierProperty.TIMES) ? this.createTimesState(sinkState, this.currentPattern.getTimes()) : this.createSingletonState(sinkState);
            }
            this.addStopStates(lastSink);
            return lastSink;
        }

        private State<T> createState(String name, State.StateType stateType) {
            String stateName = this.stateNameHandler.getUniqueInternalName(name);
            State state = new State(stateName, stateType);
            this.states.add(state);
            return state;
        }

        private State<T> createStopState(IterativeCondition<T> notCondition, String name) {
            State<T> stopState = this.stopStates.get(name);
            if (stopState == null) {
                stopState = this.createState(name, State.StateType.Stop);
                stopState.addTake(notCondition);
                this.stopStates.put(name, stopState);
            }
            return stopState;
        }

        private State<T> copyWithoutTransitiveNots(State<T> sinkState) {
            List<Tuple2<IterativeCondition<T>, String>> currentNotCondition = this.getCurrentNotCondition();
            if (currentNotCondition.isEmpty() || !this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL)) {
                return sinkState;
            }
            State<T> copyOfSink = this.createState(sinkState.getName(), sinkState.getStateType());
            for (StateTransition<T> tStateTransition : sinkState.getStateTransitions()) {
                if (tStateTransition.getAction() == StateTransitionAction.PROCEED) {
                    State<T> targetState = tStateTransition.getTargetState();
                    boolean remove = false;
                    if (targetState.isStop()) {
                        for (Tuple2<IterativeCondition<T>, String> notCondition : currentNotCondition) {
                            if (!targetState.getName().equals(notCondition.f1)) continue;
                            remove = true;
                        }
                    } else {
                        targetState = this.copyWithoutTransitiveNots(tStateTransition.getTargetState());
                    }
                    if (remove) continue;
                    copyOfSink.addStateTransition(tStateTransition.getAction(), targetState, tStateTransition.getCondition());
                    continue;
                }
                copyOfSink.addStateTransition(tStateTransition.getAction(), tStateTransition.getTargetState().equals(tStateTransition.getSourceState()) ? copyOfSink : tStateTransition.getTargetState(), tStateTransition.getCondition());
            }
            return copyOfSink;
        }

        private void addStopStates(State<T> state) {
            for (Tuple2<IterativeCondition<T>, String> notCondition : this.getCurrentNotCondition()) {
                State<T> stopState = this.createStopState((IterativeCondition)notCondition.f0, (String)notCondition.f1);
                state.addProceed(stopState, (IterativeCondition)notCondition.f0);
            }
        }

        private void addStopStateToLooping(State<T> loopingState) {
            if (this.followingPattern != null && this.followingPattern.getQuantifier().getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW) {
                IterativeCondition<?> notCondition = this.followingPattern.getCondition();
                State<?> stopState = this.createStopState(notCondition, this.followingPattern.getName());
                loopingState.addProceed(stopState, notCondition);
            }
        }

        private State<T> createTimesState(State<T> sinkState, int times) {
            State<T> lastSink = this.copyWithoutTransitiveNots(sinkState);
            for (int i = 0; i < times - 1; ++i) {
                lastSink = this.createSingletonState(lastSink, this.getInnerIgnoreCondition(this.currentPattern), false);
                this.addStopStateToLooping(lastSink);
            }
            IterativeCondition<?> currentCondition = this.currentPattern.getCondition();
            IterativeCondition<T> ignoreCondition = this.getIgnoreCondition(this.currentPattern);
            if (!this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL)) {
                return this.createSingletonState(lastSink, ignoreCondition, false);
            }
            State<T> singletonState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            singletonState.addTake(lastSink, currentCondition);
            singletonState.addProceed(sinkState, BooleanConditions.trueFunction());
            if (ignoreCondition != null) {
                State<T> ignoreState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                ignoreState.addTake(lastSink, currentCondition);
                ignoreState.addIgnore(ignoreCondition);
                singletonState.addIgnore(ignoreState, ignoreCondition);
                this.addStopStates(ignoreState);
            }
            return singletonState;
        }

        private State<T> createSingletonState(State<T> sinkState) {
            return this.createSingletonState(sinkState, this.getIgnoreCondition(this.currentPattern), this.currentPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.OPTIONAL));
        }

        private State<T> createSingletonState(State<T> sinkState, IterativeCondition<T> ignoreCondition, boolean isOptional) {
            IterativeCondition<?> currentCondition = this.currentPattern.getCondition();
            IterativeCondition trueFunction = BooleanConditions.trueFunction();
            State<T> singletonState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            State<T> sink = this.copyWithoutTransitiveNots(sinkState);
            singletonState.addTake(sink, currentCondition);
            if (isOptional) {
                singletonState.addProceed(sinkState, trueFunction);
            }
            if (ignoreCondition != null) {
                State<T> ignoreState;
                if (isOptional) {
                    ignoreState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                    ignoreState.addTake(sink, currentCondition);
                    ignoreState.addIgnore(ignoreCondition);
                    this.addStopStates(ignoreState);
                } else {
                    ignoreState = singletonState;
                }
                singletonState.addIgnore(ignoreState, ignoreCondition);
            }
            return singletonState;
        }

        private State<T> createLooping(State<T> sinkState) {
            IterativeCondition<?> currentCondition = this.currentPattern.getCondition();
            IterativeCondition<T> ignoreCondition = this.getInnerIgnoreCondition(this.currentPattern);
            IterativeCondition trueFunction = BooleanConditions.trueFunction();
            State<Object> loopingState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            loopingState.addProceed(sinkState, trueFunction);
            loopingState.addTake(currentCondition);
            this.addStopStateToLooping(loopingState);
            if (ignoreCondition != null) {
                State<Object> ignoreState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                ignoreState.addTake(loopingState, currentCondition);
                ignoreState.addIgnore(ignoreCondition);
                loopingState.addIgnore(ignoreState, ignoreCondition);
                this.addStopStateToLooping(ignoreState);
            }
            return loopingState;
        }

        private State<T> createInitMandatoryStateOfOneOrMore(State<T> sinkState) {
            IterativeCondition<?> currentCondition = this.currentPattern.getCondition();
            State<T> firstState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            firstState.addTake(sinkState, currentCondition);
            IterativeCondition<T> ignoreCondition = this.getIgnoreCondition(this.currentPattern);
            if (ignoreCondition != null) {
                firstState.addIgnore(ignoreCondition);
            }
            return firstState;
        }

        private State<T> createInitOptionalStateOfZeroOrMore(State<T> loopingState, State<T> lastSink) {
            IterativeCondition<?> currentCondition = this.currentPattern.getCondition();
            State<T> firstState = this.createState(this.currentPattern.getName(), State.StateType.Normal);
            firstState.addProceed(lastSink, BooleanConditions.trueFunction());
            firstState.addTake(loopingState, currentCondition);
            IterativeCondition<T> ignoreFunction = this.getIgnoreCondition(this.currentPattern);
            if (ignoreFunction != null) {
                State<T> firstStateWithoutProceed = this.createState(this.currentPattern.getName(), State.StateType.Normal);
                firstState.addIgnore(firstStateWithoutProceed, ignoreFunction);
                firstStateWithoutProceed.addIgnore(ignoreFunction);
                firstStateWithoutProceed.addTake(loopingState, currentCondition);
                this.addStopStates(firstStateWithoutProceed);
            }
            return firstState;
        }

        private IterativeCondition<T> getInnerIgnoreCondition(Pattern<T, ?> pattern) {
            switch (pattern.getQuantifier().getInnerConsumingStrategy()) {
                case STRICT: {
                    return null;
                }
                case SKIP_TILL_NEXT: {
                    return new NotCondition(pattern.getCondition());
                }
                case SKIP_TILL_ANY: {
                    return BooleanConditions.trueFunction();
                }
            }
            return null;
        }

        private IterativeCondition<T> getIgnoreCondition(Pattern<T, ?> pattern) {
            switch (pattern.getQuantifier().getConsumingStrategy()) {
                case STRICT: {
                    return null;
                }
                case SKIP_TILL_NEXT: {
                    return new NotCondition(pattern.getCondition());
                }
                case SKIP_TILL_ANY: {
                    return BooleanConditions.trueFunction();
                }
            }
            return null;
        }
    }
}

