/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.compiler;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.util.Preconditions;

public class NFAStateNameHandler {
    private static final String STATE_NAME_DELIM = ":";
    private final Set<String> usedNames = new HashSet<String>();

    public static String getOriginalNameFromInternal(String internalName) {
        Preconditions.checkNotNull((Object)internalName);
        return internalName.split(STATE_NAME_DELIM)[0];
    }

    public void checkNameUniqueness(String name) {
        if (this.usedNames.contains(name)) {
            throw new MalformedPatternException("Duplicate pattern name: " + name + ". Names must be unique.");
        }
    }

    public String getUniqueInternalName(String baseName) {
        int counter = 0;
        String candidate = baseName;
        while (this.usedNames.contains(candidate)) {
            candidate = baseName + STATE_NAME_DELIM + counter++;
        }
        this.usedNames.add(candidate);
        return candidate;
    }
}

