/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.KeyedCEPPatternOperator;
import org.apache.flink.cep.operator.TimeoutKeyedCEPPatternOperator;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.types.Either;

public class CEPOperatorUtils {
    public static <K, T> SingleOutputStreamOperator<Map<String, List<T>>> createPatternStream(DataStream<T> inputStream, Pattern<T, ?> pattern) {
        SingleOutputStreamOperator patternStream;
        TypeSerializer inputSerializer = inputStream.getType().createSerializer(inputStream.getExecutionConfig());
        boolean isProcessingTime = inputStream.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        NFACompiler.NFAFactory<T> nfaFactory = NFACompiler.compileFactory(pattern, inputSerializer, false);
        if (inputStream instanceof KeyedStream) {
            KeyedStream keyedStream = (KeyedStream)inputStream;
            TypeSerializer keySerializer = keyedStream.getKeyType().createSerializer(keyedStream.getExecutionConfig());
            patternStream = keyedStream.transform("KeyedCEPPatternOperator", TypeExtractor.getForClass(Map.class), new KeyedCEPPatternOperator(inputSerializer, isProcessingTime, keySerializer, nfaFactory, true));
        } else {
            NullByteKeySelector keySelector = new NullByteKeySelector();
            ByteSerializer keySerializer = ByteSerializer.INSTANCE;
            patternStream = inputStream.keyBy((KeySelector)keySelector).transform("CEPPatternOperator", TypeExtractor.getForClass(Map.class), new KeyedCEPPatternOperator(inputSerializer, isProcessingTime, keySerializer, nfaFactory, false)).forceNonParallel();
        }
        return patternStream;
    }

    public static <K, T> SingleOutputStreamOperator<Either<Tuple2<Map<String, List<T>>, Long>, Map<String, List<T>>>> createTimeoutPatternStream(DataStream<T> inputStream, Pattern<T, ?> pattern) {
        SingleOutputStreamOperator patternStream;
        TypeSerializer inputSerializer = inputStream.getType().createSerializer(inputStream.getExecutionConfig());
        boolean isProcessingTime = inputStream.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        NFACompiler.NFAFactory<T> nfaFactory = NFACompiler.compileFactory(pattern, inputSerializer, true);
        TypeInformation rightTypeInfo = TypeExtractor.getForClass(Map.class);
        TupleTypeInfo leftTypeInfo = new TupleTypeInfo(new TypeInformation[]{rightTypeInfo, BasicTypeInfo.LONG_TYPE_INFO});
        EitherTypeInfo eitherTypeInformation = new EitherTypeInfo((TypeInformation)leftTypeInfo, rightTypeInfo);
        if (inputStream instanceof KeyedStream) {
            KeyedStream keyedStream = (KeyedStream)inputStream;
            TypeSerializer keySerializer = keyedStream.getKeyType().createSerializer(keyedStream.getExecutionConfig());
            patternStream = keyedStream.transform("TimeoutKeyedCEPPatternOperator", (TypeInformation)eitherTypeInformation, new TimeoutKeyedCEPPatternOperator(inputSerializer, isProcessingTime, keySerializer, nfaFactory, true));
        } else {
            NullByteKeySelector keySelector = new NullByteKeySelector();
            ByteSerializer keySerializer = ByteSerializer.INSTANCE;
            patternStream = inputStream.keyBy((KeySelector)keySelector).transform("TimeoutCEPPatternOperator", (TypeInformation)eitherTypeInformation, new TimeoutKeyedCEPPatternOperator(inputSerializer, isProcessingTime, keySerializer, nfaFactory, false)).forceNonParallel();
        }
        return patternStream;
    }
}

