/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.AbstractKeyedCEPPatternOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class KeyedCEPPatternOperator<IN, KEY>
extends AbstractKeyedCEPPatternOperator<IN, KEY, Map<String, List<IN>>> {
    private static final long serialVersionUID = 5328573789532074581L;

    public KeyedCEPPatternOperator(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, TypeSerializer<KEY> keySerializer, NFACompiler.NFAFactory<IN> nfaFactory, boolean migratingFromOldKeyedOperator) {
        super(inputSerializer, isProcessingTime, keySerializer, nfaFactory, migratingFromOldKeyedOperator);
    }

    @Override
    protected void processEvent(NFA<IN> nfa, IN event, long timestamp) {
        Tuple2<Collection<Map<String, List<IN>>>, Collection<Tuple2<Map<String, List<IN>>, Long>>> patterns = nfa.process(event, timestamp);
        this.emitMatchedSequences((Iterable)patterns.f0, timestamp);
    }

    @Override
    protected void advanceTime(NFA<IN> nfa, long timestamp) {
        Tuple2<Collection<Map<String, List<Object>>>, Collection<Tuple2<Map<String, List<Object>>, Long>>> patterns = nfa.process(null, timestamp);
        this.emitMatchedSequences((Iterable)patterns.f0, timestamp);
    }

    private void emitMatchedSequences(Iterable<Map<String, List<IN>>> matchedSequences, long timestamp) {
        Iterator<Map<String, List<IN>>> iterator = matchedSequences.iterator();
        if (iterator.hasNext()) {
            StreamRecord streamRecord = new StreamRecord(null, timestamp);
            do {
                streamRecord.replace(iterator.next());
                this.output.collect((Object)streamRecord);
            } while (iterator.hasNext());
        }
    }
}

