/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.AbstractKeyedCEPPatternOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.types.Either;

public class TimeoutKeyedCEPPatternOperator<IN, KEY>
extends AbstractKeyedCEPPatternOperator<IN, KEY, Either<Tuple2<Map<String, List<IN>>, Long>, Map<String, List<IN>>>> {
    private static final long serialVersionUID = 3570542177814518158L;

    public TimeoutKeyedCEPPatternOperator(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, TypeSerializer<KEY> keySerializer, NFACompiler.NFAFactory<IN> nfaFactory, boolean migratingFromOldKeyedOperator) {
        super(inputSerializer, isProcessingTime, keySerializer, nfaFactory, migratingFromOldKeyedOperator);
    }

    @Override
    protected void processEvent(NFA<IN> nfa, IN event, long timestamp) {
        Tuple2<Collection<Map<String, List<IN>>>, Collection<Tuple2<Map<String, List<IN>>, Long>>> patterns = nfa.process(event, timestamp);
        this.emitMatchedSequences((Iterable)patterns.f0, timestamp);
        this.emitTimedOutSequences((Iterable)patterns.f1, timestamp);
    }

    @Override
    protected void advanceTime(NFA<IN> nfa, long timestamp) {
        Tuple2<Collection<Map<String, List<Object>>>, Collection<Tuple2<Map<String, List<Object>>, Long>>> patterns = nfa.process(null, timestamp);
        this.emitMatchedSequences((Iterable)patterns.f0, timestamp);
        this.emitTimedOutSequences((Iterable)patterns.f1, timestamp);
    }

    private void emitTimedOutSequences(Iterable<Tuple2<Map<String, List<IN>>, Long>> timedOutSequences, long timestamp) {
        StreamRecord streamRecord = new StreamRecord(null, timestamp);
        for (Tuple2<Map<String, List<IN>>, Long> partialPattern : timedOutSequences) {
            streamRecord.replace((Object)Either.Left(partialPattern));
            this.output.collect((Object)streamRecord);
        }
    }

    protected void emitMatchedSequences(Iterable<Map<String, List<IN>>> matchedSequences, long timestamp) {
        StreamRecord streamRecord = new StreamRecord(null, timestamp);
        for (Map<String, List<IN>> matchedPattern : matchedSequences) {
            streamRecord.replace((Object)Either.Right(matchedPattern));
            this.output.collect((Object)streamRecord);
        }
    }
}

