/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.pattern;

import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.cep.pattern.conditions.AndCondition;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.OrCondition;
import org.apache.flink.cep.pattern.conditions.SubtypeCondition;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.util.Preconditions;

public class Pattern<T, F extends T> {
    private final String name;
    private final Pattern<T, ? extends T> previous;
    private IterativeCondition<F> condition;
    private Time windowTime;
    private Quantifier quantifier = Quantifier.ONE(Quantifier.ConsumingStrategy.STRICT);
    private int times;

    protected Pattern(String name, Pattern<T, ? extends T> previous) {
        this.name = name;
        this.previous = previous;
    }

    protected Pattern(String name, Pattern<T, ? extends T> previous, Quantifier.ConsumingStrategy consumingStrategy) {
        this.name = name;
        this.previous = previous;
        this.quantifier = Quantifier.ONE(consumingStrategy);
    }

    public Pattern<T, ? extends T> getPrevious() {
        return this.previous;
    }

    public int getTimes() {
        return this.times;
    }

    public String getName() {
        return this.name;
    }

    public Time getWindowTime() {
        return this.windowTime;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public IterativeCondition<F> getCondition() {
        return this.condition;
    }

    public static <X> Pattern<X, X> begin(String name) {
        return new Pattern(name, null);
    }

    public Pattern<T, F> where(IterativeCondition<F> condition) {
        Preconditions.checkNotNull(condition, (String)"The condition cannot be null.");
        ClosureCleaner.clean(condition, (boolean)true);
        this.condition = this.condition == null ? condition : new AndCondition<F>(this.condition, condition);
        return this;
    }

    public Pattern<T, F> or(IterativeCondition<F> condition) {
        Preconditions.checkNotNull(condition, (String)"The condition cannot be null.");
        ClosureCleaner.clean(condition, (boolean)true);
        this.condition = this.condition == null ? condition : new OrCondition<F>(this.condition, condition);
        return this;
    }

    public <S extends F> Pattern<T, S> subtype(Class<S> subtypeClass) {
        Preconditions.checkNotNull(subtypeClass, (String)"The class cannot be null.");
        this.condition = this.condition == null ? new SubtypeCondition<S>(subtypeClass) : new AndCondition<F>(this.condition, new SubtypeCondition<S>(subtypeClass));
        Pattern result = this;
        return result;
    }

    public Pattern<T, F> within(Time windowTime) {
        if (windowTime != null) {
            this.windowTime = windowTime;
        }
        return this;
    }

    public Pattern<T, T> next(String name) {
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.STRICT);
    }

    public Pattern<T, T> notNext(String name) {
        if (this.quantifier.hasProperty(Quantifier.QuantifierProperty.OPTIONAL)) {
            throw new UnsupportedOperationException("Specifying a pattern with an optional path to NOT condition is not supported yet. You can simulate such pattern with two independent patterns, one with and the other without the optional part.");
        }
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.NOT_NEXT);
    }

    public Pattern<T, T> followedBy(String name) {
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.SKIP_TILL_NEXT);
    }

    public Pattern<T, T> notFollowedBy(String name) {
        if (this.quantifier.hasProperty(Quantifier.QuantifierProperty.OPTIONAL)) {
            throw new UnsupportedOperationException("Specifying a pattern with an optional path to NOT condition is not supported yet. You can simulate such pattern with two independent patterns, one with and the other without the optional part.");
        }
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.NOT_FOLLOW);
    }

    public Pattern<T, T> followedByAny(String name) {
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.SKIP_TILL_ANY);
    }

    public Pattern<T, F> optional() {
        this.quantifier.optional();
        return this;
    }

    public Pattern<T, F> oneOrMore() {
        this.checkIfNoNotPattern();
        this.checkIfQuantifierApplied();
        this.quantifier = Quantifier.ONE_OR_MORE(this.quantifier.getConsumingStrategy());
        return this;
    }

    public Pattern<T, F> times(int times) {
        this.checkIfNoNotPattern();
        this.checkIfQuantifierApplied();
        Preconditions.checkArgument((times > 0 ? 1 : 0) != 0, (Object)"You should give a positive number greater than 0.");
        this.quantifier = Quantifier.TIMES(this.quantifier.getConsumingStrategy());
        this.times = times;
        return this;
    }

    public Pattern<T, F> allowCombinations() {
        this.quantifier.combinations();
        return this;
    }

    public Pattern<T, F> consecutive() {
        this.quantifier.consecutive();
        return this;
    }

    private void checkIfNoNotPattern() {
        if (this.quantifier.getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW || this.quantifier.getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_NEXT) {
            throw new MalformedPatternException("Option not applicable to NOT pattern");
        }
    }

    private void checkIfQuantifierApplied() {
        if (!this.quantifier.hasProperty(Quantifier.QuantifierProperty.SINGLE)) {
            throw new MalformedPatternException("Already applied quantifier to this Pattern. Current quantifier is: " + this.quantifier);
        }
    }
}

