/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.pattern;

import java.util.EnumSet;
import java.util.Objects;
import org.apache.flink.cep.pattern.MalformedPatternException;

public class Quantifier {
    private final EnumSet<QuantifierProperty> properties;
    private final ConsumingStrategy consumingStrategy;
    private ConsumingStrategy innerConsumingStrategy = ConsumingStrategy.SKIP_TILL_NEXT;

    private Quantifier(ConsumingStrategy consumingStrategy, QuantifierProperty first, QuantifierProperty ... rest) {
        this.properties = EnumSet.of(first, rest);
        this.consumingStrategy = consumingStrategy;
    }

    public static Quantifier ONE(ConsumingStrategy consumingStrategy) {
        return new Quantifier(consumingStrategy, QuantifierProperty.SINGLE, new QuantifierProperty[0]);
    }

    public static Quantifier ONE_OR_MORE(ConsumingStrategy consumingStrategy) {
        return new Quantifier(consumingStrategy, QuantifierProperty.LOOPING, new QuantifierProperty[0]);
    }

    public static Quantifier TIMES(ConsumingStrategy consumingStrategy) {
        return new Quantifier(consumingStrategy, QuantifierProperty.TIMES, new QuantifierProperty[0]);
    }

    public boolean hasProperty(QuantifierProperty property) {
        return this.properties.contains((Object)property);
    }

    public ConsumingStrategy getConsumingStrategy() {
        return this.consumingStrategy;
    }

    public ConsumingStrategy getInnerConsumingStrategy() {
        return this.innerConsumingStrategy;
    }

    private static void checkPattern(boolean condition, Object errorMessage) {
        if (!condition) {
            throw new MalformedPatternException(String.valueOf(errorMessage));
        }
    }

    public void combinations() {
        Quantifier.checkPattern(!this.hasProperty(QuantifierProperty.SINGLE), "Combinations not applicable to " + this + "!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.STRICT, "You can apply apply either combinations or consecutive, not both!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.SKIP_TILL_ANY, "Combinations already applied!");
        this.innerConsumingStrategy = ConsumingStrategy.SKIP_TILL_ANY;
    }

    public void consecutive() {
        Quantifier.checkPattern(this.hasProperty(QuantifierProperty.LOOPING) || this.hasProperty(QuantifierProperty.TIMES), "Combinations not applicable to " + this + "!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.SKIP_TILL_ANY, "You can apply apply either combinations or consecutive, not both!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.STRICT, "Combinations already applied!");
        this.innerConsumingStrategy = ConsumingStrategy.STRICT;
    }

    public void optional() {
        Quantifier.checkPattern(!this.hasProperty(QuantifierProperty.OPTIONAL), "Optional already applied!");
        Quantifier.checkPattern(this.consumingStrategy != ConsumingStrategy.NOT_NEXT && this.consumingStrategy != ConsumingStrategy.NOT_FOLLOW, "NOT pattern cannot be optional");
        this.properties.add(QuantifierProperty.OPTIONAL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quantifier that = (Quantifier)o;
        return Objects.equals(this.properties, that.properties) && this.consumingStrategy == that.consumingStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.consumingStrategy});
    }

    public static enum ConsumingStrategy {
        STRICT,
        SKIP_TILL_NEXT,
        SKIP_TILL_ANY,
        NOT_FOLLOW,
        NOT_NEXT;

    }

    public static enum QuantifierProperty {
        SINGLE,
        LOOPING,
        TIMES,
        OPTIONAL;

    }
}

