/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers;

import java.io.PrintStream;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.GraphAnalytic;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.drivers.DriverBase;
import org.apache.flink.graph.drivers.parameter.ChoiceParameter;
import org.apache.flink.graph.library.clustering.directed.LocalClusteringCoefficient;
import org.apache.flink.graph.library.clustering.undirected.AverageClusteringCoefficient;
import org.apache.flink.graph.library.clustering.undirected.GlobalClusteringCoefficient;
import org.apache.flink.types.CopyableValue;

public class ClusteringCoefficient<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends DriverBase<K, VV, EV> {
    private static final String DIRECTED = "directed";
    private static final String UNDIRECTED = "undirected";
    private ChoiceParameter order = new ChoiceParameter(this, "order").addChoices("directed", "undirected");
    private GraphAnalytic<K, VV, EV, ? extends PrintableResult> globalClusteringCoefficient;
    private GraphAnalytic<K, VV, EV, ? extends PrintableResult> averageClusteringCoefficient;

    @Override
    public String getShortDescription() {
        return "measure the connectedness of vertex neighborhoods";
    }

    @Override
    public String getLongDescription() {
        return WordUtils.wrap((String)new StrBuilder().appendln("The local clustering coefficient measures the connectedness of each vertex's neighborhood. The global clustering coefficient measures the connected of the graph. The average clustering coefficient is the mean local clustering coefficient. Each score ranges from 0.0 (no edges between vertex neighbors) to 1.0 (neighborhood or graph is a clique).").appendNewLine().append("The algorithm result contains the vertex ID, degree, and number of edges connecting neighbors.").toString(), (int)80);
    }

    @Override
    public DataSet plan(Graph<K, VV, EV> graph) throws Exception {
        int parallelism = ((Long)this.parallelism.getValue()).intValue();
        switch ((String)this.order.getValue()) {
            case "directed": {
                this.globalClusteringCoefficient = graph.run((GraphAnalytic)new org.apache.flink.graph.library.clustering.directed.GlobalClusteringCoefficient().setParallelism(parallelism));
                this.averageClusteringCoefficient = graph.run((GraphAnalytic)new org.apache.flink.graph.library.clustering.directed.AverageClusteringCoefficient().setParallelism(parallelism));
                DataSet directedResult = (DataSet)graph.run((GraphAlgorithm)new LocalClusteringCoefficient().setParallelism(parallelism));
                return directedResult;
            }
            case "undirected": {
                this.globalClusteringCoefficient = graph.run((GraphAnalytic)new GlobalClusteringCoefficient().setParallelism(parallelism));
                this.averageClusteringCoefficient = graph.run((GraphAnalytic)new AverageClusteringCoefficient().setParallelism(parallelism));
                DataSet undirectedResult = (DataSet)graph.run((GraphAlgorithm)new org.apache.flink.graph.library.clustering.undirected.LocalClusteringCoefficient().setParallelism(parallelism));
                return undirectedResult;
            }
        }
        throw new RuntimeException("Unknown order: " + this.order);
    }

    @Override
    public void printAnalytics(PrintStream out) {
        out.println(((PrintableResult)this.globalClusteringCoefficient.getResult()).toPrintableString());
        out.println(((PrintableResult)this.averageClusteringCoefficient.getResult()).toPrintableString());
    }
}

