/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.drivers.DriverBase;
import org.apache.flink.graph.utils.EdgeToTuple2Map;

public class EdgeList<K, VV, EV>
extends DriverBase<K, VV, EV> {
    @Override
    public String getShortDescription() {
        return "the edge list";
    }

    @Override
    public String getLongDescription() {
        return "Pass-through of the graph's edge list.";
    }

    @Override
    public DataSet plan(Graph<K, VV, EV> graph) throws Exception {
        DataSet edges = graph.getEdges();
        if (EdgeList.hasNullValueEdges(edges)) {
            return ((MapOperator)edges.map((MapFunction)new EdgeToTuple2Map()).name("Edge to Tuple2")).setParallelism(((Long)this.parallelism.getValue()).intValue());
        }
        return edges;
    }

    private static <T, ET> boolean hasNullValueEdges(DataSet<Edge<T, ET>> edges) {
        TypeInformation genericTypeInfo = edges.getType();
        TupleTypeInfo tupleTypeInfo = (TupleTypeInfo)genericTypeInfo;
        return tupleTypeInfo.getTypeAt(2).equals((Object)ValueTypeInfo.NULL_VALUE_TYPE_INFO);
    }
}

