/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers;

import java.io.PrintStream;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalytic;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.drivers.DriverBase;
import org.apache.flink.graph.drivers.parameter.ChoiceParameter;
import org.apache.flink.graph.library.metric.directed.EdgeMetrics;
import org.apache.flink.graph.library.metric.directed.VertexMetrics;

public class GraphMetrics<K extends Comparable<K>, VV, EV>
extends DriverBase<K, VV, EV> {
    private static final String DIRECTED = "directed";
    private static final String UNDIRECTED = "undirected";
    private ChoiceParameter order = new ChoiceParameter(this, "order").addChoices("directed", "undirected");
    private GraphAnalytic<K, VV, EV, ? extends PrintableResult> vertexMetrics;
    private GraphAnalytic<K, VV, EV, ? extends PrintableResult> edgeMetrics;

    @Override
    public String getShortDescription() {
        return "compute vertex and edge metrics";
    }

    @Override
    public String getLongDescription() {
        return new StrBuilder().appendln("Computes metrics on a directed or undirected graph.").appendNewLine().appendln("Vertex metrics:").appendln("- number of vertices").appendln("- number of edges").appendln("- number of unidirectional edges (directed only)").appendln("- number of bidirectional edges (directed only)").appendln("- average degree").appendln("- number of triplets").appendln("- maximum degree").appendln("- maximum out degree (directed only)").appendln("- maximum in degree (directed only)").appendln("- maximum number of triplets").appendNewLine().appendln("Edge metrics:").appendln("- number of triangle triplets").appendln("- number of rectangle triplets").appendln("- maximum number of triangle triplets").append("- maximum number of rectangle triplets").toString();
    }

    @Override
    public DataSet plan(Graph<K, VV, EV> graph) throws Exception {
        switch ((String)this.order.getValue()) {
            case "directed": {
                this.vertexMetrics = graph.run((GraphAnalytic)new VertexMetrics().setParallelism(((Long)this.parallelism.getValue()).intValue()));
                this.edgeMetrics = graph.run((GraphAnalytic)new EdgeMetrics().setParallelism(((Long)this.parallelism.getValue()).intValue()));
                break;
            }
            case "undirected": {
                this.vertexMetrics = graph.run((GraphAnalytic)new org.apache.flink.graph.library.metric.undirected.VertexMetrics().setParallelism(((Long)this.parallelism.getValue()).intValue()));
                this.edgeMetrics = graph.run((GraphAnalytic)new org.apache.flink.graph.library.metric.undirected.EdgeMetrics().setParallelism(((Long)this.parallelism.getValue()).intValue()));
            }
        }
        return null;
    }

    @Override
    public void printAnalytics(PrintStream out) {
        out.print("Vertex metrics:\n  ");
        out.println(((PrintableResult)this.vertexMetrics.getResult()).toPrintableString().replace(";", "\n "));
        out.println();
        out.print("Edge metrics:\n  ");
        out.println(((PrintableResult)this.edgeMetrics.getResult()).toPrintableString().replace(";", "\n "));
    }
}

