/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers;

import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.drivers.DriverBase;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;
import org.apache.flink.graph.drivers.parameter.LongParameter;
import org.apache.flink.types.CopyableValue;

public class JaccardIndex<K extends CopyableValue<K>, VV, EV>
extends DriverBase<K, VV, EV> {
    private LongParameter minNumerator = new LongParameter(this, "minimum_numerator").setDefaultValue(0L).setMinimumValue(0L);
    private LongParameter minDenominator = new LongParameter(this, "minimum_denominator").setDefaultValue(1L).setMinimumValue(1L);
    private LongParameter maxNumerator = new LongParameter(this, "maximum_numerator").setDefaultValue(1L).setMinimumValue(0L);
    private LongParameter maxDenominator = new LongParameter(this, "maximum_denominator").setDefaultValue(1L).setMinimumValue(1L);
    private BooleanParameter mirrorResults = new BooleanParameter(this, "mirror_results");

    @Override
    public String getShortDescription() {
        return "similarity score as fraction of common neighbors";
    }

    @Override
    public String getLongDescription() {
        return WordUtils.wrap((String)new StrBuilder().appendln("Jaccard Index measures the similarity between vertex neighborhoods and is computed as the number of shared neighbors divided by the number of distinct neighbors. Scores range from 0.0 (no shared neighbors) to 1.0 (all neighbors are shared).").appendNewLine().append("The result contains two vertex IDs, the number of shared neighbors, and the number of distinct neighbors.").toString(), (int)80);
    }

    @Override
    public DataSet plan(Graph<K, VV, EV> graph) throws Exception {
        return (DataSet)graph.run((GraphAlgorithm)new org.apache.flink.graph.library.similarity.JaccardIndex().setMinimumScore(((Long)this.minNumerator.getValue()).intValue(), ((Long)this.minDenominator.getValue()).intValue()).setMaximumScore(((Long)this.maxNumerator.getValue()).intValue(), ((Long)this.maxDenominator.getValue()).intValue()).setMirrorResults(((Boolean)this.mirrorResults.getValue()).booleanValue()).setParallelism(((Long)this.parallelism.getValue()).intValue()));
    }
}

