/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers;

import java.io.PrintStream;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.GraphAnalytic;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.drivers.DriverBase;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;
import org.apache.flink.graph.drivers.parameter.ChoiceParameter;
import org.apache.flink.graph.library.clustering.undirected.TriadicCensus;
import org.apache.flink.types.CopyableValue;

public class TriangleListing<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends DriverBase<K, VV, EV> {
    private static final String DIRECTED = "directed";
    private static final String UNDIRECTED = "undirected";
    private ChoiceParameter order = new ChoiceParameter(this, "order").addChoices("directed", "undirected");
    private BooleanParameter sortTriangleVertices = new BooleanParameter(this, "sort_triangle_vertices");
    private BooleanParameter computeTriadicCensus = new BooleanParameter(this, "triadic_census");
    private BooleanParameter permuteResults = new BooleanParameter(this, "permute_results");
    private GraphAnalytic<K, VV, EV, ? extends PrintableResult> triadicCensus;

    @Override
    public String getShortDescription() {
        return "list triangles";
    }

    @Override
    public String getLongDescription() {
        return WordUtils.wrap((String)new StrBuilder().appendln("List all triangles graph.").appendNewLine().append("The algorithm result contains three vertex IDs. For the directed algorithm the result contains an additional bitmask indicating the presence of the six potential connecting edges.").toString(), (int)80);
    }

    @Override
    public DataSet plan(Graph<K, VV, EV> graph) throws Exception {
        int parallelism = ((Long)this.parallelism.getValue()).intValue();
        switch ((String)this.order.getValue()) {
            case "directed": {
                if (((Boolean)this.computeTriadicCensus.getValue()).booleanValue()) {
                    this.triadicCensus = graph.run((GraphAnalytic)new org.apache.flink.graph.library.clustering.directed.TriadicCensus().setParallelism(parallelism));
                }
                DataSet directedResult = (DataSet)graph.run((GraphAlgorithm)new org.apache.flink.graph.library.clustering.directed.TriangleListing().setPermuteResults(((Boolean)this.permuteResults.getValue()).booleanValue()).setSortTriangleVertices(((Boolean)this.sortTriangleVertices.getValue()).booleanValue()).setParallelism(parallelism));
                return directedResult;
            }
            case "undirected": {
                if (((Boolean)this.computeTriadicCensus.getValue()).booleanValue()) {
                    this.triadicCensus = graph.run((GraphAnalytic)new TriadicCensus().setParallelism(parallelism));
                }
                DataSet undirectedResult = (DataSet)graph.run((GraphAlgorithm)new org.apache.flink.graph.library.clustering.undirected.TriangleListing().setPermuteResults(((Boolean)this.permuteResults.getValue()).booleanValue()).setSortTriangleVertices(((Boolean)this.sortTriangleVertices.getValue()).booleanValue()).setParallelism(parallelism));
                return undirectedResult;
            }
        }
        throw new RuntimeException("Unknown order: " + this.order);
    }

    @Override
    public void printAnalytics(PrintStream out) {
        if (((Boolean)this.computeTriadicCensus.getValue()).booleanValue()) {
            out.print("Triadic census:\n  ");
            out.println(((PrintableResult)this.triadicCensus.getResult()).toPrintableString().replace(";", "\n "));
        }
    }
}

