/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.input;

import org.apache.commons.lang3.text.WordUtils;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphCsvReader;
import org.apache.flink.graph.drivers.input.InputBase;
import org.apache.flink.graph.drivers.parameter.ChoiceParameter;
import org.apache.flink.graph.drivers.parameter.Simplify;
import org.apache.flink.graph.drivers.parameter.StringParameter;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.StringValue;

public class CSV<K extends Comparable<K>>
extends InputBase<K, NullValue, NullValue> {
    private static final String INTEGER = "integer";
    private static final String LONG = "long";
    private static final String STRING = "string";
    private ChoiceParameter type = new ChoiceParameter(this, "type").setDefaultValue("integer").addChoices("long", "string");
    private StringParameter inputFilename = new StringParameter(this, "input_filename");
    private StringParameter commentPrefix = new StringParameter(this, "comment_prefix").setDefaultValue("#");
    private StringParameter lineDelimiter = new StringParameter(this, "input_line_delimiter").setDefaultValue("\n");
    private StringParameter fieldDelimiter = new StringParameter(this, "input_field_delimiter").setDefaultValue(",");
    private Simplify simplify = new Simplify(this);

    @Override
    public String getIdentity() {
        return WordUtils.capitalize((String)this.getName()) + WordUtils.capitalize((String)((String)this.type.getValue())) + " (" + this.inputFilename + ")";
    }

    @Override
    public Graph<K, NullValue, NullValue> create(ExecutionEnvironment env) throws Exception {
        Graph graph;
        GraphCsvReader reader = Graph.fromCsvReader((String)((String)this.inputFilename.getValue()), (ExecutionEnvironment)env).ignoreCommentsEdges((String)this.commentPrefix.getValue()).lineDelimiterEdges((String)this.lineDelimiter.getValue()).fieldDelimiterEdges((String)this.fieldDelimiter.getValue());
        switch ((String)this.type.getValue()) {
            case "integer": {
                graph = reader.keyType(IntValue.class);
                break;
            }
            case "long": {
                graph = reader.keyType(LongValue.class);
                break;
            }
            case "string": {
                graph = reader.keyType(StringValue.class);
                break;
            }
            default: {
                throw new ProgramParametrizationException("Unknown type '" + (String)this.type.getValue() + "'");
            }
        }
        return this.simplify.simplify(graph, ((Long)this.parallelism.getValue()).intValue());
    }
}

