/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.input;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.drivers.input.GeneratedGraph;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;

public class GridGraph
extends GeneratedGraph {
    private static final String PREFIX = "dim";
    private List<Dimension> dimensions = new ArrayList<Dimension>();

    @Override
    public String getUsage() {
        return "--dim0 size:wrap_endpoints [--dim size:wrap_endpoints [--dim ...]] " + super.getUsage();
    }

    @Override
    public void configure(ParameterTool parameterTool) throws ProgramParametrizationException {
        super.configure(parameterTool);
        TreeMap<Integer, String> dimensionMap = new TreeMap<Integer, String>();
        for (String key : parameterTool.toMap().keySet()) {
            if (!key.startsWith(PREFIX)) continue;
            int dimensionId = Integer.parseInt(key.substring(PREFIX.length()));
            dimensionMap.put(dimensionId, parameterTool.get(key));
        }
        for (String field : dimensionMap.values()) {
            this.dimensions.add(new Dimension(field));
        }
    }

    @Override
    public String getIdentity() {
        return this.getName() + " (" + this.dimensions + ")";
    }

    @Override
    protected long vertexCount() {
        BigInteger vertexCount = BigInteger.ONE;
        for (Dimension dimension : this.dimensions) {
            vertexCount = vertexCount.multiply(BigInteger.valueOf(dimension.size));
        }
        if (vertexCount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new ProgramParametrizationException("Number of vertices in grid graph '" + vertexCount + "' is greater than Long.MAX_VALUE.");
        }
        return vertexCount.longValue();
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> create(ExecutionEnvironment env) {
        org.apache.flink.graph.generator.GridGraph graph = new org.apache.flink.graph.generator.GridGraph(env);
        for (Dimension dimension : this.dimensions) {
            graph.addDimension(dimension.size, dimension.wrapEndpoints);
        }
        return graph.setParallelism(((Long)this.parallelism.getValue()).intValue()).generate();
    }

    private static class Dimension {
        private long size;
        private boolean wrapEndpoints;

        public Dimension(String field) {
            ProgramParametrizationException exception = new ProgramParametrizationException("Grid dimension must use a colon to separate the integer size and boolean indicating whether the dimension endpoints are connected: '" + field + "'");
            if (!field.contains(":")) {
                throw exception;
            }
            String[] parts = field.split(":");
            if (parts.length != 2) {
                throw exception;
            }
            try {
                this.size = Long.parseLong(parts[0]);
                this.wrapEndpoints = Boolean.parseBoolean(parts[1]);
            }
            catch (NumberFormatException ex) {
                throw exception;
            }
        }

        public String toString() {
            return Long.toString(this.size) + (this.wrapEndpoints ? "+" : "\u229e");
        }
    }
}

