/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.output;

import java.io.PrintStream;
import java.util.List;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.asm.dataset.Collect;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.drivers.output.OutputBase;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;

public class Print<T>
extends OutputBase<T> {
    private BooleanParameter printExecutionPlan = new BooleanParameter(this, "__print_execution_plan");

    @Override
    public void write(String executionName, PrintStream out, DataSet<T> data) throws Exception {
        List results;
        Collect collector = new Collect().run(data);
        if (((Boolean)this.printExecutionPlan.getValue()).booleanValue()) {
            out.println();
            out.println(data.getExecutionEnvironment().getExecutionPlan());
        }
        if ((results = (List)collector.execute(executionName)).size() == 0) {
            return;
        }
        out.println();
        if (results.get(0) instanceof PrintableResult) {
            for (Object result : results) {
                out.println(((PrintableResult)result).toPrintableString());
            }
        } else {
            for (Object result : results) {
                out.println(result);
            }
        }
    }
}

