/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.parameter;

import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;
import org.apache.flink.graph.drivers.parameter.SimpleParameter;
import org.apache.flink.graph.drivers.parameter.Util;

public class DoubleParameter
extends SimpleParameter<Double> {
    private boolean hasMinimumValue = false;
    private boolean minimumValueInclusive;
    private double minimumValue;
    private boolean hasMaximumValue = false;
    private boolean maximumValueInclusive;
    private double maximumValue;

    public DoubleParameter(ParameterizedBase owner, String name) {
        super(owner, name);
    }

    public DoubleParameter setDefaultValue(double defaultValue) {
        super.setDefaultValue(defaultValue);
        if (this.hasMinimumValue) {
            if (this.minimumValueInclusive) {
                Util.checkParameter(defaultValue >= this.minimumValue, "Default value (" + defaultValue + ") must be greater than or equal to minimum (" + this.minimumValue + ")");
            } else {
                Util.checkParameter(defaultValue > this.minimumValue, "Default value (" + defaultValue + ") must be greater than minimum (" + this.minimumValue + ")");
            }
        }
        if (this.hasMaximumValue) {
            if (this.maximumValueInclusive) {
                Util.checkParameter(defaultValue <= this.maximumValue, "Default value (" + defaultValue + ") must be less than or equal to maximum (" + this.maximumValue + ")");
            } else {
                Util.checkParameter(defaultValue < this.maximumValue, "Default value (" + defaultValue + ") must be less than maximum (" + this.maximumValue + ")");
            }
        }
        return this;
    }

    public DoubleParameter setMinimumValue(double minimumValue, boolean inclusive) {
        if (this.hasDefaultValue) {
            if (inclusive) {
                Util.checkParameter(minimumValue <= (Double)this.defaultValue, "Minimum value (" + minimumValue + ") must be less than or equal to default (" + this.defaultValue + ")");
            } else {
                Util.checkParameter(minimumValue < (Double)this.defaultValue, "Minimum value (" + minimumValue + ") must be less than default (" + this.defaultValue + ")");
            }
        } else if (this.hasMaximumValue) {
            if (inclusive && this.maximumValueInclusive) {
                Util.checkParameter(minimumValue <= this.maximumValue, "Minimum value (" + minimumValue + ") must be less than or equal to maximum (" + this.maximumValue + ")");
            } else {
                Util.checkParameter(minimumValue < this.maximumValue, "Minimum value (" + minimumValue + ") must be less than maximum (" + this.maximumValue + ")");
            }
        }
        this.hasMinimumValue = true;
        this.minimumValue = minimumValue;
        this.minimumValueInclusive = inclusive;
        return this;
    }

    public DoubleParameter setMaximumValue(double maximumValue, boolean inclusive) {
        if (this.hasDefaultValue) {
            if (inclusive) {
                Util.checkParameter(maximumValue >= (Double)this.defaultValue, "Maximum value (" + maximumValue + ") must be greater than or equal to default (" + this.defaultValue + ")");
            } else {
                Util.checkParameter(maximumValue > (Double)this.defaultValue, "Maximum value (" + maximumValue + ") must be greater than default (" + this.defaultValue + ")");
            }
        } else if (this.hasMinimumValue) {
            if (inclusive && this.minimumValueInclusive) {
                Util.checkParameter(maximumValue >= this.minimumValue, "Maximum value (" + maximumValue + ") must be greater than or equal to minimum (" + this.minimumValue + ")");
            } else {
                Util.checkParameter(maximumValue > this.minimumValue, "Maximum value (" + maximumValue + ") must be greater than minimum (" + this.minimumValue + ")");
            }
        }
        this.hasMaximumValue = true;
        this.maximumValue = maximumValue;
        this.maximumValueInclusive = inclusive;
        return this;
    }

    @Override
    public void configure(ParameterTool parameterTool) {
        this.value = this.hasDefaultValue ? parameterTool.getDouble(this.name, ((Double)this.defaultValue).doubleValue()) : parameterTool.getDouble(this.name);
        if (this.hasMinimumValue) {
            if (this.minimumValueInclusive) {
                Util.checkParameter((Double)this.value >= this.minimumValue, this.name + " must be greater than or equal to " + this.minimumValue);
            } else {
                Util.checkParameter((Double)this.value > this.minimumValue, this.name + " must be greater than " + this.minimumValue);
            }
        }
        if (this.hasMaximumValue) {
            if (this.maximumValueInclusive) {
                Util.checkParameter((Double)this.value <= this.maximumValue, this.name + " must be less than or equal to " + this.maximumValue);
            } else {
                Util.checkParameter((Double)this.value < this.maximumValue, this.name + " must be less than " + this.maximumValue);
            }
        }
    }

    public String toString() {
        return Double.toString((Double)this.value);
    }
}

