/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.parameter;

import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.graph.drivers.parameter.Parameter;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;
import org.apache.flink.graph.drivers.parameter.Util;

public class IterationConvergence
implements Parameter<Value> {
    private final int defaultIterations;
    private final Value value = new Value();

    public IterationConvergence(ParameterizedBase owner, int defaultIterations) {
        owner.addParameter(this);
        this.defaultIterations = defaultIterations;
    }

    @Override
    public String getUsage() {
        return "[--iterations ITERATIONS] [--convergence_threshold CONVERGENCE_THRESHOLD] ";
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void configure(ParameterTool parameterTool) {
        if (!parameterTool.has("iterations") && !parameterTool.has("convergence_threshold")) {
            this.value.iterations = this.defaultIterations;
            this.value.convergenceThreshold = Double.MAX_VALUE;
        } else {
            this.value.iterations = parameterTool.getInt("iterations", Integer.MAX_VALUE);
            Util.checkParameter(this.value.iterations > 0, "iterations must be greater than zero");
            this.value.convergenceThreshold = parameterTool.getDouble("convergence_threshold", Double.MAX_VALUE);
            Util.checkParameter(this.value.convergenceThreshold > 0.0, "convergence threshold must be greater than zero");
        }
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public static class Value {
        public int iterations;
        public double convergenceThreshold;
    }
}

