/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.parameter;

import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;
import org.apache.flink.graph.drivers.parameter.SimpleParameter;
import org.apache.flink.graph.drivers.parameter.Util;

public class LongParameter
extends SimpleParameter<Long> {
    private boolean hasMinimumValue = false;
    private long minimumValue;
    private boolean hasMaximumValue = false;
    private long maximumValue;

    public LongParameter(ParameterizedBase owner, String name) {
        super(owner, name);
    }

    public LongParameter setDefaultValue(long defaultValue) {
        super.setDefaultValue(defaultValue);
        return this;
    }

    public LongParameter setMinimumValue(long minimumValue) {
        if (this.hasMaximumValue) {
            Util.checkParameter(minimumValue <= this.maximumValue, "Minimum value (" + minimumValue + ") must be less than or equal to maximum (" + this.maximumValue + ")");
        }
        this.hasMinimumValue = true;
        this.minimumValue = minimumValue;
        return this;
    }

    public LongParameter setMaximumValue(long maximumValue) {
        if (this.hasMinimumValue) {
            Util.checkParameter(maximumValue >= this.minimumValue, "Maximum value (" + maximumValue + ") must be greater than or equal to minimum (" + this.minimumValue + ")");
        }
        this.hasMaximumValue = true;
        this.maximumValue = maximumValue;
        return this;
    }

    @Override
    public void configure(ParameterTool parameterTool) {
        if (this.hasDefaultValue && !parameterTool.has(this.name)) {
            this.value = this.defaultValue;
        } else {
            this.value = parameterTool.getLong(this.name);
            if (this.hasMinimumValue) {
                Util.checkParameter((Long)this.value >= this.minimumValue, this.name + " must be greater than or equal to " + this.minimumValue);
            }
            if (this.hasMaximumValue) {
                Util.checkParameter((Long)this.value <= this.maximumValue, this.name + " must be less than or equal to " + this.maximumValue);
            }
        }
    }

    public String toString() {
        return Long.toString((Long)this.value);
    }
}

