/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.transform;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.asm.result.TranslatableResult;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.graph.asm.translate.TranslateGraphIds;
import org.apache.flink.graph.asm.translate.translators.LongValueToStringValue;
import org.apache.flink.graph.asm.translate.translators.LongValueToUnsignedIntValue;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;
import org.apache.flink.graph.drivers.parameter.ChoiceParameter;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;
import org.apache.flink.graph.drivers.transform.LongValueWithProperHashCode;
import org.apache.flink.graph.drivers.transform.Transform;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Collector;

public class GraphKeyTypeTransform<VV, EV>
extends ParameterizedBase
implements Transform<Graph<LongValue, VV, EV>, Graph<?, VV, EV>, DataSet<TranslatableResult<?>>, DataSet<TranslatableResult<?>>> {
    private static final String BYTE = "byte";
    private static final String NATIVE_BYTE = "nativeByte";
    private static final String SHORT = "short";
    private static final String NATIVE_SHORT = "nativeShort";
    private static final String CHAR = "char";
    private static final String NATIVE_CHAR = "nativeChar";
    private static final String INTEGER = "integer";
    private static final String NATIVE_INTEGER = "nativeInteger";
    private static final String LONG = "long";
    private static final String NATIVE_LONG = "nativeLong";
    private static final String FLOAT = "float";
    private static final String NATIVE_FLOAT = "nativeFloat";
    private static final String DOUBLE = "double";
    private static final String NATIVE_DOUBLE = "nativeDouble";
    private static final String STRING = "string";
    private static final String NATIVE_STRING = "nativeString";
    private ChoiceParameter type = new ChoiceParameter(this, "type").setDefaultValue("integer").addChoices("long", "string").addHiddenChoices("byte", "nativeByte", "short", "nativeShort", "char", "nativeChar", "nativeInteger", "nativeLong", "float", "nativeFloat", "double", "nativeDouble", "nativeString");
    private final BooleanParameter disableTypeReversal = new BooleanParameter(this, "__disable_type_reversal");
    private final long vertexCount;

    public GraphKeyTypeTransform(long vertexCount) {
        this.vertexCount = vertexCount;
    }

    @Override
    public String getIdentity() {
        return this.type.toString();
    }

    @Override
    public Graph<?, VV, EV> transformInput(Graph<LongValue, VV, EV> input) throws Exception {
        long maxVertexCount = Long.MAX_VALUE;
        Object translator = null;
        switch ((String)this.type.getValue()) {
            case "byte": {
                maxVertexCount = 256L;
                translator = new LongValueToUnsignedByteValue();
                break;
            }
            case "nativeByte": {
                maxVertexCount = 256L;
                translator = new LongValueToUnsignedByte();
                break;
            }
            case "short": {
                maxVertexCount = 65536L;
                translator = new LongValueToUnsignedShortValue();
                break;
            }
            case "nativeShort": {
                maxVertexCount = 65536L;
                translator = new LongValueToUnsignedShort();
                break;
            }
            case "char": {
                maxVertexCount = 65536L;
                translator = new LongValueToCharValue();
                break;
            }
            case "nativeChar": {
                maxVertexCount = 65536L;
                translator = new LongValueToChar();
                break;
            }
            case "integer": {
                maxVertexCount = 0x100000000L;
                translator = new LongValueToUnsignedIntValue();
                break;
            }
            case "nativeInteger": {
                maxVertexCount = 0x100000000L;
                translator = new LongValueToUnsignedInt();
                break;
            }
            case "long": {
                break;
            }
            case "nativeLong": {
                translator = new LongValueToLong();
                break;
            }
            case "float": {
                maxVertexCount = 0x100000000L;
                translator = new LongValueToUnsignedFloatValue();
                break;
            }
            case "nativeFloat": {
                maxVertexCount = 0x100000000L;
                translator = new LongValueToUnsignedFloat();
                break;
            }
            case "double": {
                translator = new LongValueToDoubleValue();
                break;
            }
            case "nativeDouble": {
                translator = new LongValueToDouble();
                break;
            }
            case "string": {
                translator = new LongValueToStringValue();
                break;
            }
            case "nativeString": {
                translator = new LongValueToString();
                break;
            }
            default: {
                throw new ProgramParametrizationException("Unknown type '" + (String)this.type.getValue() + "'");
            }
        }
        if (this.vertexCount > maxVertexCount) {
            throw new ProgramParametrizationException("Vertex count '" + this.vertexCount + "' must be no greater than " + maxVertexCount + " for type '" + (String)this.type.getValue() + "'.");
        }
        if (translator == null) {
            return input;
        }
        return (Graph)input.run((GraphAlgorithm)new TranslateGraphIds((TranslateFunction)translator));
    }

    @Override
    public DataSet<TranslatableResult<?>> transformResult(final DataSet<TranslatableResult<?>> result) throws Exception {
        if (((Boolean)this.disableTypeReversal.getValue()).booleanValue()) {
            return result;
        }
        long minVertexCount = 0L;
        Object translator = null;
        switch ((String)this.type.getValue()) {
            case "byte": {
                minVertexCount = 129L;
                translator = new UnsignedByteValueToLongValueWithProperHashCode();
                break;
            }
            case "nativeByte": {
                minVertexCount = 129L;
                translator = new UnsignedByteToLongValueWithProperHashCode();
                break;
            }
            case "short": {
                minVertexCount = 32769L;
                translator = new UnsignedShortValueToLongValueWithProperHashCode();
                break;
            }
            case "nativeShort": {
                minVertexCount = 32769L;
                translator = new UnsignedShortToLongValueWithProperHashCode();
                break;
            }
            case "char": {
                break;
            }
            case "nativeChar": {
                break;
            }
            case "integer": {
                minVertexCount = 0x80000001L;
                translator = new UnsignedIntValueToLongValueWithProperHashCode();
                break;
            }
            case "nativeInteger": {
                minVertexCount = 0x80000001L;
                translator = new UnsignedIntToLongValueWithProperHashCode();
                break;
            }
            case "long": {
                translator = new LongValueToLongValueWithProperHashCode();
                break;
            }
            case "nativeLong": {
                break;
            }
            case "float": {
                translator = new UnsignedFloatValueToLongValueWithProperHashCode();
                break;
            }
            case "nativeFloat": {
                translator = new UnsignedFloatToLongValueWithProperHashCode();
                break;
            }
            case "double": {
                translator = new DoubleValueToLongValueWithProperHashCode();
                break;
            }
            case "nativeDouble": {
                translator = new DoubleToLongValueWithProperHashCode();
                break;
            }
            case "string": {
                translator = new StringValueToLongValueWithProperHashCode();
                break;
            }
            case "nativeString": {
                translator = new StringToLongValueWithProperHashCode();
                break;
            }
            default: {
                throw new ProgramParametrizationException("Unknown type '" + (String)this.type.getValue() + "'");
            }
        }
        if (translator == null || this.vertexCount < minVertexCount) {
            return result;
        }
        TypeInformation typeInfo = TypeExtractor.createTypeInfo((Type)new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{LongValueWithProperHashCode.class};
            }

            @Override
            public Type getRawType() {
                return result.getType().getTypeClass();
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        });
        return result.flatMap(new TranslateResultIDs<LongValue, LongValueWithProperHashCode>((TranslateFunction<LongValue, LongValueWithProperHashCode>)translator)).returns(typeInfo).name("Translate results IDs");
    }

    static class StringToLongValueWithProperHashCode
    implements TranslateFunction<String, LongValueWithProperHashCode> {
        StringToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(String value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(Long.valueOf(value));
            return reuse;
        }
    }

    static class StringValueToLongValueWithProperHashCode
    implements TranslateFunction<StringValue, LongValueWithProperHashCode> {
        StringValueToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(StringValue value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(Long.parseLong(value.getValue()));
            return reuse;
        }
    }

    static class DoubleToLongValueWithProperHashCode
    implements TranslateFunction<Double, LongValueWithProperHashCode> {
        DoubleToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(Double value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(Double.doubleToRawLongBits(value));
            return reuse;
        }
    }

    static class DoubleValueToLongValueWithProperHashCode
    implements TranslateFunction<DoubleValue, LongValueWithProperHashCode> {
        DoubleValueToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(DoubleValue value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(Double.doubleToRawLongBits(value.getValue()));
            return reuse;
        }
    }

    static class UnsignedFloatToLongValueWithProperHashCode
    implements TranslateFunction<Float, LongValueWithProperHashCode> {
        UnsignedFloatToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(Float value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(0xFFFFFFFFL & (long)Float.floatToRawIntBits(value.floatValue()));
            return reuse;
        }
    }

    static class UnsignedFloatValueToLongValueWithProperHashCode
    implements TranslateFunction<FloatValue, LongValueWithProperHashCode> {
        UnsignedFloatValueToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(FloatValue value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(0xFFFFFFFFL & (long)Float.floatToRawIntBits(value.getValue()));
            return reuse;
        }
    }

    static class LongValueToLongValueWithProperHashCode
    implements TranslateFunction<LongValue, LongValueWithProperHashCode> {
        LongValueToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(LongValue value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(value.getValue());
            return reuse;
        }
    }

    static class UnsignedIntToLongValueWithProperHashCode
    implements TranslateFunction<Integer, LongValueWithProperHashCode> {
        public static final long MIN_VERTEX_COUNT = 0x80000001L;

        UnsignedIntToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(Integer value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(0xFFFFFFFFL & (long)value.intValue());
            return reuse;
        }
    }

    static class UnsignedIntValueToLongValueWithProperHashCode
    implements TranslateFunction<IntValue, LongValueWithProperHashCode> {
        public static final long MIN_VERTEX_COUNT = 0x80000001L;

        UnsignedIntValueToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(IntValue value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(0xFFFFFFFFL & (long)value.getValue());
            return reuse;
        }
    }

    static class UnsignedShortToLongValueWithProperHashCode
    implements TranslateFunction<Short, LongValueWithProperHashCode> {
        public static final long MIN_VERTEX_COUNT = 32769L;

        UnsignedShortToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(Short value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue((long)(value & 0xFFFF));
            return reuse;
        }
    }

    static class UnsignedShortValueToLongValueWithProperHashCode
    implements TranslateFunction<ShortValue, LongValueWithProperHashCode> {
        public static final long MIN_VERTEX_COUNT = 32769L;

        UnsignedShortValueToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(ShortValue value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(value.getValue() & 0xFFFF);
            return reuse;
        }
    }

    static class UnsignedByteToLongValueWithProperHashCode
    implements TranslateFunction<Byte, LongValueWithProperHashCode> {
        public static final long MIN_VERTEX_COUNT = 129L;

        UnsignedByteToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(Byte value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue((long)(value & 0xFF));
            return reuse;
        }
    }

    static class UnsignedByteValueToLongValueWithProperHashCode
    implements TranslateFunction<ByteValue, LongValueWithProperHashCode> {
        public static final long MIN_VERTEX_COUNT = 129L;

        UnsignedByteValueToLongValueWithProperHashCode() {
        }

        public LongValueWithProperHashCode translate(ByteValue value, LongValueWithProperHashCode reuse) throws Exception {
            if (reuse == null) {
                reuse = new LongValueWithProperHashCode();
            }
            reuse.setValue(value.getValue() & 0xFF);
            return reuse;
        }
    }

    private static class TranslateResultIDs<T, U>
    implements FlatMapFunction<TranslatableResult<T>, TranslatableResult<U>> {
        private final TranslateFunction<T, U> translator;
        private transient TranslatableResult<U> reuse = null;

        public TranslateResultIDs(TranslateFunction<T, U> translator) {
            this.translator = translator;
        }

        public void flatMap(TranslatableResult<T> value, Collector<TranslatableResult<U>> out) throws Exception {
            this.reuse = value.translate(this.translator, this.reuse, out);
        }
    }

    static class LongValueToString
    implements TranslateFunction<LongValue, String> {
        LongValueToString() {
        }

        public String translate(LongValue value, String reuse) throws Exception {
            return Long.toString(value.getValue());
        }
    }

    static class LongValueToDouble
    implements TranslateFunction<LongValue, Double> {
        LongValueToDouble() {
        }

        public Double translate(LongValue value, Double reuse) throws Exception {
            return Double.longBitsToDouble(value.getValue());
        }
    }

    static class LongValueToDoubleValue
    implements TranslateFunction<LongValue, DoubleValue> {
        LongValueToDoubleValue() {
        }

        public DoubleValue translate(LongValue value, DoubleValue reuse) throws Exception {
            if (reuse == null) {
                reuse = new DoubleValue();
            }
            reuse.setValue(Double.longBitsToDouble(value.getValue()));
            return reuse;
        }
    }

    static class LongValueToUnsignedFloat
    implements TranslateFunction<LongValue, Float> {
        public static final long MAX_VERTEX_COUNT = 0x100000000L;

        LongValueToUnsignedFloat() {
        }

        public Float translate(LongValue value, Float reuse) throws Exception {
            long l = value.getValue();
            if (l < 0L || l >= 0x100000000L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to float.");
            }
            return Float.valueOf(Float.intBitsToFloat((int)(l & 0xFFFFFFFFL)));
        }
    }

    static class LongValueToUnsignedFloatValue
    implements TranslateFunction<LongValue, FloatValue> {
        public static final long MAX_VERTEX_COUNT = 0x100000000L;

        LongValueToUnsignedFloatValue() {
        }

        public FloatValue translate(LongValue value, FloatValue reuse) throws Exception {
            long l;
            if (reuse == null) {
                reuse = new FloatValue();
            }
            if ((l = value.getValue()) < 0L || l >= 0x100000000L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to float.");
            }
            reuse.setValue(Float.intBitsToFloat((int)(l & 0xFFFFFFFFL)));
            return reuse;
        }
    }

    static class LongValueToLong
    implements TranslateFunction<LongValue, Long> {
        LongValueToLong() {
        }

        public Long translate(LongValue value, Long reuse) throws Exception {
            return value.getValue();
        }
    }

    static class LongValueToUnsignedInt
    implements TranslateFunction<LongValue, Integer> {
        public static final long MAX_VERTEX_COUNT = 0x100000000L;

        LongValueToUnsignedInt() {
        }

        public Integer translate(LongValue value, Integer reuse) throws Exception {
            long l = value.getValue();
            if (l < 0L || l >= 0x100000000L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to integer.");
            }
            return (int)(l & 0xFFFFFFFFL);
        }
    }

    static class LongValueToChar
    implements TranslateFunction<LongValue, Character> {
        public static final long MAX_VERTEX_COUNT = 65536L;

        LongValueToChar() {
        }

        public Character translate(LongValue value, Character reuse) throws Exception {
            long l = value.getValue();
            if (l < 0L || l >= 65536L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to char.");
            }
            return Character.valueOf((char)(l & 0xFFFFL));
        }
    }

    static class LongValueToCharValue
    implements TranslateFunction<LongValue, CharValue> {
        public static final long MAX_VERTEX_COUNT = 65536L;

        LongValueToCharValue() {
        }

        public CharValue translate(LongValue value, CharValue reuse) throws Exception {
            long l;
            if (reuse == null) {
                reuse = new CharValue();
            }
            if ((l = value.getValue()) < 0L || l >= 65536L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to char.");
            }
            reuse.setValue((char)(l & 0xFFFFL));
            return reuse;
        }
    }

    static class LongValueToUnsignedShort
    implements TranslateFunction<LongValue, Short> {
        public static final long MAX_VERTEX_COUNT = 65536L;

        LongValueToUnsignedShort() {
        }

        public Short translate(LongValue value, Short reuse) throws Exception {
            long l = value.getValue();
            if (l < 0L || l >= 65536L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to short.");
            }
            return (short)(l & 0xFFFFL);
        }
    }

    static class LongValueToUnsignedShortValue
    implements TranslateFunction<LongValue, ShortValue> {
        public static final long MAX_VERTEX_COUNT = 65536L;

        LongValueToUnsignedShortValue() {
        }

        public ShortValue translate(LongValue value, ShortValue reuse) throws Exception {
            long l;
            if (reuse == null) {
                reuse = new ShortValue();
            }
            if ((l = value.getValue()) < 0L || l >= 65536L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to short.");
            }
            reuse.setValue((short)(l & 0xFFFFL));
            return reuse;
        }
    }

    static class LongValueToUnsignedByte
    implements TranslateFunction<LongValue, Byte> {
        public static final long MAX_VERTEX_COUNT = 256L;

        LongValueToUnsignedByte() {
        }

        public Byte translate(LongValue value, Byte reuse) throws Exception {
            long l = value.getValue();
            if (l < 0L || l >= 256L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to byte.");
            }
            return (byte)(l & 0xFFL);
        }
    }

    static class LongValueToUnsignedByteValue
    implements TranslateFunction<LongValue, ByteValue> {
        public static final long MAX_VERTEX_COUNT = 256L;

        LongValueToUnsignedByteValue() {
        }

        public ByteValue translate(LongValue value, ByteValue reuse) throws Exception {
            long l;
            if (reuse == null) {
                reuse = new ByteValue();
            }
            if ((l = value.getValue()) < 0L || l >= 256L) {
                throw new IllegalArgumentException("Cannot cast long value " + value + " to byte.");
            }
            reuse.setValue((byte)(l & 0xFFL));
            return reuse;
        }
    }
}

