/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples;

import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.examples.data.SingleSourceShortestPathsData;
import org.apache.flink.graph.gsa.ApplyFunction;
import org.apache.flink.graph.gsa.GatherFunction;
import org.apache.flink.graph.gsa.Neighbor;
import org.apache.flink.graph.gsa.SumFunction;
import org.apache.flink.graph.utils.Tuple3ToEdgeMap;

public class GSASingleSourceShortestPaths
implements ProgramDescription {
    private static boolean fileOutput = false;
    private static Long srcVertexId = 1L;
    private static String edgesInputPath = null;
    private static String outputPath = null;
    private static int maxIterations = 5;

    public static void main(String[] args) throws Exception {
        if (!GSASingleSourceShortestPaths.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Edge<Long, Double>> edges = GSASingleSourceShortestPaths.getEdgeDataSet(env);
        Graph graph = Graph.fromDataSet(edges, (MapFunction)new InitVertices(srcVertexId), (ExecutionEnvironment)env);
        Graph result = graph.runGatherSumApplyIteration((GatherFunction)new CalculateDistances(), (SumFunction)new ChooseMinDistance(), (ApplyFunction)new UpdateDistance(), maxIterations);
        DataSet singleSourceShortestPaths = result.getVertices();
        if (fileOutput) {
            singleSourceShortestPaths.writeAsCsv(outputPath, "\n", ",");
            env.execute("GSA Single Source Shortest Paths");
        } else {
            singleSourceShortestPaths.print();
        }
    }

    private static boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length != 4) {
                System.err.println("Usage: GSASingleSourceShortestPaths <source vertex id> <input edges path> <output path> <num iterations>");
                return false;
            }
            fileOutput = true;
            srcVertexId = Long.parseLong(args[0]);
            edgesInputPath = args[1];
            outputPath = args[2];
            maxIterations = Integer.parseInt(args[3]);
        } else {
            System.out.println("Executing GSASingle Source Shortest Paths example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("Usage: GSASingleSourceShortestPaths <source vertex id> <input edges path> <output path> <num iterations>");
        }
        return true;
    }

    private static DataSet<Edge<Long, Double>> getEdgeDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgesInputPath).fieldDelimiter("\t").lineDelimiter("\n").types(Long.class, Long.class, Double.class).map((MapFunction)new Tuple3ToEdgeMap());
        }
        return SingleSourceShortestPathsData.getDefaultEdgeDataSet(env);
    }

    public String getDescription() {
        return "GSA Single Source Shortest Paths";
    }

    private static final class UpdateDistance
    extends ApplyFunction<Long, Double, Double> {
        private UpdateDistance() {
        }

        public void apply(Double newDistance, Double oldDistance) {
            if (newDistance < oldDistance) {
                this.setResult(newDistance);
            }
        }
    }

    private static final class ChooseMinDistance
    extends SumFunction<Double, Double, Double> {
        private ChooseMinDistance() {
        }

        public Double sum(Double newValue, Double currentValue) {
            return Math.min(newValue, currentValue);
        }
    }

    private static final class CalculateDistances
    extends GatherFunction<Double, Double, Double> {
        private CalculateDistances() {
        }

        public Double gather(Neighbor<Double, Double> neighbor) {
            return (Double)neighbor.getNeighborValue() + (Double)neighbor.getEdgeValue();
        }
    }

    private static final class InitVertices
    implements MapFunction<Long, Double> {
        private long srcId;

        public InitVertices(long srcId) {
            this.srcId = srcId;
        }

        public Double map(Long id) {
            if (id.equals(this.srcId)) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
    }
}

