/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples;

import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.examples.data.SingleSourceShortestPathsData;
import org.apache.flink.graph.pregel.ComputeFunction;
import org.apache.flink.graph.pregel.MessageCombiner;
import org.apache.flink.graph.pregel.MessageIterator;
import org.apache.flink.graph.utils.Tuple3ToEdgeMap;

public class PregelSSSP
implements ProgramDescription {
    private static boolean fileOutput = false;
    private static Long srcVertexId = 1L;
    private static String edgesInputPath = null;
    private static String outputPath = null;
    private static int maxIterations = 5;

    public static void main(String[] args) throws Exception {
        if (!PregelSSSP.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Edge<Long, Double>> edges = PregelSSSP.getEdgesDataSet(env);
        Graph graph = Graph.fromDataSet(edges, (MapFunction)new InitVertices(), (ExecutionEnvironment)env);
        Graph result = graph.runVertexCentricIteration((ComputeFunction)new SSSPComputeFunction(srcVertexId), (MessageCombiner)new SSSPCombiner(), maxIterations);
        DataSet singleSourceShortestPaths = result.getVertices();
        if (fileOutput) {
            singleSourceShortestPaths.writeAsCsv(outputPath, "\n", ",");
            env.execute("Pregel Single Source Shortest Paths Example");
        } else {
            singleSourceShortestPaths.print();
        }
    }

    private static boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length != 4) {
                System.err.println("Usage: PregelSSSP <source vertex id> <input edges path> <output path> <num iterations>");
                return false;
            }
            fileOutput = true;
            srcVertexId = Long.parseLong(args[0]);
            edgesInputPath = args[1];
            outputPath = args[2];
            maxIterations = Integer.parseInt(args[3]);
        } else {
            System.out.println("Executing Pregel Single Source Shortest Paths example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("Usage: PregelSSSP <source vertex id> <input edges path> <output path> <num iterations>");
        }
        return true;
    }

    private static DataSet<Edge<Long, Double>> getEdgesDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgesInputPath).lineDelimiter("\n").fieldDelimiter("\t").ignoreComments("%").types(Long.class, Long.class, Double.class).map((MapFunction)new Tuple3ToEdgeMap());
        }
        return SingleSourceShortestPathsData.getDefaultEdgeDataSet(env);
    }

    public String getDescription() {
        return "Vertex-centric Single Source Shortest Paths";
    }

    public static final class SSSPCombiner
    extends MessageCombiner<Long, Double> {
        public void combineMessages(MessageIterator<Double> messages) {
            double minMessage = Double.POSITIVE_INFINITY;
            for (Double msg : messages) {
                minMessage = Math.min(minMessage, msg);
            }
            this.sendCombinedMessage(minMessage);
        }
    }

    public static final class SSSPComputeFunction
    extends ComputeFunction<Long, Double, Double, Double> {
        private final long srcId;

        public SSSPComputeFunction(long src) {
            this.srcId = src;
        }

        public void compute(Vertex<Long, Double> vertex, MessageIterator<Double> messages) {
            double minDistance = ((Long)vertex.getId()).equals(this.srcId) ? 0.0 : Double.POSITIVE_INFINITY;
            for (Double msg : messages) {
                minDistance = Math.min(minDistance, msg);
            }
            if (minDistance < (Double)vertex.getValue()) {
                this.setNewVertexValue(minDistance);
                for (Edge e : this.getEdges()) {
                    this.sendMessageTo(e.getTarget(), minDistance + (Double)e.getValue());
                }
            }
        }
    }

    private static final class InitVertices
    implements MapFunction<Long, Double> {
        private InitVertices() {
        }

        public Double map(Long id) {
            return Double.POSITIVE_INFINITY;
        }
    }
}

