/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples.data;

import java.util.ArrayList;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;

public class CommunityDetectionData {
    public static final Integer MAX_ITERATIONS = 30;
    public static final double DELTA = 0.5;
    public static final String COMMUNITIES_SINGLE_ITERATION = "1,5\n2,6\n3,1\n4,1\n5,1\n6,8\n7,8\n8,7";
    public static final String COMMUNITIES_WITH_TIE = "1,2\n2,1\n3,1\n4,1\n5,1";

    public static DataSet<Edge<Long, Double>> getDefaultEdgeDataSet(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(new Edge((Object)1L, (Object)2L, (Object)1.0));
        edges.add(new Edge((Object)1L, (Object)3L, (Object)2.0));
        edges.add(new Edge((Object)1L, (Object)4L, (Object)3.0));
        edges.add(new Edge((Object)2L, (Object)3L, (Object)4.0));
        edges.add(new Edge((Object)2L, (Object)4L, (Object)5.0));
        edges.add(new Edge((Object)3L, (Object)5L, (Object)6.0));
        edges.add(new Edge((Object)5L, (Object)6L, (Object)7.0));
        edges.add(new Edge((Object)5L, (Object)7L, (Object)8.0));
        edges.add(new Edge((Object)6L, (Object)7L, (Object)9.0));
        edges.add(new Edge((Object)7L, (Object)12L, (Object)10.0));
        edges.add(new Edge((Object)8L, (Object)9L, (Object)11.0));
        edges.add(new Edge((Object)8L, (Object)10L, (Object)12.0));
        edges.add(new Edge((Object)8L, (Object)11L, (Object)13.0));
        edges.add(new Edge((Object)9L, (Object)10L, (Object)14.0));
        edges.add(new Edge((Object)9L, (Object)11L, (Object)15.0));
        edges.add(new Edge((Object)10L, (Object)11L, (Object)16.0));
        edges.add(new Edge((Object)10L, (Object)12L, (Object)17.0));
        edges.add(new Edge((Object)11L, (Object)12L, (Object)18.0));
        return env.fromCollection(edges);
    }

    public static DataSet<Edge<Long, Double>> getSimpleEdgeDataSet(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(new Edge((Object)1L, (Object)2L, (Object)1.0));
        edges.add(new Edge((Object)1L, (Object)3L, (Object)2.0));
        edges.add(new Edge((Object)1L, (Object)4L, (Object)3.0));
        edges.add(new Edge((Object)1L, (Object)5L, (Object)4.0));
        edges.add(new Edge((Object)2L, (Object)6L, (Object)5.0));
        edges.add(new Edge((Object)6L, (Object)7L, (Object)6.0));
        edges.add(new Edge((Object)6L, (Object)8L, (Object)7.0));
        edges.add(new Edge((Object)7L, (Object)8L, (Object)8.0));
        return env.fromCollection(edges);
    }

    private CommunityDetectionData() {
    }

    public static DataSet<Edge<Long, Double>> getTieEdgeDataSet(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(new Edge((Object)1L, (Object)2L, (Object)1.0));
        edges.add(new Edge((Object)1L, (Object)3L, (Object)1.0));
        edges.add(new Edge((Object)1L, (Object)4L, (Object)1.0));
        edges.add(new Edge((Object)1L, (Object)5L, (Object)1.0));
        return env.fromCollection(edges);
    }
}

