/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples.data;

import java.util.ArrayList;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.examples.EuclideanGraphWeighing;

public class EuclideanGraphData {
    public static final int NUM_VERTICES = 9;
    public static final String VERTICES = "1,1.0,1.0\n2,2.0,2.0\n3,3.0,3.0\n4,4.0,4.0\n5,5.0,5.0\n6,6.0,6.0\n7,7.0,7.0\n8,8.0,8.0\n9,9.0,9.0";
    public static final String EDGES = "1,2\n1,4\n2,3\n2,4\n2,5\n3,5\n4,5\n4,6\n5,7\n5,9\n6,7\n6,8\n7,8\n7,9\n8,9";
    public static final String RESULTED_WEIGHTED_EDGES = "1,2,1.4142135623730951\n1,4,4.242640687119285\n2,3,1.4142135623730951\n2,4,2.8284271247461903\n2,5,4.242640687119285\n3,5,2.8284271247461903\n4,5,1.4142135623730951\n4,6,2.8284271247461903\n5,7,2.8284271247461903\n5,9,5.656854249492381\n6,7,1.4142135623730951\n6,8,2.8284271247461903\n7,8,1.4142135623730951\n7,9,2.8284271247461903\n8,9,1.4142135623730951";

    public static DataSet<Vertex<Long, EuclideanGraphWeighing.Point>> getDefaultVertexDataSet(ExecutionEnvironment env) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (int i = 1; i <= 9; ++i) {
            vertices.add(new Vertex((Object)new Long(i), (Object)new EuclideanGraphWeighing.Point(new Double(i), new Double(i))));
        }
        return env.fromCollection(vertices);
    }

    public static DataSet<Edge<Long, Double>> getDefaultEdgeDataSet(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(new Edge((Object)1L, (Object)2L, (Object)0.0));
        edges.add(new Edge((Object)1L, (Object)4L, (Object)0.0));
        edges.add(new Edge((Object)2L, (Object)3L, (Object)0.0));
        edges.add(new Edge((Object)2L, (Object)4L, (Object)0.0));
        edges.add(new Edge((Object)2L, (Object)5L, (Object)0.0));
        edges.add(new Edge((Object)3L, (Object)5L, (Object)0.0));
        edges.add(new Edge((Object)4L, (Object)5L, (Object)0.0));
        edges.add(new Edge((Object)4L, (Object)6L, (Object)0.0));
        edges.add(new Edge((Object)5L, (Object)7L, (Object)0.0));
        edges.add(new Edge((Object)5L, (Object)9L, (Object)0.0));
        edges.add(new Edge((Object)6L, (Object)7L, (Object)0.0));
        edges.add(new Edge((Object)6L, (Object)8L, (Object)0.0));
        edges.add(new Edge((Object)6L, (Object)8L, (Object)0.0));
        edges.add(new Edge((Object)7L, (Object)8L, (Object)0.0));
        edges.add(new Edge((Object)7L, (Object)9L, (Object)0.0));
        edges.add(new Edge((Object)8L, (Object)9L, (Object)0.0));
        return env.fromCollection(edges);
    }

    private EuclideanGraphData() {
    }
}

